// Generic VisRDPanel
package visrd;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.*;

import java.io.File;

public class VisRDPanel extends JPanel implements ActionListener{
	protected JButton saveButton;
	protected int width, height;
	protected QuartetSet data;
	protected boolean[] quartetFlags;
	
	protected JComboBox colorQuartets;

	public VisRDPanel(QuartetSet data, int width, int height){
		this.data=data;
		
		this.width=width;
		this.height=height;
		
		quartetFlags = new boolean[data.size()];
	}

	public void actionPerformed(ActionEvent e){
		if(e.getSource()==saveButton){
			JFileChooser jfc = new JFileChooser();
	        jfc.addChoosableFileFilter(new EPSFilter());
	        		
	        if (jfc.showSaveDialog(this)==JFileChooser.APPROVE_OPTION) {
	        	MyFilter mf = (MyFilter)jfc.getFileFilter();
	            save(mf.getPath(jfc));
	        }
		}
		else if(e.getSource()==colorQuartets){
		// Update the flags of taxa
		
			Taxon[] taxon = VisRD.getAllTaxon();
			
			if(VisRD.getClusterQuartets()){
				int[][] matrix = VisRD.getTaxaMatrix();
 				int group = colorQuartets.getSelectedIndex();
				
				for(int n=0;n<data.size();n++){
					Quartet q = data.getQuartet(n);
					quartetFlags[n]=false;
					
					if(group!=0){
						for(int i=0;i<matrix[group].length&&quartetFlags[n]==false;i++){
							if(q.contains(matrix[group][i])){
								quartetFlags[n]=true;
							}
						}	
					}
				}
			}
			else{
				for(int n=0;n<data.size();n++){
					Quartet q = data.getQuartet(n);
					quartetFlags[n]=q.contains(colorQuartets.getSelectedIndex()-1);
				}
			}
			
			redraw();
		}
		else{
			doActionPerformed(e.getSource());
		}
	}
	
	public void doActionPerformed(Object source){
		VisRDGUI.displayError("doActionPerformed(Object source) must be overridden in the subclass!");
	}
	
	public JLabel getColorQuartetsLabel(){
		return new JLabel("Color quartets containing");
	}
	
	public JComboBox getColorQuartetsCombo(){
		colorQuartets = new JComboBox();
		colorQuartets.addActionListener(this);
		
		colorQuartets.addItem("[None]");
		
		if(VisRD.getClusterQuartets()){
			Object[] groupNames = VisRD.getGroupNames();
			for(int i=0;i<groupNames.length;i++){
				colorQuartets.addItem(groupNames[i] + " Taxa");
			}
		}
		else{
			Taxon[] taxon = VisRD.getAllTaxon();

			// Individual taxa
			for(int i=0;i<taxon.length;i++){
				// So we can select the taxon to be colored
				colorQuartets.addItem(taxon[i].getLabel());
			}
		}
		
		return colorQuartets;
	}
	
	public JButton getSaveButton(){
		saveButton = new JButton ("Save EPS");
        saveButton.addActionListener (this);
        return saveButton;
	}
	
	public void save(String fileName){
		try{
			org.jibble.epsgraphics.EpsGraphics2D s = IOHandler.getEpsGraphics2D(fileName,width,height);
	        draw (s,false);
	        s.flush();
	        s.close();	
		}
		catch(Exception e){
			VisRDGUI.displayError("Error occured whilst trying to save file:\n" + e.getMessage());
			e.printStackTrace();
		}
    }
    
    protected void draw(java.awt.Graphics2D g2){
    	draw(g2,true);
   	}
   	
    protected void draw(java.awt.Graphics2D g2, boolean useThread){
    	draw(g2);
   	}
    
    protected void redraw(){
    	VisRDGUI.displayError("redraw(java.awt.Graphics2D g) must be overridden in the subclass!");
    }
}

/*

	
	
	

*/