package visrd;

/**

   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

   Triplet of values class, some point on the quartet mapping triangle

*/

public class Triplet {
    private double a, b, c;
    private Triplet ots; // Original Topology Support
//    private Triplet originalTriplet;

    /**

       Constructor

    */

    public Triplet (double newA, double newB, double newC){
		a = newA;
		b = newB;
		c = newC;
    }

    public double getA(){ return a; }
    public double getB(){ return b; }
    public double getC(){ return c; }

    public void setA(double a){ this.a=a; }
    public void setB(double b){ this.b=b; }
    public void setC(double c){ this.c=c; }
    public void setOriginalTopologySupport(Triplet ots){ this.ots=ots; }
    
    public void updateCoordinates(double alpha){
 //   	originalTriplet = new Triplet(a,b,c);
    	
    	double s1 = ((1.0/3.0) + (alpha*(ots.getA()-(1.0/3.0))));
		double s2 = ((1.0/3.0) + (alpha*(ots.getB()-(1.0/3.0))));
		double s3 = ((1.0/3.0) + (alpha*(ots.getC()-(1.0/3.0))));
    	
    	a =  ((s3 / (s1 + s2 + s3)) - (s1 / (s1 + s2 + s3))) / Math.sqrt (2.0);
    	b = ((s2 / (s1 + s2 + s3)) - (1.0 / 3.0)) * Math.sqrt (3.0 / 2.0);	
    }
/*    
    public void revertToOriginalSupport(){
    	a = originalTriplet.getA();
    	b = originalTriplet.getB();
    }
*/			
	/**
	
		Goes from x, y, pos to 0..1 angle 0..1 distance pos
	
	*/

	public Triplet toPolar ()
	{
	
	    double d, phi = 0;

	    d = Math.sqrt (3.0 / 2.0) * Math.sqrt (a * a + b * b);
	
	    if (a == 0) {
			if (b < 0) {
			    phi = Math.PI;
			}
	
			if (b > 0) {
			    phi = 0;
			}
	    }
	
	    else {
			if (a > 0) {
			    phi = Math.PI / 2 - Math.atan (b / a);
			}
	
			if (a < 0) {
			    phi = - Math.PI / 2 - Math.atan (b / a);
			}
	    }
	
	    phi /= Math.PI; // Number of pi radians over pi so get number in range +/- 1
	
		return new Triplet (phi, d, c);
	}
	
	public double getPhi(){
		double phi=0.0;
		
	    if (a == 0) {
			if (b < 0) {
			    phi = Math.PI;
			}
	
			if (b > 0) {
			    phi = 0;
			}
	    }
	
	    else {
			if (a > 0) {
			    phi = Math.PI / 2 - Math.atan (b / a);
			}
	
			if (a < 0) {
			    phi = - Math.PI / 2 - Math.atan (b / a);
			}
	    }
	
	    phi /= Math.PI; // Number of pi radians over pi so get number in range +/- 1
	
		return phi;
	}
	
	public double getDistance(){
		return 	Math.sqrt (3.0 / 2.0) * Math.sqrt (a * a + b * b);
	}
}
