package visrd;

import java.io.*;
import java.util.*;

public class Taxon implements Comparable{
	private String label;
	private char[] matrix; // Matrix to hold the character alignment
	private char[] originalMatrix; // Original genetic data
	private int charPointer;

	private static char matchChar=Character.MAX_VALUE;
	private static int dataType; // eg DNA/RNA
	
	public static final int STANDARD=0, DNA=1, RNA=2, PROTEIN=3,UNKNOWN=4;
	public static final String[] NAME={"standard","dna","rna","protein","unknown"};
	public static final String[] SYMBOLS={"01","atgc","augc","arndcqeghilkmfpstwyvz",""};
	
	private static boolean isDNAorRNA;
	private static Random rnd;
	
	public static final char[] MATRIX_COL={'g','c','a','t'};
	public static final char[] MATRIX_ROW={'b','d','h','k','m','n','r','s','v','w','x','y','-'};
	public static final int[][] RESOLUTION_MATRIX={{4,4,0,4},{4,0,4,4},{0,4,4,4},{6,0,0,6},{0,6,6,0},{3,3,3,3},{6,0,6,0},{6,6,0,0},{4,4,4,0},{0,0,6,6},{3,3,3,3},{0,6,0,6},{3,3,3,3}};
	
	public static final int OFFSET_BUG=0;
	
	public static void main(String[] args){
		isDNAorRNA=true;
		rnd = new Random(System.currentTimeMillis());
/*				
		for(int i=0;i<MATRIX_ROW.length;i++){
			System.out.print(i + ": ");
			System.out.print(MATRIX_ROW[i]);
			for(int j=0;j<RESOLUTION_MATRIX[i].length;j++){
				System.out.print(RESOLUTION_MATRIX[i][j]);
				System.out.print(',');
			}
			System.out.println();
			resolveCharacter(MATRIX_ROW[i]);
			
			System.out.println();
			System.out.println();
			System.out.println();
		}
*/		
		System.out.println(resolveCharacter('y'));
		
	}
	
	public Taxon(String label){
		this.label=label;
	}
	
	public void appendCharToMatrix(char c, Taxon templateTaxon){
		if(matchChar!=Character.MAX_VALUE&&matchChar==c){
			matrix[charPointer]=templateTaxon.getCharAt(charPointer);
			charPointer++;
		}
		else{
			matrix[charPointer++]=Character.toLowerCase(c);
		}
		
	}
	
	public void appendCharToMatrix(String s, Taxon templateTaxon){
		for(int i=0;i<s.length();i++){
			appendCharToMatrix(s.charAt(i), templateTaxon);
		}
	}
	
	public static void checkDataTypeSymbols(String symbols) throws Exception{
		if(!SYMBOLS[dataType].equalsIgnoreCase(symbols)){
			throw new Exception("WARNING: Data type symbols do not match '" + SYMBOLS[dataType] + "' expected, but " + symbols + " found");
		}
	}
	
	public int compareTo(Object rhs){
		Taxon otherTaxon = (Taxon)rhs;
		return label.compareTo(otherTaxon.getLabel());
	}
	
	public char getCharAt(int i){
		return matrix[i];
	}
	
	public String getLabel(){ return label; }
	public int getNchar(){ return matrix.length; }
	public char[] getMatrix(){ return matrix; }

	public static int getDataType(){ return dataType; }	
	public static String getDataTypeName(){ return NAME[dataType]; }
	public static String getDataTypeSymbols(){ return SYMBOLS[dataType]; }
	
	public static boolean inferIsDNAorRNA(String sequenceData){
		int NA_Count=0;

		for(int i=0;i<sequenceData.length();i++){
			if(sequenceData.charAt(i)=='a'||sequenceData.charAt(i)=='c'||sequenceData.charAt(i)=='g'||sequenceData.charAt(i)=='t'||sequenceData.charAt(i)=='u'){
				NA_Count++;
			}
		}
		
		double probability = (double)NA_Count/(double)sequenceData.length();
		System.out.println("probability:" + probability);
		isDNAorRNA=probability>0.75;

		if(isDNAorRNA){ dataType=DNA; }
		else{ dataType=PROTEIN; }
		
		return isDNAorRNA;
	}
	
	public static boolean isDNAorRNA(){ return isDNAorRNA; }
	
	public boolean isLabelled(String label){
		return this.label.equals(label);
	}
	
	public void initializeCharacterMatrix(int size){
		// The revert to old data structure which doesn't take account
		// of last char use size + 1 and charPointer=1.
		matrix = new char[size+OFFSET_BUG]; // should be 0
		charPointer=OFFSET_BUG;// should be 0
	}
	
	// Attempt to resolve any ambiguities
/*	public static char resolveCharacter(char c){
		if(isDNAorRND){
			if(c=='r'){
				if(rnd.nextInt(2)==0){ return 'a'; }
				else{ return 'g'; }
			}	
		}

		return c;
	}
*/
	// Dummy version which doesn't resolve at all...
//	public static char resolveCharacter(char c){ return c; }

	public static char resolveCharacter(char c){
		if(isDNAorRNA){
			if(c=='g'||c=='c'||c=='a'||c=='t'||c=='u'){ return c; }
			
		//	System.out.println("Resolve: " + c);
			// Find the appropriate row
			int row=0;
			while(row!=MATRIX_ROW.length&&MATRIX_ROW[row]!=c){
				row++;
			}
			
			if(row==MATRIX_ROW.length){
				// Cannot resolve
		//		System.err.println("WARNING: Cannot resolve '" + c + "'");
		  		//	return c;
				row--;
			}
			
	//		System.out.println("Row: " + row);
			
			// generate a number between 0 and 11
			int number = rnd.nextInt(12);
			
	//		System.out.println("Number: " + number);
			
			for(int col=0;col<4;col++){
				if(number<RESOLUTION_MATRIX[row][col]){
		//			System.out.println("Symbol: " + MATRIX_COL[col]);
					return MATRIX_COL[col];
				}
				else{
					number-=RESOLUTION_MATRIX[row][col];
				}
			}
		}
		else{
			return c;
		}

		return ' ';
	}
	
	public void setCharacterMatrix(String sequence){
		initializeCharacterMatrix(sequence.length());
		
		for(int i=0;i<sequence.length();i++){
			matrix[charPointer++]=Character.toLowerCase(sequence.charAt(i));
		}
	}

	public static void setDataType(String type) throws Exception{
		for(int i=0;i<NAME.length;i++){
			if(type.equalsIgnoreCase(NAME[i])){
				dataType=i;
				return;
			}
		}
		
		throw new Exception("WARNING: Data type not recognized '" + type + "'");
	}
	
	public static void setDataTypeFromSymbols(String symbols) throws Exception{
		for(int i=0;i<NAME.length;i++){
			if(symbolsMatchDataType(symbols,i)){
				dataType=i;
				return;
			}
		}
		
		throw new Exception("WARNING: Symbols not recognized '" + symbols + "'");
	}
	
	public static void setIsDNAorRNA(){
		isDNAorRNA = (dataType==DNA||dataType==RNA);
		rnd = new Random(System.currentTimeMillis());
	}
	
	public static void setMatchChar(char newMatchChar){
		matchChar=newMatchChar;
	}
	
	public void setMatrix(char[] matrix){ this.matrix=matrix; }

	public static boolean symbolsMatchDataType(String symbols){
		return symbolsMatchDataType(symbols, dataType);
	}
	
	public static boolean symbolsMatchDataType(String symbols, int dataType){
		// Note the symbols could be in any order
		symbols=symbols.toLowerCase();
		
		System.out.println("Symbols to analyse [" + symbols + "]");
		System.out.println("Symbols expected [" + SYMBOLS[dataType] + "]");
		
		if(symbols.length()==SYMBOLS[dataType].length()){
			boolean[] checkExists=new boolean[symbols.length()];
			
			for(int i=0;i<symbols.length();i++){
				// For each character in symbols
				boolean found=false;
				
				for(int j=0; j<symbols.length()&&found==false; j++){
					if(symbols.charAt(i)==SYMBOLS[dataType].charAt(j)){
						if(checkExists[j]==true){
							return false;
						}
						else{
							checkExists[j]=true;
							found=true;
						}
					}
				}
				
				if(found==false){ return false; }
			}
			
			return true;
		}
		
		return false;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer("Taxon '" + label + "' length '" + matrix.length + "':\n");
		
		for(int i=0;i<matrix.length;i++){
			sb.append(matrix[i]);
		}
		
		return sb.toString();
	}
	
	public void preserveMatrix(){ originalMatrix=matrix; }
	public void restoreMatrix(){ matrix=originalMatrix; }
}


// Could get any of this type of data
    /** The known Datatypes subclass
     */
/*
    public abstract interface DatatypeID {

        final String standard = "standard";
        final String standardSymbols = "01";
        final String dna = "dna";
        final String dnaSymbols = "atgc";
        final String rna = "rna";
        final String rnaSymbols = "augc";
        final String protein = "protein";
        final String proteinSymbols = "arndcqeghilkmfpstwyvz";
        final String unknown = "unknown";
        final String unknownSymbols = "";
    }
*/