package visrd;

/**

   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

	Class with static functions for generating a starting set of quartets

*/

public class StatisticalGeometryCalculator extends TrajectoryCalculator {
	public StatisticalGeometryCalculator (Taxon[] taxon){
		super(taxon);
	}
	
	/* Heart of the algorithm */
	public Triplet processWindow(int s, char[] rowX, char[] rowY, char[] rowU, char[] rowV, Quartet q){
		// For each window, there is a pattern count
		
		int[] patternCount = new int[15];
		
		for (int wS = s - windowSize / 2; wS < s + windowSize / 2; wS++) {

			if ((! useMask) || (! mask[wS])) { //If position is not masked...
				// then, check whether the things equal or not...
				
				char x = Taxon.resolveCharacter(rowX[wS]);
				char y = Taxon.resolveCharacter(rowY[wS]);
				char u = Taxon.resolveCharacter(rowU[wS]);
				char v = Taxon.resolveCharacter(rowV[wS]);

/*				Kristoper's old code...
				if (x == y && x == u && x == v) {
					patternCount[0]++;
				}
				else if (y == u && y == v && y != x) {
					patternCount[1]++;
				}
				else if (y == u && y == v && y != x) {
					patternCount[1]++;
				}
				else if (x == u && x == v && y != x) {
					patternCount[2]++;
				}
				else if (x == y && x == v && x != u) {
					patternCount[3]++;
				}
				else if (x == y && x == u && x != v) {
					patternCount[4]++;
				}
				else*/
		/*	Start useful bit	
				 if (x == y && u == v && x != u) {
					patternCount[5]++;
				}
				else if (x == u && y == v && x != y) {
					patternCount[6]++;
				}
				else if (x == v && y == u && x != y) {
					patternCount[7]++;
				}
				else if (x == y && u != v && x != u && x != v) {
					patternCount[8]++;
				}
				else if (x == u && x != y && x != v && y != v) {
					patternCount[9]++;
				}
				else if (x == v && x != y && x != u && y != u) {
					patternCount[10]++;
				}
				else if (y == u && y != x && y != v && x != v) {
					patternCount[11]++;
				}
				else if (y == v && y != x && y != u && x != u) {
					patternCount[12]++;
				}
				else if (u == v && x != u && y != u && x != y) {
					patternCount[13]++;
				}
		End useful bit	*/	

/*				else if (x != y && x != u && x != v &&
					 y != u && y != v && u != v) {
					patternCount[14]++;
				}		
*/
				// Start the new logic
				if(x==y){
					if(x != u){
						if (u == v) {
							patternCount[5]++;
						}
						else if(x != v) {
							patternCount[8]++;
						}
					}
				}
				else{
					if(x==u){
						if (y == v) {
							patternCount[6]++;
						}
						else if (x != v) {
							patternCount[9]++;
						}
					}
					else if(y != u){
						if (x == v) {
							patternCount[10]++;
						}
						else if (y == v){
							patternCount[12]++;
						}
						else if (u == v) {
							patternCount[13]++;
						}
					}
					else{
						if (x == v){
							patternCount[7]++;
						}
						else if (y != v) {
							patternCount[11]++;
						}
					}
				}
			}
		
		}

		/**
			Now we have the counts, create the weights
		*/
	
		double s1 = (double)patternCount[5] +
	 		   0.5 * (double)(patternCount[8] + patternCount[13]);
	
		double s2 = (double)patternCount[6] +
			    0.5 * (double)(patternCount[9] + patternCount[12]);
	
		double s3 = (double)patternCount[7] +
			    0.5 * (double)(patternCount[10] + patternCount[11]);
					
		return generateTriplet(s,s1,s2,s3);
	}
}
