package visrd;

import java.util.ArrayList;

public class ShannonScore {
	private final int[] scores;
	private final int[] uniqueItems;
	private final int size;
	
	public ShannonScore(int[] input){
		this.scores = input;
		this.size = input.length;

//		make a list of sites that occur		
		ArrayList uniqueItemsList = new ArrayList();
		for(int val = 0; val <scores.length;val++){
			Object obj = (Object)(new Integer(scores[val]));
			if(!uniqueItemsList.contains(obj)){
				uniqueItemsList.add(new Integer(scores[val]));
			}
		}
		uniqueItems = new int[uniqueItemsList.size()];
		for(int i=0; i<uniqueItems.length; i++){
			uniqueItems[i] = ((Integer)uniqueItemsList.get(i)).intValue();
		}
		
	}
	
	public double getEntropy(){
		double entropy = 0.0;

//		iterate through each site that occurs @ get frequency
		for(int occurring = 0; occurring < uniqueItems.length; occurring ++){
//-			System.out.println(occurring);
			int count = 0;
			for(int obs = 0; obs < scores.length; obs ++){
				if(scores[obs] == uniqueItems[occurring]){
					count ++;
				}
			}
			double likelihood = ((double)count)/((double)size);
			double eventEntropy = -(likelihood * (Math.log(likelihood) / Math.log(uniqueItems.length)));
			if (!new Double(eventEntropy).isNaN()) {
				entropy += eventEntropy;
			}					
		}
		return entropy;
	}

	/**
	 * @return the scores
	 */
//	public int[] getScores() {
//		return scores;
//	}

	/**
	 * @return the size
	 */
//	public int getSize() {
//		return size;
//	}

	/**
	 * @return the uniqueItems
	 */
//	public int[] getUniqueItems() {
//		return uniqueItems;
//	}
}
