package visrd;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class ScanWindow extends JFrame implements ActionListener, ChangeListener{
	private static JComboBox methodChoice, shuffleChoice;
	private static JCheckBox useRandomQuartets, outputMeanDistance, outputMeanIndex, outputAllSubsets, outputToFile;
	private static JSpinner randomQuartetSpinner, transitionSpinner;
	private static SpinnerNumberModel randomQuartetModel, transitionModel;
	
	private static JTextField startSet, endSet, nDataset;

	private static JButton startScan;
	private static JProgressBar progressBar;
	
	private static long startTime;	
	private static String status;
	
	private static int numberOfQuartets, methodType, maxQuartets;
	private static JLabel timerLbl, nDatasetsLbl, outputToFileLbl;
	
	private static java.io.File passBackFile;
	private static JPanel mainPane, nullDistribution, optsPane, outputOptsPane;
	
	public static ScanWindow thisWindow;
	
	private static int oldPercentage=-1, startSetCLI=-1, endSetCLI=-1;
	
//	private static Object[] methodOptions; //= {"Statistical Geometry","Extended SG (Hamming)","BLOSUM62 (protein)","Jukes Cantor (DNA/RNA)","Kimura (DNA/RNA)","F84 (DNA/RNA)","Tamura-Nei (DNA/RNA)","HIV Between 10% (protein)","HIV Between 38% (protein)","HIV Within 5% (protein)","PIV log odds (protein)"};
	private static final Object[] proteinMethodOptions = {"Statistical Geometry","Extended SG (Hamming)","BLOSUM62","Blosum Corrected","HIV Between 10%","HIV Between 38%","HIV Within 5%","PIV log odds","HIV Between 10% Corrected","HIV Between 38% Corrected","HIV Within 5% Corrected","PIV log odds Corrected"};
	private static final Object[] nucleotideMethodOptions = {"Statistical Geometry","Extended SG (Hamming)","Jukes Cantor","Kimura","F84","Tamura-Nei"};
		
	public ScanWindow(Taxon[] taxon, java.io.File passBackFile){
		super("Quartet Generation");
		
		thisWindow=this; // We only want one window!!
		this.passBackFile=passBackFile;
		maxQuartets = taxon.length * (taxon.length - 1) * (taxon.length - 2) * (taxon.length - 3) / 24;

		mainPane = new JPanel(new GridBagLayout());

		buildGUI();
		getContentPane().add(mainPane);
				
		pack();
		show();
	}
	
	private void buildGUI(){
		// Generate the GUI
		mainPane.removeAll();
		
		if(nullDistribution==null){
			nullDistribution = new JPanel(new GridBagLayout());
			nullDistribution.setBorder(BorderFactory.createTitledBorder("Shuffle sequences for use as a null distribution"));
			
			// Start generationParameters
			GridBagConstraints c = new GridBagConstraints();
	        c.fill = GridBagConstraints.BOTH;
	        c.weightx = 0.0;
			c.gridwidth=1;
			c.gridx = 0;
			c.gridy = 0;
			
			Object[] shuffleOptions = {"None","Random Shuffling","Shannon Shuffling"};
			shuffleChoice = new JComboBox (shuffleOptions);
			shuffleChoice.addActionListener(this);
			c.gridx = 0;
			nullDistribution.add(new JLabel("Method choice"),c);
			c.gridx = 1;
			nullDistribution.add(shuffleChoice,c);
			
			c.gridy = 1;
			c.gridx = 0;
			nDatasetsLbl = new JLabel("Number of datasets");
			nullDistribution.add(nDatasetsLbl,c);
			nDataset = new JTextField("1");
			c.gridx = 1;
			nullDistribution.add(nDataset,c);
			nDatasetsLbl.setVisible(false);
			nDataset.setVisible(false);

			c.gridy = 2;
			c.gridx = 0;
			outputToFileLbl = new JLabel("Output to file");
			nullDistribution.add(outputToFileLbl,c);
			outputToFile = new JCheckBox();
			outputToFile.addActionListener(this);
			c.gridx = 1;
			outputToFileLbl.setVisible(false);
			outputToFile.setVisible(false);

			nullDistribution.add(outputToFile,c);
		}
		
		if(optsPane==null){
			optsPane = new JPanel(new GridBagLayout());
			optsPane.setBorder(BorderFactory.createTitledBorder("Scan options"));
			
			// Start generationParameters
			GridBagConstraints c = new GridBagConstraints();
	        c.fill = GridBagConstraints.BOTH;
	        c.weightx = 0.0;
			c.gridwidth=2;
			c.gridx = 0;
			c.gridy = 0;
			
			Object[] methodOptions = proteinMethodOptions;
			if(Taxon.isDNAorRNA()){ methodOptions = nucleotideMethodOptions; }
			
			methodChoice = new JComboBox (methodOptions);
			methodChoice.addActionListener(this);
			optsPane.add(new JLabel("Weighting method"),c);
			c.gridx = 2;
			optsPane.add(methodChoice,c);
/*	
			Object[] varianceOptions = {"Euclidean trajectory sorting","Angular path trajectory sorting","Angular trajectory sorting"};
			varianceChoice = new JComboBox (varianceOptions);
			c.gridwidth=2;
			c.gridy = 1;
			c.gridx = 0;
			optsPane.add(new JLabel("Sorting metric"),c);
			c.gridx = 2;
			optsPane.add(varianceChoice,c);
*/	
			useRandomQuartets = new JCheckBox("Pick taxa at random");
			useRandomQuartets.addChangeListener(this);
			c.gridwidth=2;
			c.gridy = 2;
			c.gridx = 0;
			optsPane.add(useRandomQuartets,c);
	
			c.gridwidth=1;
			c.gridx = 2;
			optsPane.add(new JLabel("Number to generate"),c);
			randomQuartetModel = new SpinnerNumberModel (maxQuartets, 1, maxQuartets, 25);
			randomQuartetSpinner = new JSpinner (randomQuartetModel);
			randomQuartetSpinner.setEnabled(false);
			c.gridx = 3;
			optsPane.add(randomQuartetSpinner,c);
	
	
			// Kimura model options: transition and transversion rates
/*			c.gridx = 0;
			c.gridy = 3;
			c.gridwidth=3;
			optsPane.add(new JLabel("Transition/Transversion Ratio: "),c);
			transitionModel = new SpinnerNumberModel (4.8, 0.0, 99.8, 0.2);
			
			c.gridx = 3;
			transitionSpinner = new JSpinner (transitionModel);
			transitionSpinner.setEnabled(false);
			optsPane.add(transitionSpinner,c);
			// End Kimura
*/		}
		
		GridBagConstraints cbg = new GridBagConstraints();
        cbg.fill = GridBagConstraints.BOTH;
        cbg.weightx = 0.0;
		cbg.gridwidth=1;
		cbg.gridx = 0;
		cbg.gridy = 0;
		mainPane.add(nullDistribution, cbg);
		cbg.gridy = 1;
		if(!outputToFile.isSelected()||shuffleChoice.getSelectedIndex()==0){ mainPane.add(optsPane, cbg); }
		
		// Add output options
		if(outputOptsPane==null){
			outputOptsPane = new JPanel(new GridLayout(1,4));
			outputOptsPane.setBorder(BorderFactory.createTitledBorder("Datasets to scan"));
/*			
			GridBagConstraints oopc = new GridBagConstraints();
     		oopc.fill = GridBagConstraints.BOTH;
	       	oopc.weightx = 0.0;
			oopc.gridwidth=1;
*/			
			// Scan start
//			oopc.gridx = 0;
//			oopc.gridy = 0;
			outputOptsPane.add(new JLabel("Start set"));
//			oopc.gridx = 1;
			startSet = new JTextField();
			outputOptsPane.add(startSet);
			
			// Scan end
//			oopc.gridx = 0;
//			oopc.gridy = 1;
			outputOptsPane.add(new JLabel("End set"));
//			oopc.gridx = 1;
			endSet = new JTextField();
			outputOptsPane.add(endSet);
/*
			outputMeanDistance = new JCheckBox("Mean distance");
			oopc.gridx = 0;
			oopc.gridy = 2;
			outputMeanDistance.setSelected(true);
			outputOptsPane.add(outputMeanDistance, oopc);
			
			outputMeanIndex = new JCheckBox("Mean index");
			oopc.gridx = 1;
			outputOptsPane.add(outputMeanIndex, oopc);		
	
			outputAllSubsets = new JCheckBox("All subsets with one missing taxa");
			oopc.gridwidth=2;
			oopc.gridx = 0;
			oopc.gridy = 3;
			outputAllSubsets.setSelected(true);
			outputOptsPane.add(outputAllSubsets, oopc);
*/
			cbg.gridy = 2;			
			mainPane.add(outputOptsPane, cbg);
			
			startScan = new JButton("Start");
			timerLbl = new JLabel("Press 'Start' to begin");
		}
		
		outputOptsPane.setVisible(passBackFile!=null);
		nullDistribution.setVisible(passBackFile==null);
		if(passBackFile!=null){ shuffleChoice.setSelectedIndex(0); }
		

		startScan.addActionListener(this);
		cbg.gridy = 3;
		mainPane.add(startScan, cbg);

		progressBar = new JProgressBar(0,100);
		progressBar.setStringPainted(true); 
		cbg.gridy = 4;
		mainPane.add(progressBar, cbg);


		cbg.gridy = 5;
		mainPane.add(timerLbl, cbg);

		pack();
		show();
	}
	

	public void actionPerformed(ActionEvent e){
		if(e.getSource()==startScan){
			if(passBackFile==null){
				startScan.setEnabled(false);
				progressBar.setMaximum(((Integer) randomQuartetModel.getValue ()).intValue ());
				
//				KimuraDistanceFunction.setParameters(((Double) transitionModel.getValue ()).doubleValue ());
				scan();	
			}
			else{
				NexusIO.loadData(passBackFile);
			}
		}
		else if(e.getSource()==outputToFile||e.getSource()==shuffleChoice){
			boolean enabled = shuffleChoice.getSelectedIndex()!=0;
		//	optsPane.setVisible(shuffleChoice.getSelectedIndex()==0||!outputToFile.isSelected());
			
			outputToFileLbl.setVisible(enabled);
			outputToFile.setVisible(enabled);
			nDatasetsLbl.setVisible(enabled);
			nDataset.setVisible(enabled);
			pack(); show();
		}
/*		else{
			transitionSpinner.setEnabled(methodChoice.getSelectedIndex()==5);
		}
*/	}
	
	public void stateChanged(ChangeEvent e){
		randomQuartetSpinner.setEnabled(useRandomQuartets.isSelected());
	}

	public static int getMethodType(){
		if(methodChoice==null){ return methodType; }
		else{ return methodChoice.getSelectedIndex(); }
	}
	
	public static void setDatasets(int start, int end){
		startSet.setText(Integer.toString(start));
		endSet.setText(Integer.toString(end));
	}

	public static void setMethodType(int type){
//		System.out.println("Setting weighting method to:" + methodOptions[type]);
		methodType=type;
	}
	
	public int getNdatasets(){ return Integer.parseInt(nDataset.getText()); }
	
	public void scan(){
		harvest(); // Process settings
		if(shuffleChoice.getSelectedIndex()==0){
			nDataset.setText("1");
		}
		
		VisRD.setDatasetCounter(1);
		VisRD.scan(shuffleChoice.getSelectedIndex(),outputToFile.isSelected(),getNdatasets());
	}
	
	public void updateStatus(int datasetCounter, int nDatasets){
		timerLbl.setText("Processing dataset " + datasetCounter + " of " + (nDatasets) + ". " + numberOfQuartets + " Quartets generated");
	}
		
	public void setProgressBarMax(int max){
		progressBar.setMaximum(max);
	}
	
	public static boolean containsMoreDataSets(){
		return VisRD.getDatasetCounter()<=Integer.parseInt(nDataset.getText());
	}

	public static void setNumberOfQuartets(int newNumberOfQuartets){
		numberOfQuartets=newNumberOfQuartets;
		if(passBackFile==null){
			int nDatasets = Integer.parseInt(nDataset.getText());
			timerLbl.setText("Processing dataset " + (VisRD.getDatasetCounter()-1) + " of " + nDatasets + ". " + numberOfQuartets + " Quartets generated");
		}
	}
	
	public static void setStatus(String str){
		status = str;
		progressBar.setString(str);
		startTime = System.currentTimeMillis();
	}
	
	public static void updateProgress(int value){
		if(VisRD.getShowGUI()){
			progressBar.setValue(value);
			
			int max = progressBar.getMaximum();
			int percentage = (int)Math.ceil(100.0 * (double)value/(double)max);
			progressBar.setString(status + ": " + percentage + "%");
			
	/*		int timeElapsed = (int)(System.currentTimeMillis() - startTime)/1000;
			int timeLeft = timeElapsed/percentage * (100-percentage);
			
			int seconds = timeLeft%60;
			int minutes = timeLeft/60;
			
			if(passBackFile==null){ timerLbl.setText(numberOfQuartets + " Quartets generated. " + minutes + " minutes " + seconds + " seconds remaining"); }
	*/		
			progressBar.repaint();
		}
		else{
			int max = progressBar.getMaximum();
			int percentage = (int)Math.ceil(100.0 * (double)value/(double)max);
			if(percentage!=oldPercentage){ System.out.println(percentage + "% complete"); }
		}
	}
	
	public static void updateSetNumber(int setNumber){
		if(VisRD.getShowGUI()){ timerLbl.setText("Scanning replicate set number " + setNumber + "..."); }
		else{ System.out.println("Scanning replicate set number " + setNumber + "..."); }
	}
	
	public static void updateProgressMax(int max){
		progressBar.setMaximum(max);
	}
	
	public static void init(Taxon[] taxon){
		int maxQuartets = (taxon.length) *
							(taxon.length - 1) *
							(taxon.length - 2) *
							(taxon.length - 3) / 24;
		randomQuartetModel = new SpinnerNumberModel (maxQuartets, 1, maxQuartets, 1);		
	}
	
	public static void update(Taxon[] taxon){	
		int maxQuartets = (taxon.length) *
							(taxon.length - 1) *
							(taxon.length - 2) *
							(taxon.length - 3) / 24;
							
		randomQuartetModel.setMaximum (new Integer (maxQuartets));
		randomQuartetModel.setValue ((Object) new Integer (maxQuartets));
	}
	
	
	public static void harvest(){
		VisRD.setVarianceType(0); // Don't offer different variance options now

		VisRD.setDesiredQuartets (((Integer) randomQuartetModel.getValue ()).intValue ());

		if (useRandomQuartets.isSelected ()) {
			if (VisRD.getDisplayQuartets () > VisRD.getDesiredQuartets ()) {
				VisRD.setDisplayQuartets(VisRD.getDesiredQuartets ());
			} 
		}
	
		VisRD.setUseRandomQuartets (useRandomQuartets.isSelected ());
	}
	
	public static void setStartDatasetCLI(int startSet){ startSetCLI=startSet; }
	public static void setEndDatasetCLI(int endSet){ endSetCLI=endSet; }

	public static int getStartSet(){
		if(startSet==null||startSet.getText().length()==0){ return startSetCLI; }
		return Integer.parseInt(startSet.getText());
	}
	
	public static int getEndSet(){
		if(endSet==null||endSet.getText().length()==0){ return endSetCLI; }
		return Integer.parseInt(endSet.getText());
	}
	
	public void show(java.io.File passBackFile){ // Reset everything rather than call constructor
		super.show();
		this.passBackFile=passBackFile;
		outputOptsPane.setVisible(passBackFile!=null);
		nullDistribution.setVisible(passBackFile==null);
		
		Object[] methodOptions = proteinMethodOptions;
		if(Taxon.isDNAorRNA()){ methodOptions = nucleotideMethodOptions; }
		methodChoice.setModel(new DefaultComboBoxModel(methodOptions));
		
		startScan.setEnabled(true);
		progressBar.setValue(0);
		progressBar.setString("0%");
		timerLbl.setText("Click 'Start' to begin");
		
		pack();
	}
}
