package visrd;

import java.util.*;

public class QuartetSet{
	private Quartet[] quartets;

	
	public QuartetSet (Quartet[] newQuartets){
		quartets = newQuartets;
	}

	public int size (){ return quartets.length; }

	public Quartet getQuartet (int n){ return quartets[n]; }

	public Triplet[] getTrajectory(int n){ return quartets[n].getTrajectoryList(); }

	public int getMaxPosition(int n){ return quartets[n].getMaxPosition(); }
	
	public void multiplySupportByAlpha(){
		double alpha = TrajectoryCalculator.getMinimumAlpha();
		
		for(int i=0;i<quartets.length;i++){
			Triplet[] triplet = quartets[i].getTrajectoryList();
			for(int j=0;j<triplet.length;j++){
				triplet[j].updateCoordinates(alpha);
			}
		}
	}
/*	
	public void revertToOriginalSupport(){
		for(int i=0;i<quartets.length;i++){
			Triplet[] triplet = quartets[i].getTrajectoryList();
			for(int j=0;j<triplet.length;j++){
				triplet[j].revertToOriginalSupport();
			}
		}
	}
*/	
/*
	// Setting the variances, Euclidean style
	public void calculateVariances(VisRDGUI GUI, int distanceMetric){
		for (int n = 0; n < quartets.length; n++) {
			quartets[n].calculateVariance();
		}
	}
*/
	public void sort (){
		java.util.Arrays.sort(quartets);
	}

	public Rank[] frequencies(int taxaSize, boolean useMeanIndex){
		return frequencies(taxaSize, useMeanIndex, new int[0]);
	}

	public Rank[] frequencies(int taxaSize, boolean useMeanIndex, int[] indicesOfTaxaToExclude){
		/**

			Go through all quartets. Check all taxa, see if they are known. If not, put on
			known list. If they are, add index and increment count.

		*/
		
		int[] taxaCount = new int[taxaSize];
		double[] taxaSum = new double[taxaSize];
		Hashtable<Integer, Integer>[] taxaWindowDistribution = new Hashtable[taxaSize];
		
		for(int i=0;i<taxaSize;i++){
			taxaWindowDistribution[i] = new Hashtable<Integer, Integer>();
		}

		try{
			Taxon[] taxa = VisRD.getAllTaxon();
			java.io.PrintWriter pw=null;
			
			if(VisRD.getOutputQuartets()){
				System.out.println("Output quartet data");
				pw = new java.io.PrintWriter(new java.io.BufferedWriter(new java.io.FileWriter("quartets.csv")));
				pw.println("Quartet,Max distance position,Corrosponding window,Variance,Taxon 1,Taxon 2,Taxon 3,Taxon 4");
			}
	
			for (int n = quartets.length-1; n >=0; n--) { // Start with quartet which moves the most
				Quartet q = quartets[n];
	
				// If Quartet does not contain a specific taxa 
				boolean containsTaxa=false;
				for (int i=0;i<indicesOfTaxaToExclude.length&&!containsTaxa;i++){
					if(q.contains(indicesOfTaxaToExclude[i])){
						containsTaxa=true;
					}
				}
				
				if(!containsTaxa){
					int windowPosition = q.getMaxPosition();
					
					int[] index = {q.getX(),q.getY(),q.getU(),q.getV()};
					
					for(int i=0;i<index.length;i++){
						taxaCount[index[i]]++;
						
						if(useMeanIndex){ taxaSum[index[i]]+=n; }
						else{ taxaSum[index[i]]+=q.getVariance(); }
						
						Integer freq = taxaWindowDistribution[index[i]].get(windowPosition);
						if(freq==null){ freq = new Integer(1); }
						else{ freq = new Integer(freq.intValue()+1); }
						taxaWindowDistribution[index[i]].put(new Integer(windowPosition), freq);
					}
					
					String windowPositionStr = "" + (windowPosition*VisRD.getStepSize()) + "-" + (windowPosition*VisRD.getStepSize()+VisRD.getWindowSize());
					if(VisRD.getOutputQuartets()){ pw.println((quartets.length-n) + "," + windowPosition +  "," + windowPositionStr + "," + q.getVariance() + "," + taxa[index[0]].getLabel() + "," + taxa[index[1]].getLabel() + "," + taxa[index[2]].getLabel() + "," + taxa[index[3]].getLabel()); }
				}
			}

			if(VisRD.getOutputQuartets()){
				pw.flush();
				pw.close();
			}
		}
		catch(java.io.FileNotFoundException e){
			VisRDGUI.displayError("File not found, is it open in another editor?");
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
		// Then, generate proper frequencies... stored as VPoints
		Rank[] f = null;
		Taxon[] taxa = VisRD.getAllTaxon();
	
		if(VisRD.getClusterQuartets()){
			Object[] groupNames = VisRD.getGroupNames();
			int[][] taxaGroup = VisRD.getTaxaMatrix();
			f = new Rank[taxaGroup.length-1];
		/*	
			for(int i=0;i<taxaGroup.length;i++){
				for(int j=0;j<taxaGroup[i].length;j++){
					System.out.println(taxaGroup[i][j]);
				}
			}
		*/	
			for(int group=1;group<taxaGroup.length;group++){
				double groupSum=0.0;
				int groupCount=0;
				int groupMaxPosition=0;
				Hashtable<Integer, Integer> groupWindowDistribution = new Hashtable<Integer, Integer>();
				
				for(int i=0;i<taxaGroup[group].length;i++){
					int taxaIndex = taxaGroup[group][i];
					groupSum+=taxaSum[taxaIndex];
					groupCount+=taxaCount[taxaIndex];
					
					// Combine hashtables...
					Enumeration e = taxaWindowDistribution[taxaIndex].keys();
					while(e.hasMoreElements()){
						Integer key = (Integer)e.nextElement();
						
						Integer freq = taxaWindowDistribution[taxaIndex].get(key);
						Integer groupFreq = groupWindowDistribution.get(key);
						
						if(groupFreq==null){ groupWindowDistribution.put(key,freq); }
						else{ groupWindowDistribution.put(key, new Integer(freq.intValue() + groupFreq.intValue()));}
					}
				}
				
				int groupMaxWindow = (int)Math.round((double)groupMaxPosition/(double)groupCount);
			
				f[group-1] = new Rank ((String)groupNames[group-1], groupSum/groupCount,groupCount,groupWindowDistribution);
			}
		}
		else{
			f = new Rank[taxaSize];
			
			for (int n = 0; n < taxaSize; n++) {
				f[n] = new Rank(taxa[n].getLabel(), taxaSum[n]/(double)taxaCount[n],taxaCount[n],taxaWindowDistribution[n]);
			}	
		}

		/** Then, we want the list sorted... */
		java.util.Arrays.sort(f);
		return f;
	}
}