package visrd;

import javax.swing.*;
import java.awt.*;
import java.io.File;

/*

    Created using IntelliJ IDEA.
    User: forslund
    Date: Dec 10, 2003
    Time: 1:34:56 AM
 
*/

public class QuartetMapPanel extends VisRDPanel{
	private JButton stopButton, startButton, saveAllFrames;

	private int noQuartets;
	private int currentFrame, firstFrame, lastFrame;
	private boolean move;
	
	public static final boolean REVIEW_QUARTET=false;
	
	public QuartetMapPanel(QuartetSet newData){
		super(newData, 700, 550);

		setPreferredSize (new Dimension (700, 550));
		
		System.out.println("ALPHA:" + TrajectoryCalculator.getMinimumAlpha());
	}

	public void reset (int newNoQuartets, int newFirstWindow, int newLastWindow){
		noQuartets = newNoQuartets;

		if(noQuartets > data.size ()){ noQuartets = data.size (); }

		Triplet[] t = data.getTrajectory (0);

		for(int n=0;n<t.length;n++){
			Triplet p = t[n];
			
			if (p.getC () > newFirstWindow) {
				firstFrame = n;
				break;
			}
		}

		for (int n = t.length - 1; n > 0; n--) {
			Triplet p = t[n];

			if (p.getC () < newLastWindow) {
				lastFrame = n;
				break;
			}
		}

		currentFrame = firstFrame;
		move = true;
	}

	public void goTo (int n){
		Triplet[] t = data.getTrajectory (0);

		int previous = 0;

		for (int q = 0; q < t.length; q++) {
			Triplet p = t[q];

			if ((int) p.getC () == n) {
				currentFrame = q;
				break;
			}

			else if (n > previous && n < (int) p.getC ()) {
				currentFrame = q;
				break;
			}

			previous = (int) p.getC ();
		}

		move = false;
		repaint ();
	}
	
	public void doActionPerformed(Object source){
		if(source==startButton){
			move = true;
			repaint ();
		}
		else if(source==stopButton){
			move = false;
		}
		else if(source==saveAllFrames){
			move = false;
			String filename = VisRD.getCurrentFilename();
			
			currentFrame=0;
			while(currentFrame<=lastFrame){
				save(filename + "-window" + currentFrame + ".eps");
				currentFrame++;
			}
		}
	}
	
	public JButton getSaveAllFrames(){
		saveAllFrames = new JButton("Save all windows to EPS");
		saveAllFrames.addActionListener (this);
		return saveAllFrames;
	}
	
	public JButton getStartButton(){
		startButton = new JButton ("Start animation");
		startButton.addActionListener (this);
		return startButton;
	}
	
	public JButton getStopButton(){
		stopButton = new JButton ("Stop animation");
		stopButton.addActionListener (this);
		return stopButton;
	}

    protected void paintComponent (Graphics g){ draw ((Graphics2D)g); }
    
    public void redraw(){ repaint(); }

	public void draw (Graphics2D g){
		long time = System.currentTimeMillis ();

		g.setColor (Color.WHITE);
		g.fillRect (0, 0, 700, 550);
/*
		if(REVIEW_QUARTET){
			move=false;
			Taxon[] taxon = VisRD.getAllTaxon();
			
			int quartetNumber=0;
			double maxVariance=Double.NEGATIVE_INFINITY;
			
			for(int i=0;i<data.size();i++){
				Quartet q = data.getQuartet(i);
				
				if((taxon[q.getX()].getLabel().charAt(0)=='A'||taxon[q.getX()].getLabel().charAt(0)=='C'||taxon[q.getX()].getLabel().charAt(0)=='0'||taxon[q.getX()].getLabel().charAt(0)=='B')&&
				(taxon[q.getY()].getLabel().charAt(0)=='A'||taxon[q.getY()].getLabel().charAt(0)=='C'||taxon[q.getY()].getLabel().charAt(0)=='0'||taxon[q.getY()].getLabel().charAt(0)=='B')&&
				(taxon[q.getU()].getLabel().charAt(0)=='A'||taxon[q.getU()].getLabel().charAt(0)=='C'||taxon[q.getU()].getLabel().charAt(0)=='0'||taxon[q.getU()].getLabel().charAt(0)=='B')&&
				(taxon[q.getV()].getLabel().charAt(0)=='A'||taxon[q.getV()].getLabel().charAt(0)=='C'||taxon[q.getV()].getLabel().charAt(0)=='0'||taxon[q.getV()].getLabel().charAt(0)=='B')){


//				if((taxon[q.getX()].getLabel().equals("BMBC925s87")||taxon[q.getX()].getLabel().equals("DELIs83")||taxon[q.getX()].getLabel().equals("F1BR020s93")||taxon[q.getX()].getLabel().equals("CIN999s93"))&&
//				(taxon[q.getY()].getLabel().equals("BMBC925s87")||taxon[q.getY()].getLabel().equals("DELIs83")||taxon[q.getY()].getLabel().equals("F1BR020s93")||taxon[q.getY()].getLabel().equals("CIN999s93"))&&
//				(taxon[q.getU()].getLabel().equals("BMBC925s87")||taxon[q.getU()].getLabel().equals("DELIs83")||taxon[q.getU()].getLabel().equals("F1BR020s93")||taxon[q.getU()].getLabel().equals("CIN999s93"))&&
//				(taxon[q.getV()].getLabel().equals("BMBC925s87")||taxon[q.getV()].getLabel().equals("DELIs83")||taxon[q.getV()].getLabel().equals("F1BR020s93")||taxon[q.getV()].getLabel().equals("CIN999s93"))){
					if(q.getVariance()>maxVariance){ 
						maxVariance = q.getVariance();
						quartetNumber=i;
					}
					
					System.out.println(taxon[q.getX()].getLabel() + "," + taxon[q.getY()].getLabel() + "," + taxon[q.getU()].getLabel() + "," + taxon[q.getV()].getLabel());
				}
				

			}
			
			Quartet q = data.getQuartet(quartetNumber);

			Triplet[] t = data.getTrajectory(quartetNumber);
			for(int i=0;i<t.length;i++){
				paintTriplet(g, t[i], (i==q.getMaxPosition()));
			}
			
			// Paint max again to ensure we can see it!
			paintTriplet(g, t[q.getMaxPosition()], true);
			
			Triplet m = new Triplet(q.getMeanX(), q.getMeanY(), 0.0);
			paintTriplet(g, m, true);
		}
		else{
*/			for (int i = data.size () - 1; i > data.size () - 1 - noQuartets; i--) {
				Triplet[] t = data.getTrajectory(i);
	
				paintTriplet(g, t[currentFrame], quartetFlags[i]);
//			}
		}


		//	Triangle
		g.setColor (Color.BLACK);

		int sX = (int) (Math.sqrt (3.0) * 105.0);

		g.drawLine (350, 95, 350 - sX, 405);
		g.drawLine (350 - sX, 405, 350 + sX, 405);
		g.drawLine (350, 95, 350 + sX, 405);

		// Get the current sequence position and window size for measurement stuff
		int windowSize = VisRD.getWindowSize ();
		int startPos = VisRD.getFirstWindow () - windowSize / 2;
		int endPos = VisRD.getLastWindow () + windowSize / 2;
		
		Triplet[] aT = data.getTrajectory (0);
		Triplet p = aT[currentFrame];
		int thisPos = (int) p.getC ();

		g.setColor (Color.BLUE);
		g.drawLine (150, 450, 550, 450);

		int gStart = 150 + (thisPos - startPos - windowSize / 2) * 400 / (endPos - startPos);
		int gEnd = 150 + (thisPos - startPos + windowSize / 2) * 400 / (endPos - startPos);

		g.setColor (Color.RED);
		g.drawLine (gStart, 453, gEnd, 453);

		// Timing
		if (move) { // Wait and repaint
			long timeTaken = System.currentTimeMillis () - time;
			if (timeTaken < 100) { // Timing here...
			    try {
					Thread.sleep (100 - timeTaken);
			    }
			    catch (InterruptedException e) { }
			}

			currentFrame++;

			if (currentFrame > lastFrame) {
				currentFrame = firstFrame;
			}
			
			repaint ();
		}
	}

	private void paintTriplet(Graphics2D g, Triplet p, boolean flag){
			Triplet pP = p.toPolar ();
	
			float noColor = (float) (1 - pP.getB ());
			float red=noColor, green=noColor,blue=noColor;
	
			double aThird=1.0/3.0;
	
			if (pP.getA () <= aThird&&pP.getA()>=-aThird) { red=1.0f; }
			else if (pP.getA ()> aThird) { green=1.0f; }
			else if (pP.getA ()<-aThird) { blue=1.0f; }
			
			if(flag){ // We want to follow this trajectory
				g.setColor (Color.BLACK);
			}
			else{ g.setColor (new Color (red, green, blue)); }
	
			double yFactor = Math.sqrt (3.0 / 2.0);
			double xFactor = Math.sqrt (6.0);
	
			int x = 350 - (int) (p.getA () * 100.0 * xFactor);
			int y = 300 - (int) (p.getB () * 200.0 * yFactor);
	
			g.fillOval (x, y, 5, 5);
	}
}
