package visrd;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
/**

   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

	Quartet Map graph

*/

public class QuartetMap extends JPanel implements ActionListener, ChangeListener{
	private QuartetMapPanel aQMP;
	private QuartetSet data;

	private JButton goToButton;
	private JTextField saveField, goToField;
	private JSpinner beginSpinner, endSpinner, quartetSpinner;
	
    public QuartetMap (QuartetSet newData, JTabbedPane home)
    {
		data = newData;
		data.multiplySupportByAlpha();

        JPanel c = new JPanel ();
        JPanel d = new JPanel ();

		aQMP = new QuartetMapPanel (newData);

		SpinnerNumberModel beginModel = new SpinnerNumberModel (VisRD.getFirstWindow (),
																	VisRD.getFirstWindow (),
																	VisRD.getLastWindow (),
																	10);

		SpinnerNumberModel endModel = new SpinnerNumberModel (VisRD.getLastWindow(), VisRD.getFirstWindow(), VisRD.getLastWindow(), 10);

		if (VisRD.getDisplayQuartets()>newData.size()){ VisRD.setDisplayQuartets (newData.size ()); }

		SpinnerNumberModel quartetModel = new SpinnerNumberModel (VisRD.getDisplayQuartets(), 0,newData.size(),1);

		beginSpinner = new JSpinner (beginModel);
		endSpinner = new JSpinner (endModel);
		quartetSpinner = new JSpinner (quartetModel);

		beginSpinner.addChangeListener (this);
		endSpinner.addChangeListener (this);
		quartetSpinner.addChangeListener (this);

		c.add (new JLabel ("Display start"));
		c.add (beginSpinner);
		c.add (new JLabel ("Display end"));
		c.add (endSpinner);
		c.add (new JLabel ("Quartets to display"));
		c.add (quartetSpinner);

		c.add (aQMP.getSaveButton());

		d.add (aQMP.getStartButton());
		d.add (aQMP.getStopButton());
		d.add(aQMP.getSaveAllFrames());

		goToButton = new JButton ("Go to window");
		d.add (goToButton);

		goToField = new JTextField ("0");
		goToField.setPreferredSize(new Dimension(35,20));
		d.add (goToField);
		
		
		d.add (aQMP.getColorQuartetsLabel());
		d.add (aQMP.getColorQuartetsCombo());
/*
        JButton closeButton = new JButton ("Close display");
        closeButton.addActionListener (new CloseTabListener (home, this));
        d.add (closeButton);
*/
		goToButton.addActionListener (this);

        JPanel aP = new JPanel ();
        aP.add (aQMP);
        JSplitPane cSP = new JSplitPane (JSplitPane.VERTICAL_SPLIT, c, d);

        add (new JSplitPane (JSplitPane.VERTICAL_SPLIT, cSP, new JScrollPane (aP)));
		reset ();
	}
	
			
	public void actionPerformed (ActionEvent e){
		if(e.getSource()==goToButton){
			try{ aQMP.goTo(Integer.parseInt(goToField.getText())); }
			catch(NumberFormatException eX){
				VisRDGUI.displayError("Frame number must be a number!");
				goToField.setText("0");
			}
		}
	}

	public void stateChanged(ChangeEvent e){ reset(); }
	public void reset(){
		aQMP.reset (((Integer) quartetSpinner.getValue ()).intValue (),
					((Integer) beginSpinner.getValue ()).intValue (),
					((Integer) endSpinner.getValue ()).intValue ());
	}
}

