package visrd;

import java.util.Random;

/**

   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

	Class with static functions for generating a starting set of quartets

*/

public class QuartetGenerator {
	private static Quartet[] result;
	private static int quartetPointer;
	
	public static void main(String[] args){
		int[][] matrix = new int[5][];
		matrix[0] = new int[3];
		matrix[1] = new int[104];
		matrix[2] = new int[84];
		matrix[3] = new int[6];
		matrix[4] = new int[25];
		
		int count=0;
		
		for(int a=1;a<matrix.length-3;a++){
		// For each first group
		for(int a_element=0;a_element<matrix[a].length;a_element++){
		// For each element in that first group
			for(int b=a+1;b<matrix.length-2;b++){
			// For each second group
			for(int b_element=0;b_element<matrix[b].length;b_element++){
			// For each element in that second group
				for(int c=b+1;c<matrix.length-1;c++){
				// For each third group
				for(int c_element=0;c_element<matrix[c].length;c_element++){
				// For each element in that third group
					for(int d=c+1;d<matrix.length;d++){
					// For each fourth group
					for(int d_element=0;d_element<matrix[d].length;d_element++){
					// For each element in that fourth group
						count++;
					}
					}
				}
				}
			}
			}
		}
		}
		
		System.out.println("count:" + count);
	}

	public static Quartet[] generateSet(){
		result = new Quartet[VisRD.getDesiredQuartets()];
		quartetPointer=0;
		
		/**

			Should generate as per settings

			Settings will specify:

			- cluster or non-cluster

				- for cluster, four lists
				- for non-cluster, a force list and an include list

			- random or non-random

		*/

		if (VisRD.getUseRandomQuartets ()) {
			// Randomize...
			
			if (VisRD.getClusterQuartets ()) {
				// NRandom clustering
				randomCluster();

			}
			else{
				// Random non-clustering
				randomNonCluster();
			}
		}
		else {
			// Do not randomize...
			if (VisRD.getClusterQuartets ()) {
				// Non-random clustering
				cluster();
			}

			else {
				// Non-random non-clustering
				nonCluster ();
			}
		}
		
		return result;
	}

	/**

		Cluster generation, non-random

	*/
/* Old version of cluster() method - only works for four groups
	public static ArrayList cluster ()
	{

		ArrayList result = new ArrayList ();
		int[] north = VisRD.getTaxaGroup(1);
		int[] south = VisRD.getTaxaGroup(3);
		int[] east = VisRD.getTaxaGroup(2);
		int[] west = VisRD.getTaxaGroup(4);

		for (int a = 0; a < north.length; a++) {

			for (int b = 0; b < south.length; b++) {

				for (int c = 0; c < east.length; c++) {

					for (int d = 0; d < west.length; d++) {

						Quartet q = Quartet.sizeOrder (north[a],south[b],east[c],west[d]);

						result.add (q);

					}

				}

			}

		}

		return result;

	}
*/


	public static void cluster(){
		int[][] matrix = VisRD.getTaxaMatrix();
		
		for(int a=1;a<matrix.length-3;a++){
		// For each first group
		for(int a_element=0;a_element<matrix[a].length;a_element++){
		// For each element in that first group
			for(int b=a+1;b<matrix.length-2;b++){
			// For each second group
			for(int b_element=0;b_element<matrix[b].length;b_element++){
			// For each element in that second group
				for(int c=b+1;c<matrix.length-1;c++){
				// For each third group
				for(int c_element=0;c_element<matrix[c].length;c_element++){
				// For each element in that third group
					for(int d=c+1;d<matrix.length;d++){
					// For each fourth group
					for(int d_element=0;d_element<matrix[d].length;d_element++){
					// For each element in that fourth group
						Quartet q = Quartet.sizeOrder(matrix[a][a_element],
														matrix[b][b_element],
														matrix[c][c_element],
														matrix[d][d_element]);
														
						result[quartetPointer++]=q;
					}
					}
				}
				}
			}
			}
		}
		}
		
		Quartet[] resizedResult = new Quartet[quartetPointer];
		
		for(int i=0;i<quartetPointer;i++){
			resizedResult[i]=result[i];
		}
		
		result=resizedResult;
	}
	
	public static void randomCluster (){
		int desired = VisRD.getDesiredQuartets ();

		Random aR = new Random (System.currentTimeMillis ());
		int[][] matrix = VisRD.getTaxaMatrix();

		for(int n=0;n<desired;n++){
			//	Incorrect: Though random this isn't uniform
			//	int groupA = aR.nextInt(matrix.length-4)+1;
			//	int groupB = aR.nextInt(matrix.length-(3+groupA))+groupA+1;
			//	int groupC = aR.nextInt(matrix.length-(2+groupB))+groupB+1;
			//	int groupD = aR.nextInt(matrix.length-(1+groupC))+groupC+1;

			// Generate 4 random numbers in the interval 1 to matrix.length-1
			// Such that no two numbers are equal
			int groupA = aR.nextInt(matrix.length-1)+1;
			int groupB=groupA;
			int groupC=groupA;
			int groupD=groupA;
			
			while(groupB==groupA)
				groupB = aR.nextInt(matrix.length-1)+1;
			
			while(groupC==groupA||groupC==groupB)
				groupC = aR.nextInt(matrix.length-1)+1;
			
			while(groupD==groupA||groupD==groupB||groupD==groupC)
				groupD = aR.nextInt(matrix.length-1)+1;

		//	System.out.println("[" + groupA + "," + groupB + "," + groupC + "," + groupD + "]");	

			Quartet q = Quartet.sizeOrder (matrix[groupA][aR.nextInt(matrix[groupA].length)],
											matrix[groupB][aR.nextInt(matrix[groupB].length)],
											matrix[groupC][aR.nextInt(matrix[groupC].length)],
											matrix[groupD][aR.nextInt(matrix[groupD].length)]);
			
			result[quartetPointer++]=q;							
		}
	}
	

	/**

		Non-random non-cluster generation

	*/

	static void nonCluster ()
	{
		int[] forceTaxa = VisRD.getForceTaxa();
		int[] includeTaxa = VisRD.getIncludeTaxa();

		/**
			How many are forced? Return none if none remain
		*/	

		if (forceTaxa.length==0) {
			for (int a = 0; a < includeTaxa.length - 3; a++) {
				for (int b = a + 1; b < includeTaxa.length - 2; b++) {
					for (int c = b + 1; c < includeTaxa.length - 1; c++) {
						for (int d = c + 1; d < includeTaxa.length; d++) {
							Quartet q = Quartet.sizeOrder (includeTaxa[a], includeTaxa[b], includeTaxa[c], includeTaxa[d]);
							result[quartetPointer++]=q;
						}
					}
				}
			}
		}
		else if (forceTaxa.length==1) {
			for (int a = 0; a < includeTaxa.length - 2; a++) {
				for (int b = a + 1; b < includeTaxa.length - 1; b++) {
					for (int c = b + 1; c < includeTaxa.length; c++) {
						Quartet q = Quartet.sizeOrder (includeTaxa[a], includeTaxa[b],includeTaxa[c],forceTaxa[0]);
						result[quartetPointer++]=q;
					}
				}
			}
		}
		else if (forceTaxa.length==2) {
			for (int a = 0; a < includeTaxa.length - 1; a++) {
				for (int b = a + 1; b < includeTaxa.length; b++) {
					Quartet q = Quartet.sizeOrder (includeTaxa[a],includeTaxa[b],forceTaxa[0],forceTaxa[1]);
					result[quartetPointer++]=q;
				}
			}
		}

		else if (forceTaxa.length==3) {
			for (int a = 0; a < includeTaxa.length; a++) {
				Quartet q = Quartet.sizeOrder (includeTaxa[a],forceTaxa[0],forceTaxa[1],forceTaxa[2]);
				result[quartetPointer++]=q;
			}
		}
		else if (forceTaxa.length==4) {
			Quartet q = Quartet.sizeOrder (forceTaxa[0],forceTaxa[1],forceTaxa[2],forceTaxa[3]);
			result[quartetPointer++]=q;
		}
		
		
		Quartet[] resizedResult = new Quartet[quartetPointer];
		
		for(int i=0;i<quartetPointer;i++){
			resizedResult[i]=result[i];
		}
		
		result=resizedResult;
	}

	static void randomNonCluster (){
		int[] forceTaxa = VisRD.getForceTaxa ();
		int[] includeTaxa = VisRD.getIncludeTaxa ();
		
		int includeSize = includeTaxa.length;
		int desired = VisRD.getDesiredQuartets ();

		Random aR = new Random (System.currentTimeMillis ());


		/**

			How many are forced? Return none if none remain

		*/

		if (forceTaxa.length==0) {

			while (quartetPointer < desired) {

				Quartet i = new Quartet (aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize));

				while (! i.isUnique ()) {

					i = new Quartet (aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize));

				}

				Quartet q = Quartet.sizeOrder (includeTaxa[i.getX ()],
												includeTaxa[i.getY ()],
												includeTaxa[i.getU ()],
												includeTaxa[i.getV ()]);

				result[quartetPointer++]=q;
			}
		}

		else if (forceTaxa.length == 1) {

			while (quartetPointer < desired) {

				Quartet i = new Quartet (aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize));

				while (! i.isUnique ()) {

					i = new Quartet (aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize));

				}

				Quartet q = Quartet.sizeOrder (forceTaxa[0],
												includeTaxa[i.getY ()],
												includeTaxa[i.getU ()],
												includeTaxa[i.getV ()]);

				result[quartetPointer++]=q;
			}

		}

		else if (forceTaxa.length==2) {

			while (quartetPointer < desired) {

				Quartet i = new Quartet (aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize),
											aR.nextInt (includeSize));

				while (! i.isUnique ()) {

					i = new Quartet (aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize),
												aR.nextInt (includeSize));

				}

				Quartet q = Quartet.sizeOrder (forceTaxa[0],forceTaxa[1],
												includeTaxa[i.getU ()],
												includeTaxa[i.getV ()]);

				result[quartetPointer++]=q;

			}

		}

		else if (forceTaxa.length == 3) {
			while (quartetPointer < desired) {
				int i = aR.nextInt (includeSize);
				Quartet q = Quartet.sizeOrder (forceTaxa[0],forceTaxa[1],forceTaxa[2],includeTaxa[i]);

				result[quartetPointer++]=q;
			}
		}

		else if (forceTaxa.length == 4) {
			while (quartetPointer < desired) {		
				Quartet q = Quartet.sizeOrder (forceTaxa[0],forceTaxa[1],forceTaxa[2],forceTaxa[3]);
				result[quartetPointer++]=q;
			}
		}
	}
}
