package visrd;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;


/**
 * usage: input.nex numberOfReps mode(-r for shuffling, otherwise redistribution)
 * 
 * the nodeHeights for locations need to be debugged!!
 */

public abstract class Permutator {
	private static boolean printToFile;
	
	public static void setPrintToFile(boolean printToFileBoolean){ printToFile=printToFileBoolean; }
	
/*    public static void oldMain(String[] args) throws Exception {

	    	if (args.length < 1) {
	    		System.err.println("usage: alignment numberOfReplicates mode");
	    		System.err.println("\talignment: input alignment file");
	    		System.err.println("\tnumberOfReplicates: number of replicates to be generated");
	    		System.err.println("\tmode: permutation or redistribution (=default). For permutation, type -r");
	    		System.exit(0);
	    	}
        
	    NexusImporter importer = new NexusImporter(new FileReader(args[0]));
        Alignment alignment = importer.importAlignment();
        String file = args[0].substring(0, args[0].lastIndexOf('.'));
        
        int maxTaxonNameLength = 0;        
        for (int x = 0; x < alignment.getSequenceCount(); x ++) {        		
        		String test = alignment.getTaxon(x).getId();
        		if (test.length() > maxTaxonNameLength) {
        			maxTaxonNameLength = test.length();
        		}        		
        }
                
        String mode = "-r";
        if (args.length > 2) {
        		mode = args[2];
        }
        
        if (mode.equals("-s")){
        	
            System.out.println("permutating sites...");
        		String outputFile = file+"_shuffled.nex";
    			PrintWriter outFile = new PrintWriter(new FileWriter(outputFile), true);
    			outFile.print("#NEXUS\r\r");
            
            int numberOfShuffledAlignments = Integer.parseInt(args[1]);
  */          /**
             double [] entropyScores = new double[alignment.getSiteCount()];
             for(int index=0; index<alignment.getSiteCount(); index ++){
         		entropyScores[index] = new ShannonScore(alignment.getSitePattern(index)).getEntropy();
        		}
        		for (int count=0; count<alignment.getSiteCount(); count ++) {
        			System.out.println("entropy for site "+(count)+" is "+entropyScores[count]);
        		}
        		**/
 /*           System.out.print("Replicates: ");
            for (int a = 0; a < numberOfShuffledAlignments; a++) {
            		
            		outFile.print("[Dataset "+(a+1)+"]\r");
            		outFile.print("Begin DATA;\r");
            		outFile.print("\tDIMENSIONS NTAX="+alignment.getSequenceCount()+" NCHAR="+alignment.getSiteCount()+";\r");
            		outFile.print("\tFORMAT MISSING=? GAP=- DATATYPE="+alignment.getDataType()+";\r");
            		outFile.print("\tMATRIX\r");
            		
            		int[] sitePositions =  new int[alignment.getSiteCount()];  
            
            		for (int i = 0; i < alignment.getSiteCount(); i++) {
            			sitePositions[i] = i;
            		}        
            		
            		Random rgen = new Random();
            
            		for (int j=0; j< alignment.getSiteCount(); j++) {
            			int randomPosition = rgen.nextInt(alignment.getSiteCount());
            			int temp = sitePositions[j];
            			sitePositions[j] = sitePositions[randomPosition];
            			sitePositions[randomPosition] = temp;
            		}

            		for (int k=0; k< alignment.getSequenceCount(); k++) {
            			
            			outFile.print(alignment.getTaxon(k).getId());
            			String taxonName = alignment.getTaxon(k).getId();
            			int lengthOfTaxonName = taxonName.length();
            			
            			while (lengthOfTaxonName < maxTaxonNameLength+1) {
            				outFile.print(" ");
            				lengthOfTaxonName++;
            			}
            			
             		for (int l = 0; l < alignment.getSiteCount(); l++) {
                		
            				outFile.print(alignment.getAlignedSequenceString(k).charAt(sitePositions[l]));
             			}
            			outFile.print("\r");
            		}
            		outFile.print("\t;\rEND;\r\r");
            		System.out.print("*");
            }
            outFile.close();
            System.out.println("\rFinished!");
       	
        } else {
        
            System.out.println("redistributing sites...");
	        String outputFile =  file+"_redistributed.nex";
			PrintWriter outFile = new PrintWriter(new FileWriter(outputFile), true);
			outFile.print("#NEXUS\r\r");
	        
	        int numberOfShuffledAlignments = Integer.parseInt(args[1]);
        
			double [] entropyScores = new double[alignment.getSiteCount()];
			for(int index=0; index<alignment.getSiteCount(); index ++){
	     		entropyScores[index] = new ShannonScore(alignment.getSitePattern(index)).getEntropy();
	    		}
	    		for (int count=0; count<alignment.getSiteCount(); count ++) {
	    			System.out.println("entropy for site "+(count)+" is "+entropyScores[count]);
	    		}
	
	    		int[] sitePositions =  new int[alignment.getSiteCount()];  
	            
	    		for (int i = 0; i < alignment.getSiteCount(); i++) {
	    			sitePositions[i] = i;
	    		}        
	
	         System.out.print("Replicates: ");
	    		for (int a = 0; a < numberOfShuffledAlignments; a++) {
	        		
	        		outFile.print("[Dataset "+(a+1)+"]\r");
	        		outFile.print("Begin DATA;\r");
	        		outFile.print("\tDIMENSIONS NTAX="+alignment.getSequenceCount()+" NCHAR="+alignment.getSiteCount()+";\r");
	        		outFile.print("\tFORMAT MISSING=? GAP=- DATATYPE="+alignment.getDataType()+";\r");
	        		outFile.print("\tMATRIX\r");
	        		
	        		
	        		Random rgen = new Random();
	        
	        		for (int j=0; j< alignment.getSiteCount(); j++) {
	        			int randomPosition = rgen.nextInt(alignment.getSiteCount());
	        			int temp = sitePositions[j];
	        			sitePositions[j] = sitePositions[randomPosition];
	        			sitePositions[randomPosition] = temp;
	        		}
	
	        		ArrayList siteObjects = new ArrayList();
	        		
	        		for (int o=0; o < alignment.getSiteCount(); o++) {
	        			
	        			int originalPosition = sitePositions[o];
	        			double originalEntropy = entropyScores[sitePositions[o]];
	        			Site arraySite = new Site(originalPosition,originalEntropy);
	        			siteObjects.add(arraySite);
	        			
	        		}
	        		
	        		
	        		int[] replicatePosition =  new int[alignment.getSiteCount()];
	        		
	        		for (int p=0; p < alignment.getSiteCount(); p++) {
	        			
	        			double currentEntropy = entropyScores[p];
	        			
	        			outer:
	        			for (int q = 0; q < siteObjects.size(); q ++) {
	        				
	        				Site currentSite = new Site();
	        				currentSite = (Site) siteObjects.get(q);
	        				if (currentSite.getEntropy()== currentEntropy) {
	        					replicatePosition[p] = currentSite.getPosition();
	        					siteObjects.remove(q);
	        					break outer;
	        				}
	        				
	        			}
	        		}
	           		        		
	        		
	        		
	        		
	        		for (int k=0; k< alignment.getSequenceCount(); k++) {
	        			
	        			outFile.print(alignment.getTaxon(k).getId());
	        			String taxonName = alignment.getTaxon(k).getId();
	        			int lengthOfTaxonName = taxonName.length();
	        			
	        			while (lengthOfTaxonName < maxTaxonNameLength+1) {
	        				outFile.print(" ");
	        				lengthOfTaxonName++;
	        			}
	        			
	         			for (int l = 0; l < alignment.getSiteCount(); l++) {
	            		
	        				outFile.print(alignment.getAlignedSequenceString(k).charAt(replicatePosition[l]));
	         			}
	        			outFile.print("\r");
	        		}
	        		outFile.print("\t;\rEND;\r\r");
	             System.out.print("*");
	      	
	        }
	        outFile.close();
	        System.out.println("\rFinished!");
        }
    }
*/


    public static String premuteSequences(Taxon[] taxon, int a, boolean useShannon){
//    	 if datasetNumber is 1 then delete old file
//    	 add new dataset to file...
    	
    	
    	String fileName=null;
    	try{
    		System.out.println("Permute sequences");
    		
			// Assumption: all taxa have same number of characters.
			int nChars = taxon[0].getNchar();
			int maxTaxonNameLength = 0; // Only used when saving to NEXUS	
//          System.out.println("permutating sites...");
			System.out.println("printToFile:" + printToFile);

			PrintWriter outFile=null;
			if(printToFile){
				for(Taxon t: taxon){
					if (t.getLabel().length() > maxTaxonNameLength) {
		        		maxTaxonNameLength = t.getLabel().length();
		        	} 
				}
				
	        	String outputFile = "_shuffled.nex";
	        	if(useShannon){ outputFile = "_redistributed.nex"; }
	        	fileName = VisRD.getCurrentPathFilename() + outputFile;

	    		outFile = new PrintWriter(new FileWriter(fileName,a!=1), true);
	    		outFile.print("#NEXUS\r\r");
			}

			double [] entropyScores = new double[nChars];
			if(useShannon){
				for(int index=0; index<nChars; index ++){
					int[] sitePattern = new int[taxon.length];
					for(int i=0;i<taxon.length;i++){
						sitePattern[i]=taxon[i].getCharAt(index);
					}
					
					// Entropy score of 0 means no information.
		     		entropyScores[index] = getShannonEntropy(sitePattern);
	    		}
			}

//            for (int a = 0; a < nDatasets; a++) {          		
        		if(printToFile){
	        		outFile.print("[Dataset "+(a)+"]\r");
	        		outFile.print("Begin DATA;\r");
	        		outFile.print("\tDIMENSIONS NTAX="+taxon.length+" NCHAR="+taxon[0].getNchar() +";\r");
	        		outFile.print("\tFORMAT MISSING=? GAP=- DATATYPE="+taxon[0].getDataTypeName()+";\r");
	        		outFile.print("\tMATRIX\r");
        		}
        		
        		int[] sitePositions =  new int[taxon[0].getNchar()];              
        		for (int i = 0; i < taxon[0].getNchar(); i++) {
        			sitePositions[i] = i;
        		}
        		
	    		// Print scores to screen for testing...
/*	    		for (int count=0; count<20; count ++) {
    				System.out.println("entropy for original site "+(count)+" is "+entropyScores[sitePositions[count]]);
    			}
*/       		

        		Random rgen = new Random();            
        		for (int j=0; j< taxon[0].getNchar(); j++) {
        			int randomPosition = rgen.nextInt(taxon[0].getNchar());
					
					// Swap site position j with randomPosition
        			int temp = sitePositions[j];
        			sitePositions[j] = sitePositions[randomPosition];
        			sitePositions[randomPosition] = temp;
        		}
        		
        		if(useShannon){
	        		int[] originalPosition = new int[nChars];
	        		double[] originalEntropy = new double[nChars];
        			for (int o=0; o < nChars; o++) {
	        			originalPosition[o] = sitePositions[o];
	        			originalEntropy[o] = entropyScores[sitePositions[o]];
	        		}
	        		
        			// Note: Frist we randomly shuffled
       				//ArrayList siteObjects = new ArrayList();
	        		for (int p=0; p < nChars; p++) {		        			
	        			double currentEntropy = entropyScores[p];
	        			
	        			outer:
	        			for (int q = 0; q < originalEntropy.length; q ++) {
	        				if (currentEntropy==originalEntropy[q]&&originalPosition[q]!=-1) {
	        					sitePositions[p] = originalPosition[q];
	        					originalPosition[q]=-1;
	        					break outer;
	        				}
	        				
	        			}
	        		}
/*	        		
		        	for (int count=0; count<20; count ++) {
	    				System.out.println("entropy for new site "+(count)+" is "+entropyScores[sitePositions[count]]);
	    			}
*/	       		}

				if(printToFile){
					printTaxaToFile(taxon,outFile,sitePositions,maxTaxonNameLength);
					outFile.print("\t;\rEND;\r\r");
				}
				//else{  }
				
				shuffleSites(taxon,sitePositions);
				
				ScanWindow.updateProgress(a+1);
//				System.out.print("*");
//            }
            
            if(printToFile){ outFile.close(); }
            System.out.println("\rFinished!");
	    }
	    catch(Exception e){
	    	e.printStackTrace();
	    }
	    
	    return fileName;
    }
  
  	private static void printTaxaToFile(Taxon[] taxon, PrintWriter outFile, int[] sitePositions, int maxTaxonNameLength){
        for (int k=0; k< taxon.length; k++) {
			String taxonName = taxon[k].getLabel();
			outFile.print(taxonName);
			int lengthOfTaxonName = taxonName.length();
			
			while (lengthOfTaxonName < maxTaxonNameLength+1) {
				outFile.print(" ");
				lengthOfTaxonName++;
			}
			
 			for (int j = 0; j < taxon[k].getNchar(); j++) {
				outFile.print(taxon[k].getCharAt(sitePositions[j]));
 			}
			outFile.print("\r");
		}
  	}
  	
  	private static void shuffleSites(Taxon[] taxon, int[] sitePositions){
  		for(int i=0;i<taxon.length;i++){
  			char[] sequence = new char[taxon[i].getNchar()];
  			for (int j = 0; j < taxon[i].getNchar(); j++) {
				sequence[j] = taxon[i].getCharAt(sitePositions[j]);
			}
			taxon[i].setMatrix(sequence);
  		}
  	}
  	
  	private static double getShannonEntropy(int[] scores){
//		make a list of sites that occur		
		ArrayList<Integer> uniqueItemsList = new ArrayList<Integer>();
		for(int val = 0; val <scores.length;val++){
			if(!uniqueItemsList.contains(new Integer(scores[val]))){
				uniqueItemsList.add(new Integer(scores[val]));
			}
		}
		
		int[] uniqueItems = new int[uniqueItemsList.size()];
		for(int i=0; i<uniqueItems.length; i++){
			uniqueItems[i] = uniqueItemsList.get(i).intValue();
		}

		// Now work out the entropy
		double entropy = 0.0;

//		iterate through each site that occurs @ get frequency
		for(int occurring = 0; occurring < uniqueItems.length; occurring ++){
//-			System.out.println(occurring);
			int count = 0;
			for(int obs = 0; obs < scores.length; obs ++){
				if(scores[obs] == uniqueItems[occurring]){
					count ++;
				}
			}
			double likelihood = ((double)count)/((double)scores.length);
			double eventEntropy = -(likelihood * (Math.log(likelihood) / Math.log(uniqueItems.length)));
				
			if (!Double.isNaN(eventEntropy)) {
				entropy += eventEntropy;
			}
		}
		return entropy;
  	}
}