package visrd;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class ParametersPanel extends JPanel{
	private JSpinner stepSpinner, windowSpinner, beginSpinner, endSpinner, quartetSpinner, deltaSpinner;
	private SpinnerNumberModel stepModel, beginModel, windowModel, endModel, quartetModel, deltaModel;
	private JLabel nQuartetsLbl;
	
	public ParametersPanel(Taxon[] taxon){
		// Set up the parameters..	
		int N = taxon.length;
		int maxQuartets = taxon.length * (taxon.length - 1) * (taxon.length - 2) * (taxon.length - 3) / 24;

		
		if (taxon[0].getNchar () < VisRD.getStepSize () || taxon[0].getNchar () < VisRD.getWindowSize ()) {
			VisRD.setWindowSize (1);
			VisRD.setStepSize (1);

			VisRDGUI.displayError("Alignment is very short!");
		}
	
	//	Draw the GUI
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

		// Start general parameters
		JPanel generalParameters = new JPanel(new GridLayout(2,4,0,10));
		generalParameters.setBorder(BorderFactory.createTitledBorder("General"));

		stepModel = new SpinnerNumberModel (VisRD.getStepSize (), 0, taxon[0].getNchar (), 1);
		windowModel = new SpinnerNumberModel (VisRD.getWindowSize (), 0, taxon[0].getNchar (), 25);
		beginModel = new SpinnerNumberModel (0, 0, taxon[0].getNchar (), 25);
		endModel = new SpinnerNumberModel (taxon[0].getNchar (), 0, taxon[0].getNchar (), 25);

		stepSpinner = new JSpinner (stepModel);
		windowSpinner = new JSpinner (windowModel);
		beginSpinner = new JSpinner (beginModel);
		endSpinner = new JSpinner (endModel);

		generalParameters.add(new JLabel("Window size"));
		generalParameters.add(windowSpinner);
		
		generalParameters.add(new JLabel("     Step size"));
		generalParameters.add(stepSpinner);

		generalParameters.add(new JLabel("Scan start"));
		generalParameters.add(beginSpinner);
		
		generalParameters.add(new JLabel("     Scan end"));
		generalParameters.add(endSpinner);

		mainPanel.add(generalParameters);
			
			
		// Start Quartet display parameters
		JPanel displayParameters = new JPanel(new GridLayout(2,4,0,10));
		displayParameters.setBorder(BorderFactory.createTitledBorder("Display"));		

		int displayQuratets = 100;
		if(maxQuartets<displayQuratets){ displayQuratets = maxQuartets; }
		VisRD.setDisplayQuartets(displayQuratets);
		
		quartetModel = new SpinnerNumberModel (displayQuratets, 0, maxQuartets, 10);
		quartetSpinner = new JSpinner (quartetModel);
	
		deltaModel = new SpinnerNumberModel (0.300, 0, 1.0, 0.05);
		deltaSpinner = new JSpinner (deltaModel);
		
		nQuartetsLbl = new JLabel("# of quartets to display (Max# = " + maxQuartets + ")");
		displayParameters.add(nQuartetsLbl);
		displayParameters.add(quartetSpinner);
				
		displayParameters.add(new JLabel("Delta threshold"));
		displayParameters.add(deltaSpinner);
		
		mainPanel.add(displayParameters);

		add(mainPanel);
	}

	public void init (Taxon[] taxon)
	{
		stepModel = new SpinnerNumberModel (VisRD.getStepSize (), 0, taxon[0].getNchar(), 1);
		windowModel = new SpinnerNumberModel (VisRD.getWindowSize (), 0, taxon[0].getNchar(), 10);
		beginModel = new SpinnerNumberModel (0, 0, taxon[0].getNchar(), 10);
		endModel = new SpinnerNumberModel (taxon[0].getNchar(), 0, taxon[0].getNchar(), 10);

		int maxQuartets = (taxon.length) *
							(taxon.length - 1) *
							(taxon.length - 2) *
							(taxon.length - 3) / 24;

		// maxQuartets should be Ntaxa choose 4 eg 6C4 = 15 quartets for 6 taxa. 
		// (n k) = n! / (k! x (n-k)!)
		deltaModel = new SpinnerNumberModel (0.300, 0, 1.0, 0.05);
		
		ScanWindow.init(taxon);
	}
	
	public void update (Taxon[] taxon)
	{
		stepModel.setMaximum (new Integer (taxon[0].getNchar ()));
		stepModel.setValue (VisRD.getStepSize());
		windowModel.setMaximum (new Integer (taxon[0].getNchar ()));
		windowModel.setValue (VisRD.getWindowSize());
		beginModel.setMaximum (new Integer (taxon[0].getNchar ()));
		beginModel.setValue ((Object) new Integer (0));
		endModel.setMaximum (new Integer (taxon[0].getNchar ()));
		endModel.setValue ((Object) new Integer (taxon[0].getNchar ()));

		int maxQuartets = (taxon.length) *
							(taxon.length - 1) *
							(taxon.length - 2) *
							(taxon.length - 3) / 24;

		quartetModel.setMaximum (new Integer (maxQuartets));
		nQuartetsLbl.setText("# of quartets to display (Max# = " + maxQuartets + ")");
		quartetModel.setValue (VisRD.getDisplayQuartets());
		
		ScanWindow.update(taxon);			
	}

	public void harvest ()
	{
		VisRD.setDisplayQuartets (((Integer) quartetSpinner.getValue ()).intValue ());
		VisRD.setDeltaThreshold (((Double) deltaSpinner.getValue ()).doubleValue ());
		VisRD.setFirstWindow (((Integer) beginSpinner.getValue ()).intValue () + (((Integer) windowSpinner.getValue ()).intValue () / 2));
		VisRD.setLastWindow (((Integer) endSpinner.getValue ()).intValue () - (((Integer) windowSpinner.getValue ()).intValue () / 2));
		VisRD.setStepSize (((Integer) stepSpinner.getValue ()).intValue ());
		VisRD.setWindowSize (((Integer) windowSpinner.getValue ()).intValue ());
		VisRD.setDisplayQuartets (((Integer) quartetSpinner.getValue ()).intValue ());
		VisRD.setDeltaThreshold (((Double) deltaSpinner.getValue ()).doubleValue ());
		ScanWindow.harvest();
	}
}