package visrd;

import javax.swing.*;
import javax.swing.event.*;

/**
   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

	Occupancy Plot graph
	An occupancy plot summarizes the information contained in a Highway plot

*/

public class OccupancyPlot extends JSplitPane implements ChangeListener{
	private OccupancyPanel aHWP;
	private JSpinner beginSpinner, endSpinner, quartetSpinner, deltaSpinner;

    public OccupancyPlot (QuartetSet newData, JTabbedPane home){
    	super (VERTICAL_SPLIT);

        JPanel aPanel = new JPanel ();
        JPanel bPanel = new JPanel ();

		aHWP = new OccupancyPanel (newData);

		aHWP.set (VisRD.getDisplayQuartets (),
					VisRD.getFirstWindow (),
					VisRD.getLastWindow (),
					VisRD.getDeltaThreshold ());

		SpinnerNumberModel beginModel = new SpinnerNumberModel (VisRD.getFirstWindow (),
																	VisRD.getFirstWindow (),
																	VisRD.getLastWindow (),
																	10);

		SpinnerNumberModel endModel = new SpinnerNumberModel (VisRD.getLastWindow (),
																	VisRD.getFirstWindow (),
																	VisRD.getLastWindow (),
																	10);

		if (VisRD.getDisplayQuartets () > newData.size ()) {
			VisRD.setDisplayQuartets (newData.size ());
		}

		SpinnerNumberModel quartetModel = new SpinnerNumberModel (VisRD.getDisplayQuartets (),
																	1,
																	newData.size (),
																	1);

		SpinnerNumberModel deltaModel = new SpinnerNumberModel (VisRD.getDeltaThreshold (),
																	0,
																	1.0,
																	0.05);

		beginSpinner = new JSpinner (beginModel);
		endSpinner = new JSpinner (endModel);
		quartetSpinner = new JSpinner (quartetModel);
		deltaSpinner = new JSpinner (deltaModel);
		deltaSpinner.setPreferredSize(new java.awt.Dimension(50,20));

		beginSpinner.addChangeListener (this);
		endSpinner.addChangeListener (this);
		quartetSpinner.addChangeListener (this);
		deltaSpinner.addChangeListener (this);

        aPanel.add (new JLabel ("Display start"));
        aPanel.add (beginSpinner);
        aPanel.add (new JLabel ("Display end"));
        aPanel.add (endSpinner);
        aPanel.add (new JLabel ("Quartets to display"));
        aPanel.add (quartetSpinner);
        aPanel.add (new JLabel ("Delta threshold"));
        aPanel.add (deltaSpinner);
        
        bPanel.add (aHWP.getClearMarkersButton());
        bPanel.add (aHWP.getSaveButton());
        
        aHWP.redraw ();

        JPanel morePanel = new JPanel ();
        morePanel.add (aHWP);

        JSplitPane top = new JSplitPane (VERTICAL_SPLIT, aPanel, bPanel);

        setTopComponent (top);
        setBottomComponent (new JScrollPane (morePanel));
	}

	public void stateChanged (ChangeEvent e){
		aHWP.set (((Integer) quartetSpinner.getValue ()).intValue (),
					((Integer) beginSpinner.getValue ()).intValue (),
					((Integer) endSpinner.getValue ()).intValue (),
					((Double) deltaSpinner.getValue ()).doubleValue ());

		aHWP.redraw ();
	}
}