package visrd;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

/*

    Created using IntelliJ IDEA.
    User: forslund
    Date: Dec 10, 2003
    Time: 1:17:23 AM
 
*/

public class OccupancyPanel extends VisRDPanel implements MouseListener{
	private int[] positions;
	private ArrayList zones;

	private int noQuartets, beginIndex, endIndex;
	private int graphHeight, graphWidth, diaWidth;

	private double deltaThreshold;

    private BufferedImage theImage;

	private ArrayList<Integer> markers;
	private JButton clearButton;
	
	public OccupancyPanel (QuartetSet newData){
		super(newData, 940, 460);
		
        addMouseListener (this);
		setPreferredSize (new Dimension (840, 460));

		markers = new ArrayList<Integer>();

		graphWidth = 800;
		graphHeight = 400;

		Triplet[] t = newData.getTrajectory (0);
		
	//	int nWindows=newData.getTrajectory (0);
		
		// The 3 different lines c1, c2, c3
		int[] c1 = new int[t.length];
		int[] c2 = new int[t.length];
		int[] c3 = new int[t.length];
		int ct = 0;
		
		positions = new int[t.length];
		zones = new ArrayList ();

		for (int m = 0; m < t.length; m++) {
			positions[m]=(int)t[m].getC();

			zones.add (new ArrayList ());
		}

		/**

			Position are the positions, corresponding to
			the zones. The zones are such that... they
			are lists of triplets, from the bottom
			up containing zone frequencies of more
			and more (less and less varying) things

		*/

		/**

			Loop through quartets, the most significant first

		*/

		for (int m = newData.size () - 1; m > - 1; m--) {
			t = newData.getTrajectory (m);

			/**

				It contributes to each position

			*/

			/**

				Number accounted for

			*/

			ct++;

			for (int n = 0; n < t.length; n++) {

				double a = t[n].toPolar ().getA ();

				double border = ((double) 2) / ((double) 3);

				if (a < border && a > - border) { // Middle
					c1[n]++;
				}
				else if (a > border) { // Top
					c2[n]++;
				}
				else if (a < - border) { // Bottom
					c3[n]++;
				}

				Triplet aTriplet = new Triplet (((double) c1[n]) / ct,
												((double) c2[n]) / ct,
												((double) c3[n]) / ct);

				((ArrayList) zones.get (n)).add (aTriplet);
			}

		}

        theImage = new BufferedImage (940, 460, BufferedImage.TYPE_INT_ARGB);

        redraw ();
	}
	
	public void doActionPerformed(Object source){
		if(source==clearButton){ clearMarkers(); }
	}
	
	public JButton getClearMarkersButton(){
	    clearButton = new JButton ("Clear markers");
        clearButton.addActionListener (this);
        return clearButton;
	}
	
	public void mouseClicked (MouseEvent e){ addMarkerGraph (e.getX ()); }
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
	public void mousePressed(MouseEvent e){}
	public void mouseReleased(MouseEvent e){}
			
    protected void paintComponent(Graphics g){ g.drawImage (theImage, 0, 0, null); }

    public void redraw(){
        draw ((Graphics2D)theImage.getGraphics ());
        repaint ();
    }

	protected void draw (Graphics2D g)
	{

		float w = (float) 1.0;

		g.setColor (new Color (w, w, w));

		g.fillRect (0, 0, 880, 460);

		diaWidth = (endIndex - beginIndex);

		/**

			Sequence scale

		*/

		g.setColor (Color.BLACK);

		for (int a = 0; a < 20; a++) {

			int pos = 40 + graphWidth * a / 20;
			int sPos = beginIndex + diaWidth * a / 20;


			g.drawLine (pos, 440, pos, 420);

			g.drawString ("" + sPos, pos, 430);

		}

		/**

			Occupancy scale

		*/

		String[] marks = {"1.0", "0.9", "0.8", "0.7", "0.6", "0.5", "0.4", "0.3", "0.2", "0.1", "0.0"};

		for (int a = 0; a < 11; a ++) {
			g.drawLine (0, a * graphHeight / 10, 10, a * graphHeight / 10);
			g.drawString (marks[a], 11, a * graphHeight / 10 + 10);
		}

		/**

			Loop by position...

		*/

		int previous = 0;

		for (int n = 0; n < positions.length; n++) {
			int x = positions[n];
			int pX = positions[previous];

			if (x >= beginIndex && x <= endIndex && pX >= beginIndex && pX <= endIndex) {

				double c1 = ((Triplet) ((ArrayList) zones.get (n)).get (noQuartets - 1)).getA ();
				double c2 = ((Triplet) ((ArrayList) zones.get (n)).get (noQuartets - 1)).getB ();
				double c3 = ((Triplet) ((ArrayList) zones.get (n)).get (noQuartets - 1)).getC ();

				double cP1 = ((Triplet) ((ArrayList) zones.get (previous)).get (noQuartets - 1)).getA ();
				double cP2 = ((Triplet) ((ArrayList) zones.get (previous)).get (noQuartets - 1)).getB ();
				double cP3 = ((Triplet) ((ArrayList) zones.get (previous)).get (noQuartets - 1)).getC ();

				int gX = 40 + (x - beginIndex) * graphWidth / diaWidth;
				int gPX = 40 + (pX - beginIndex) * graphWidth / diaWidth;

				int y1 = (int) ((1.0 - c1) * graphHeight);
				int y2 = (int) ((1.0 - c2) * graphHeight);
				int y3 = (int) ((1.0 - c3) * graphHeight);

				int yP1 = (int) ((1.0 - cP1) * graphHeight);
				int yP2 = (int) ((1.0 - cP2) * graphHeight);
				int yP3 = (int) ((1.0 - cP3) * graphHeight);

				g.setColor (Color.BLUE);
				g.drawLine (gPX, yP1, gX, y1);

				g.setColor (Color.RED);
				g.drawLine (gPX, yP2, gX, y2);

				g.setColor (Color.GREEN);
				g.drawLine (gPX, yP3, gX, y3);

			}

			previous = n;
		}

		// Marker lines
		for (int a = 0; a < markers.size (); a++) {
			int sPos = ((Integer) markers.get (a)).intValue ();
			int xPos = 40 + (sPos - beginIndex) * graphWidth / diaWidth;

			g.setColor (Color.RED);
			g.drawLine (xPos, 0, xPos, graphHeight);
		}
	}

	public void set (int newNoQuartets, int newBeginIndex, int newEndIndex, double newDeltaThreshold)
	{

		noQuartets = newNoQuartets;
		beginIndex = newBeginIndex;
		endIndex = newEndIndex;
		deltaThreshold = newDeltaThreshold;

		if (noQuartets > ((ArrayList) zones.get (0)).size ()) {
			noQuartets = ((ArrayList) zones.get (0)).size ();
		}

		if(noQuartets < 1){noQuartets = 1; }
	}

	public void addMarkerSequence (int newSPos){
		markers.add (new Integer (newSPos));
		redraw ();
	}

	public void addMarkerGraph (int newXPos){
		int newSPos = (newXPos - 40) * diaWidth / graphWidth + beginIndex;
		
		markers.add (new Integer (newSPos));
		redraw ();
	}

	public void clearMarkers (){
		markers.clear ();
		redraw ();
	}
}
