// This is a new nexus file loader
package visrd;

import javax.swing.*;
import java.io.*;
import java.util.*;

public abstract class NexusIO {
	private static Taxon[] taxon;
	private static int taxaPointer=0;
	
	private static int setNumber; // Replicate set counter
	
	private static int numberOfChars;
	
	private static StringBuffer allCharData;
	
	private static BufferedReader br;
	private static String fileLine;
	private static int currentBlock;
	
	private static final int TAXA=0, CHARACTERS=1, DATA = 2, UNKNOWN=99;
	private static final String[] blockName = {"taxa","characters","data"};

	private static boolean inMatrix=false;
	private static boolean containsMultipleDataSets;
	private static ArrayList<RankingResults> rankingResults;

	private static final String TEST_FILE = "C:\\Program Files\\JCreatorV3\\MyProjects\\VisRD\\Nexus\\BG-old.nex";

	public static void main(String[] args){
		loadFile(new File(TEST_FILE));
//		System.out.println(getNumericPart("ntax=22"));
//		System.out.println(getNumericPart("ntafx=78;"));

		double d = 4.5;
		int j=3;
		System.out.println(((d+3)/j));
	}
	
	public static boolean containsMultipleDataSets(){ return containsMultipleDataSets; }
	public static void setContainsMultipleDataSets(boolean b){ containsMultipleDataSets=b; }
	
	public static boolean containsMultipleDataSets(File f){
		// Determine the number of matrices i.e. difference between standard nexus and simulated data sets
		
		try{
			int numberOfMatrices=0;
			BufferedReader br = new BufferedReader(new FileReader(f));
			String fileLine = br.readLine();
			
			while(fileLine!=null){
				if(fileLine.toLowerCase().endsWith("matrix")){ numberOfMatrices++; }
				if(numberOfMatrices>1){ br.close(); return true; }
				fileLine = br.readLine();
			}
			
			br.close();
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
		return false;
	}

	public static void loadFile(File f){
		containsMultipleDataSets = containsMultipleDataSets(f);
	
		if(containsMultipleDataSets){
			setNumber=0;
			// Show scan options only
			
			if(VisRD.getShowGUI()&&ScanWindow.thisWindow==null){ ScanWindow.thisWindow = new ScanWindow(VisRD.getAllTaxon(), f); }
			else if(VisRD.getShowGUI()){ ScanWindow.thisWindow.show(f); }
		}
		else{
			loadData(f);
		}
	}

	public static void loadData(File f){
		
		// At this point all settings should be know given a replicate file
		taxon = null;
		taxaPointer=0;
		inMatrix=false;
		allCharData = new StringBuffer();

		try{
			br = new BufferedReader(new FileReader(f));
			Taxon currentTaxon=null;
			resetRankingResults();

			continueToLoadFile();
			
			System.out.println("Fasta: Is DNA/RNA: " + Taxon.inferIsDNAorRNA(allCharData.toString()));
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
		if(!containsMultipleDataSets){ VisRD.setTaxon(taxon); }
	}
	
	public static void continueToLoadFile(){
		try{
			System.out.println("continueToLoadFile()...");
			
			fileLine = br.readLine();
			
			while(fileLine!=null){
			//	System.out.println("[" + fileLine + "]");
				
				if(fileLine.length()>0){
					String[] data = fileLine.split(" ");
					int numValidTokens=0;
					
					for(int i =0;i<data.length;i++){
						data[i] = data[i].trim();
						if(data[i].length()>0){ numValidTokens++; }
					}
					
					String[] token = new String[numValidTokens];
					int tokenPointer=0;
					
					for(int i =0;i<data.length;i++){
						if(data[i].length()>0){
							token[tokenPointer++] = data[i];
						}
					}
					
					if(token[0].equalsIgnoreCase("begin")){
						// This is the beginning of a new nexus block
						System.out.println("Begin block '" + token[1] + "'");
						String thisBlockName = token[1].substring(0,token[1].length()-1).toLowerCase();
						currentBlock=UNKNOWN;
						
						for(int i=0;i<blockName.length;i++){
							if(thisBlockName.startsWith(blockName[i])){
								currentBlock=i;
							}
						}
						
						if(currentBlock!=UNKNOWN){ System.out.println("BEGIN BLOCK NAME " + blockName[currentBlock]); }
					}
					else if(containsMultipleDataSets&&token[0].equalsIgnoreCase("end;")){
						int startSet = ScanWindow.getStartSet();
						int endSet = ScanWindow.getEndSet();

						ScanWindow.updateSetNumber(++setNumber);
						if(startSet==-1||(setNumber>=startSet&&setNumber<=endSet)){
							scanReplicateTaxa();
							return;
						}
						else{
							continueToLoadFile();
							return;
						}
					}
					else{
						processData(token);
					}
				}
				fileLine = br.readLine();
			}

//			If file contains many datasets the only way we know we're at the end is when we reach end of the file
			if(containsMultipleDataSets){ saveRankingResults(); }
		}
		catch(Exception e){ e.printStackTrace(); }
	}
	
	private static void processData(String[] token){
		// The processing depends on the current nexus block => use a switch statement
		
		// if block or character data...
		
		
		if(token[0].equalsIgnoreCase("dimensions")){
			System.out.println("Dimensions:");
			
			for(int i =0;i<token.length;i++){
		//		System.out.println(i + ": " + token[i]);
				
				String currentToken = token[i].toLowerCase();
				
				if(currentToken.substring(0,4).equals("ntax")){
					String nTaxa = getNumericPart(currentToken);
					System.out.println("Number of taxa:" + nTaxa);
					if(taxon==null){ taxon = new Taxon[Integer.parseInt(nTaxa)]; }
				}
				else if(currentToken.substring(0,5).equals("nchar")){
					String nChar = getNumericPart(currentToken);
					System.out.println("Number of chars:" + nChar);	
					numberOfChars = Integer.parseInt(nChar);
				}
			}
		}
		else if(token[0].length()>8&&token[0].substring(0,9).equalsIgnoreCase("matchchar")){
			char matchChar = token[0].charAt(token[0].length()-1);
			System.out.println("MatchChar: '" + matchChar + "'");
			
			Taxon.setMatchChar(matchChar);
		}
		else{
		//	System.out.println(0 + ": " + token[0]);
			
			if(inMatrix&&(currentBlock==CHARACTERS||currentBlock==DATA)){ processMatrixData(token); }
			else{
				if(token[0].equalsIgnoreCase("Matrix")){
					inMatrix=true;

					// if(taxon[0]!=null){ System.out.println("Taxon.toString(): " + taxon[0].toString()); }

					if(containsMultipleDataSets){
						taxon = new Taxon[taxon.length]; // Reset the taxa
					}
				}
			}

		}
		// end if block is data
	}
	
	private static void processMatrixData(String[] token){
		if(token[0].equals(";")){
			inMatrix=false;
		}
		else{
			// Does the first token match a taxa?
			if(!token[0].equals("[")){
				if(taxaPointer==taxon.length){ taxaPointer=0; } // Loop around..
				
				if(taxon[taxaPointer]==null){
					// Need to set up this taxa
			//		System.out.println("Taxa: " + token[0]);
					String label = token[0];
					if(label.charAt(0)=='\''){ label=label.substring(1,label.length()-1); }
					
					taxon[taxaPointer] = new Taxon(label);
					taxon[taxaPointer].initializeCharacterMatrix(numberOfChars);
				}
				
				for(int i=1;i<token.length;i++){
					String data = token[i].toLowerCase();
					taxon[taxaPointer].appendCharToMatrix(data,taxon[0]);
					if(taxaPointer==0){ allCharData.append(data); }
			//		System.out.println("Data: " + data);
				}
				
				taxaPointer++;
			}
		}
	}
	
	private static void scanReplicateTaxa(){
		System.out.println("containsMultipleDataSets: End of matrix detected!!");
		
		// Scan the taxa set according to preselected scan options
		// Must not change groups etc. so update alignments of existing taxa
		
		// For each new taxa update the alignment of the taxa in VisRD
		
		Taxon[] oldTaxa = VisRD.getAllTaxon();
		
		if(oldTaxa.length!=taxon.length){
			VisRDGUI.displayError("Simulated data contains " + taxon.length + " whereas the current data set contains " + oldTaxa.length + " taxa - scan aborted!");
			return;
		}
		
		for(int i=0;i<taxon.length;i++){
			boolean foundMatch=false;
			for(int j=0;j<oldTaxa.length;j++){
				if(taxon[i].getLabel().equals(oldTaxa[j].getLabel())){
					foundMatch=true;
					oldTaxa[j].setMatrix(taxon[i].getMatrix());
				}
			}
			
			if(!foundMatch){
				VisRDGUI.displayError("Could not find taxa '" + taxon[i].getLabel() + "' in the non-simulated data set - scan aborted!");
				return;
			}
		}
		
	//	VisRDGUI.displayError("Replicate loaded correctly, continuing to scan the alignment...");
		
		
		// Now the data has been set up we can scan it and output the cv to our CSV file
		
		
		VisRD aVisRD = new VisRD ();

		try { // running VisRD analysis
			aVisRD.start();
		}
		catch (Exception e) {
			VisRDGUI.displayError ("Error while scanning: " + e.getMessage());
		}
	}
	
	public static void informScanComplete(){
		System.out.println("Inform scan complete");
		addLatestRankingResult();
		
		if(containsMultipleDataSets){
			// Now do the ranking and output the cv to a csv file...
			continueToLoadFile();
			
	//		sw.dispose();
		}
	}
	
	public static void addLatestRankingResult(){
		if(rankingResults==null){ rankingResults = new ArrayList<RankingResults>(); }

		rankingResults.add(VisRDGUI.getRankingResults());
	}
	
	private static String getNumericPart(String s){
		int startPoint = 0;
		int endPoint = -1;
					
		for(int i=0;i<s.length();i++){
			if(Character.isDigit(s.charAt(i))){
				endPoint=i;
			}
			else{
				if(endPoint<startPoint){ // We haven't found the numbers yet...
					startPoint++;
				}
				else{
					return s.substring(startPoint,endPoint+1);
				}
			}
		}
		
		return s.substring(startPoint,endPoint+1);
	}
	
	public static void saveRankingResults(){
		try{
			if(rankingResults==null||rankingResults.size()==1){ return; /*This is a single data set file*/ }
			System.out.println("saveRankingResults()");
			String sets = "-all";
			int startSet = ScanWindow.getStartSet();
			
			if(startSet!=-1){
				sets="-" + startSet + "to" + ScanWindow.getEndSet();
			}
			else{
				startSet=0;
				
				// Determine the last set using the data already saved...
				String pathPlusFile = VisRD.getCurrentPathFilename();
				int endIndex = pathPlusFile.length()-1;
				int index=endIndex;
				
				while(endIndex==pathPlusFile.length()-1){
					if(pathPlusFile.charAt(index)==File.separatorChar){
						endIndex=index;
					}
					else{ index--;}
				}
				
				
				String currentFile = pathPlusFile.substring(endIndex+1,pathPlusFile.length());
				File dir = new File(pathPlusFile.substring(0,endIndex));
				File[] files = dir.listFiles();
				
				for(File f:files){
					String name = f.getName();
					if(name.startsWith(currentFile)){
						if(name.substring(name.length()-3,name.length()).equalsIgnoreCase("csv")){
							int i=name.length()-5;
							
							while(Character.isDigit(name.charAt(i))){
								i--;
							}
							
							String datasetNumber = name.substring(i+1,name.length()-4);
							if(datasetNumber.length()!=0){
								int num = Integer.parseInt(datasetNumber);
								if(num>startSet){ startSet=num; }
							}
						}
					}
				}
				startSet++; // Start at next available set
				
				sets="-" + (startSet) + "to" + (startSet+rankingResults.size()-1);
			}
			
			String resultFileName = VisRD.getCurrentPathFilename() + "-results" + sets + ".csv";
			System.out.println("Saving results to: [" + resultFileName + "]");
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(resultFileName)));

			out.print("rep set,");
			for(int i=0;i<rankingResults.size();i++){
				out.print(i+startSet);
				if(i!=rankingResults.size()-1){ out.print(','); }
				else{ out.println(); }
			}
			
			Object[] labelSet = VisRD.getLabelSet();

			for(int lblIndex=0;lblIndex<=labelSet.length;lblIndex++){
				if(lblIndex==0){ out.print("average of X,"); }
				else{ out.print("average of X -" + labelSet[lblIndex-1] + ","); }
				for(int i=0;i<rankingResults.size();i++){
					RankingResults rr = rankingResults.get(i);
					out.print(rr.getAverage(lblIndex));
					if(i!=rankingResults.size()-1){ out.print(','); }
					else{ out.println(); }
				}
			}
			out.println();
			out.println();
			
			for(int lblIndex=0;lblIndex<=labelSet.length;lblIndex++){
				if(lblIndex==0){ out.print("variance of X,"); }
				else{ out.print("variance of X -" + labelSet[lblIndex-1] + ","); }
				for(int i=0;i<rankingResults.size();i++){
					RankingResults rr = rankingResults.get(i);
					out.print(rr.getVariance(lblIndex));
					if(i!=rankingResults.size()-1){ out.print(','); }
					else{ out.println(); }
				}
			}
			
			out.println();
			out.println();
			
			for(int lblIndex=0;lblIndex<=labelSet.length;lblIndex++){
				if(lblIndex==0){ out.print("coVariance of X,"); }
				else{ out.print("coVariance of X -" + labelSet[lblIndex-1] + ","); }
				for(int i=0;i<rankingResults.size();i++){
					RankingResults rr = rankingResults.get(i);
					out.print(rr.getCoVariance(lblIndex));
					if(i!=rankingResults.size()-1){ out.print(','); }
					else{ out.println(); }
				}
			}
			
			out.flush();
			out.close();
			
			VisRDGUI.displayMessage(resultFileName + " saved!", javax.swing.JOptionPane.INFORMATION_MESSAGE);
			System.gc();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public static void resetRankingResults(){
		if(rankingResults!=null){ rankingResults.clear(); }
	}
}