// This is a utility class that may be useful for any project...
package visrd;

import java.io.*;
import org.jibble.epsgraphics.EpsGraphics2D;
import java.util.Hashtable;

public abstract class IOHandler{
	public static Hashtable processArguments(String[] args){
		Hashtable at = new Hashtable();
		int i=0;

		while(i<args.length){
			String key = args[i++];
			String value = null;
			
			if(args[i]!=null&&args[i].charAt(0)!='-'){
				value = args[i++];
			}

			at.put(key,value);
		}
		
		return at;
	}
	
	public static EpsGraphics2D getEpsGraphics2D(String fileName,int width,int height) throws Exception{
		// Output to eps
		FileOutputStream outputStream = new FileOutputStream(fileName);
		
		// Create a new document with bounding box 0 <= x <= 100 and 0 <= y <= 100.
		return new EpsGraphics2D("VisRD output", outputStream, 0, 0, width, height);
	}
	
	public static String getExtension(java.io.File f){
	    String s = f.getName();
	    int i = s.lastIndexOf('.');
	    if (i > 0 &&  i < s.length() - 1){
	    	return s.substring(i+1).toLowerCase();
	    }
    
	    return "";
	}
	
	public static void dumpCharacterData(Taxon[] taxon){
		try{
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter("char_dump.txt")));
			
			for(int i=0;i<taxon.length;i++){
				writer.println(taxon[i]);
			}
			
			writer.flush();
			writer.close();
		}
		catch(IOException e){
			e.printStackTrace();
		}
	}
	
	public static void loadFile(File f){
		// Need to determine the format and then select the appropriate parser (Nexus/Fasta)
        String extension = getExtension(f);
	   	VisRD.setCurrentFile(f);

        if(arrayContains(extension,NexusFilter.EXTENSION)){
        	System.out.println("nexus");
        	NexusIO.loadFile(f);
        }
        else if(arrayContains(extension,FastaFilter.EXTENSION)){
        	System.out.println("fasta");
        	NexusIO.setContainsMultipleDataSets(false);
        	FastaIO.loadFile(f);
		}
		
        System.out.println("unknown");
	}
	
	public static boolean arrayContains(String s, String[] array){
		for(int i=0;i<array.length;i++){
			if(s.equals(array[i])){
				return true;
			}
		}
		
		return false;
	}
}


class MyFilter extends javax.swing.filechooser.FileFilter{
	public String EXTENSION[];
	
	public MyFilter(String[] ext){ EXTENSION=ext; }
	
	public boolean accept(File f){
		try{
			if (f.isDirectory()){ return true; }
	
			String extension = IOHandler.getExtension(f);
			for(int i=0;i<EXTENSION.length;i++){
				if(EXTENSION[i].equalsIgnoreCase(extension)){ return true; }
			}
	
		    return false;
	    }
	    catch(Exception e){
	    	return false;
	    }
	}
	
	public String getDescription(){ return "Generic filter"; }
	public String getPath(javax.swing.JFileChooser jfc){
		String path = jfc.getSelectedFile().getPath();
		
		boolean hasExtension=false;
		for(int i=0;i<EXTENSION.length;i++){
			if(path.endsWith(EXTENSION[i])){ hasExtension=true; }
		}
		if(hasExtension==false){ path+= "." + EXTENSION[0]; }
		
		return path;
	}
}

class NexusFilter extends MyFilter{
	public static final String[] EXTENSION = {"nex","nxs"};
	public NexusFilter(){ super(EXTENSION); }
	public String getDescription(){ return "NEXUS Files (*.nex,*.nxs)"; }
}

class EPSFilter extends MyFilter{
	public static final String[] EXTENSION = {"eps"};
	public EPSFilter(){ super(EXTENSION); }
	public String getDescription(){ return "Encapsulated PostScript Files (*.eps)"; }
}

class FastaFilter extends MyFilter{
	public static final String[] EXTENSION = {"fsa","vse"};
	public FastaFilter(){ super(EXTENSION); }
	public String getDescription(){ return "Fasta Files (*.fsa,*.vse)"; }
}
