package visrd;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**

   This file is part of VisRD

   Copyright (C) 2002 Kristoffer Forslund (jeanpaulsartre@hotmail.com)
   for the Linnaeus Centre for Bioinformatics, Uppsala University

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with VisRD; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**

	Highway Plot graph
	The information contained in the sequence of quartet mapping triangles
	is compressed into a highway plot.
*/

public class HighwayPlot extends JSplitPane implements ActionListener, ChangeListener{
	private HighwayPanel aHWP;
	private JButton autoButton, removeButton;
	private JSpinner beginSpinner, endSpinner, quartetSpinner, deltaSpinner;
	
    public HighwayPlot (QuartetSet newData, JTabbedPane home)
    {

        super (VERTICAL_SPLIT);

        JPanel aPanel = new JPanel ();
        JPanel bPanel = new JPanel ();

		aHWP = new HighwayPanel (newData);

		aHWP.set (VisRD.getDisplayQuartets (),
					VisRD.getFirstWindow (),
					VisRD.getLastWindow (),
					VisRD.getDeltaThreshold (),
					VisRD.getUseStepwise ());

		SpinnerNumberModel beginModel = new SpinnerNumberModel (VisRD.getFirstWindow (),
																	VisRD.getFirstWindow (),
																	VisRD.getLastWindow (),
																	10);

		SpinnerNumberModel endModel = new SpinnerNumberModel (VisRD.getLastWindow (),
																	VisRD.getFirstWindow (),
																	VisRD.getLastWindow (),
																	10);

		if (VisRD.getDisplayQuartets () > newData.size ()) {
		
			VisRD.setDisplayQuartets (newData.size ());
			
		}

		SpinnerNumberModel quartetModel = new SpinnerNumberModel (VisRD.getDisplayQuartets (),
																	1,
																	newData.size (),
																	1);

		SpinnerNumberModel deltaModel = new SpinnerNumberModel (VisRD.getDeltaThreshold (),
																	0,
																	1.0,
																	0.05);

		beginSpinner = new JSpinner (beginModel);
		endSpinner = new JSpinner (endModel);
		quartetSpinner = new JSpinner (quartetModel);
		deltaSpinner = new JSpinner (deltaModel);
		deltaSpinner.setPreferredSize(new java.awt.Dimension(50,20));

		beginSpinner.addChangeListener(this);
		endSpinner.addChangeListener(this);
		quartetSpinner.addChangeListener(this);
		deltaSpinner.addChangeListener(this);

		aPanel.add (new JLabel ("Display start"));
		aPanel.add (beginSpinner);
		aPanel.add (new JLabel ("Display end"));
		aPanel.add (endSpinner);
		aPanel.add (new JLabel ("Quartets to display"));
		aPanel.add (quartetSpinner);
		aPanel.add (new JLabel ("Delta threshold"));
		aPanel.add (deltaSpinner);

		autoButton = new JButton ("Auto markers");
		autoButton.addActionListener (this);
		bPanel.add (autoButton);
		
		removeButton = new JButton ("Clear markers");
		removeButton.addActionListener (this);
		bPanel.add (removeButton);
		
		bPanel.add (aHWP.getSaveButton());
		
		bPanel.add (aHWP.getColorQuartetsLabel());
		bPanel.add (aHWP.getColorQuartetsCombo());
		

		
		
/*
        JButton closeButton = new JButton ("Close display");
        closeButton.addActionListener (new CloseTabListener (home, this));
        bPanel.add (closeButton);
*/

        aHWP.redraw ();

        JPanel morePanel = new JPanel ();
        morePanel.add (aHWP);

        JSplitPane top = new JSplitPane (VERTICAL_SPLIT, aPanel, bPanel);

        setTopComponent (top);
        setBottomComponent (new JScrollPane (morePanel));
	}
	
		
	public void actionPerformed(ActionEvent e){
		if(e.getSource()==removeButton){
			aHWP.clearMarkers();
		}
		else{
			aHWP.autoMarkers();
		}
	}

	//Reset function, when things change..
	public void stateChanged (ChangeEvent e){
		aHWP.set (((Integer) quartetSpinner.getValue ()).intValue (),
					((Integer) beginSpinner.getValue ()).intValue (),
					((Integer) endSpinner.getValue ()).intValue (),
					((Double) deltaSpinner.getValue ()).doubleValue (),
					VisRD.getUseStepwise ());

		aHWP.redraw ();
	}
}