// This deals with all the fasta IO stuff

package visrd;


import java.io.*;
import java.util.*;


public abstract class FastaIO {
	private static final String EXAMPLE_FILE = "C:\\Program Files\\JCreatorV3\\MyProjects\\VisRD\\FastA\\example.fsa";
	private static final String TEST_FILE = "C:\\Program Files\\JCreatorV3\\MyProjects\\VisRD\\FastA\\algae.fsa";
	
	public static void main(String[] args){
		loadFile(new File(TEST_FILE));
	}
	
	public static void loadFile(File f){
		Taxon[] taxon = null;

		try{
			BufferedReader br = new BufferedReader(new FileReader(f));
			String fileLine = br.readLine();
			
			ArrayList<Taxon> taxa = new ArrayList<Taxon>();
			StringBuffer currentCharData = new StringBuffer();
			StringBuffer allCharData = new StringBuffer();
			
			Taxon currentTaxon=null;
			
			while(fileLine!=null){
				if(fileLine.charAt(0)=='>'){
					// Set the char data for the previous taxa
					if(currentCharData.length()!=0){
						currentTaxon.setCharacterMatrix(currentCharData.toString().toLowerCase());
						currentCharData = new StringBuffer();
					}

					// This is the header
					String[] data = fileLine.split(" ");
					
					String taxaName = data[0].substring(1,data[0].length());
					currentTaxon = new Taxon(taxaName);
					taxa.add(currentTaxon);
				}
				else{
					// Append this data	
					currentCharData.append(fileLine);
					allCharData.append(fileLine);			
				}
				
				currentTaxon.setCharacterMatrix(currentCharData.toString().toLowerCase());
				fileLine = br.readLine();
			}
			
			System.out.println("Fasta: Is DNA/RNA: " + Taxon.inferIsDNAorRNA(allCharData.toString().toLowerCase()));
		
			taxon = new Taxon[taxa.size()];
		
		//	System.out.println("These are the taxa:");
			for(int i=0;i<taxa.size();i++){
			//	System.out.println(taxa.get(i));
				taxon[i] = taxa.get(i);
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
		VisRD.setTaxon(taxon);
	}
}
