/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

abstract class Terrain {
    static final int FLAT_TERRAIN = 0;
    static final int RANDOM_TERRAIN = 1;
    static final int STAIR_TERRAIN = 2;
    static final int NUM_TERRAIN_TYPES = 3;
    int terrainType = 0;
    double semiDiameter = 200.0;
    double initialX = 0.0;
    double initialZ = 0.0;
    Image currentImage = null;
    boolean imageIsValid = false;

    abstract double HeightAt(double var1, double var3);

    double HeightAboveGround(Coord3 c) {
        return c.xyz[1] - this.HeightAt(c.xyz[0], c.xyz[2]);
    }

    abstract void DrawNewSelf(Graphics var1, Projection var2);

    void DrawSelf(Graphics g, Projection p) {
        if (!this.imageIsValid && this.currentImage != null) {
            Graphics tg = this.currentImage.getGraphics();
            tg.setColor(Color.lightGray);
            int w = this.currentImage.getWidth(null);
            int h = this.currentImage.getHeight(null);
            if (w == -1) {
                SendMessage.Tell("Image buffer in strange state, abandoning terrain drawing.\n");
                return;
            }
            tg.fillRect(0, 0, w, h);
            tg.translate(w / 2, h / 2);
            this.DrawNewSelf(tg, p);
            tg.dispose();
            this.imageIsValid = true;
        }
        if (this.currentImage == null) {
            SendMessage.Tell("No image buffer, drawing terrain directly.\n");
            this.DrawNewSelf(g, p);
        } else {
            g.drawImage(this.currentImage, -this.currentImage.getWidth(null) / 2, -this.currentImage.getHeight(null) / 2, null);
        }
    }

    Terrain() {
    }
}

