/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class Staircase
extends Terrain {
    double stairWidth;
    double stepHeight;
    double stepLength;
    int numSteps;
    double landingLength;
    double xcentre = 0.0;
    double zcentre = 0.0;
    double xrearstepshi;
    double xrearstepslo;
    double xfrontstepshi;
    double xfrontstepslo;
    double zlo;
    double zhi;

    Staircase() {
        this.initStaircase(150.0, 10.0, 20.0, 3, 200.0, 0.0, 0.0);
    }

    Staircase(double sW, double sH, double sL, int nS, double lL, double xC, double zC) {
        this.initStaircase(sW, sH, sL, nS, lL, xC, zC);
    }

    void initStaircase(double sW, double sH, double sL, int nS, double lL, double xC, double zC) {
        this.terrainType = 2;
        this.semiDiameter = 800.0;
        this.stairWidth = sW;
        this.stepHeight = sH;
        this.stepLength = sL;
        this.numSteps = nS;
        this.landingLength = lL;
        this.xcentre = xC;
        this.zcentre = zC;
        this.xrearstepshi = this.xcentre - this.landingLength / 2.0;
        this.xrearstepslo = this.xrearstepshi - this.stepLength * (double)(this.numSteps - 1);
        this.xfrontstepshi = this.xcentre + this.landingLength / 2.0;
        this.xfrontstepslo = this.xfrontstepshi + this.stepLength * (double)(this.numSteps - 1);
        this.zlo = this.zcentre - this.stairWidth / 2.0;
        this.zhi = this.zcentre + this.stairWidth / 2.0;
        this.initialX = this.xrearstepslo - 150.0;
        this.initialZ = 0.0;
    }

    double HeightAt(double x, double z) {
        if (z < this.zlo) {
            return 0.0;
        }
        if (z > this.zhi) {
            return 0.0;
        }
        if (x > this.xfrontstepslo) {
            return 0.0;
        }
        if (x < this.xrearstepslo) {
            return 0.0;
        }
        if (x < this.xrearstepshi) {
            int s = (int)((x - this.xrearstepslo) / this.stepLength) + 1;
            if (s < 1) {
                s = 1;
            } else if (s >= this.numSteps) {
                s = this.numSteps - 1;
            }
            return (double)s * this.stepHeight;
        }
        if (x > this.xfrontstepshi) {
            int s = (int)((this.xfrontstepslo - x) / this.stepLength) + 1;
            if (s < 1) {
                s = 1;
            } else if (s >= this.numSteps) {
                s = this.numSteps - 1;
            }
            return (double)s * this.stepHeight;
        }
        return this.stepHeight * (double)this.numSteps;
    }

    void DrawNewSelf(Graphics g, Projection p) {
        g.setColor(Color.yellow);
        double landingHeight = this.stepHeight * (double)this.numSteps;
        p.DrawLine(g, new Coord3(this.xrearstepshi, landingHeight, this.zlo), new Coord3(this.xfrontstepshi, landingHeight, this.zlo));
        p.DrawLine(g, new Coord3(this.xrearstepshi, landingHeight, this.zhi), new Coord3(this.xfrontstepshi, landingHeight, this.zhi));
        double y0 = 0.0;
        double xlo = this.xrearstepslo;
        double xhi = this.xfrontstepslo;
        int i = 0;
        while (i < this.numSteps) {
            double y1 = y0 + this.stepHeight;
            p.DrawLine(g, new Coord3(xlo, y0, this.zlo), new Coord3(xlo, y1, this.zlo));
            p.DrawLine(g, new Coord3(xhi, y0, this.zlo), new Coord3(xhi, y1, this.zlo));
            p.DrawLine(g, new Coord3(xlo, y0, this.zhi), new Coord3(xlo, y1, this.zhi));
            p.DrawLine(g, new Coord3(xhi, y0, this.zhi), new Coord3(xhi, y1, this.zhi));
            p.DrawLine(g, new Coord3(xlo, y0, this.zlo), new Coord3(xlo, y0, this.zhi));
            p.DrawLine(g, new Coord3(xlo, y1, this.zlo), new Coord3(xlo, y1, this.zhi));
            p.DrawLine(g, new Coord3(xhi, y0, this.zlo), new Coord3(xhi, y0, this.zhi));
            p.DrawLine(g, new Coord3(xhi, y1, this.zlo), new Coord3(xhi, y1, this.zhi));
            y0 = y1;
            xlo += this.stepLength;
            xhi -= this.stepLength;
            ++i;
        }
        double y02 = 0.0;
        double xlo0 = this.xrearstepslo;
        double xlo1 = xlo0 + this.stepLength;
        double xhi0 = this.xfrontstepslo;
        double xhi1 = xhi0 - this.stepLength;
        int i2 = 1;
        while (i2 < this.numSteps) {
            p.DrawLine(g, new Coord3(xlo0, y02 += this.stepHeight, this.zlo), new Coord3(xlo1, y02, this.zlo));
            p.DrawLine(g, new Coord3(xhi0, y02, this.zlo), new Coord3(xhi1, y02, this.zlo));
            p.DrawLine(g, new Coord3(xlo0, y02, this.zhi), new Coord3(xlo1, y02, this.zhi));
            p.DrawLine(g, new Coord3(xhi0, y02, this.zhi), new Coord3(xhi1, y02, this.zhi));
            xlo0 = xlo1;
            xlo1 += this.stepLength;
            xhi0 = xhi1;
            xhi1 -= this.stepLength;
            ++i2;
        }
        p.DrawLine(g, new Coord3(this.xrearstepslo, 0.0, this.zlo), new Coord3(-this.semiDiameter, 0.0, this.zlo));
        p.DrawLine(g, new Coord3(this.xfrontstepslo, 0.0, this.zlo), new Coord3(this.semiDiameter, 0.0, this.zlo));
        p.DrawLine(g, new Coord3(this.xrearstepslo, 0.0, this.zhi), new Coord3(-this.semiDiameter, 0.0, this.zhi));
        p.DrawLine(g, new Coord3(this.xfrontstepslo, 0.0, this.zhi), new Coord3(this.semiDiameter, 0.0, this.zhi));
    }
}

