/*
 * Decompiled with CFR 0.152.
 */
class Quaternion {
    Coord3 qaxis;
    double phase;

    Quaternion(double x, double y, double z, double w) {
        this.qaxis = new Coord3(x, y, z);
        this.phase = w;
    }

    Quaternion() {
        this.qaxis = new Coord3();
        this.phase = 1.0;
    }

    Quaternion(Coord3 a, double p) {
        this.qaxis = a;
        this.phase = p;
    }

    Quaternion(Coord3Rotation c) {
        double angle = c.RotAngle() * 0.5;
        this.qaxis = c.RotAxis().scaleCoord3(Math.sin(angle));
        this.phase = Math.cos(angle);
    }

    Quaternion(HPRRotation hpr) {
        double h = -hpr.heading / 2.0;
        double p = hpr.pitch / 2.0;
        double r = hpr.roll / 2.0;
        Quaternion result = new Quaternion(0.0, Math.sin(h), 0.0, Math.cos(h)).composeRotation(new Quaternion(0.0, 0.0, Math.sin(p), Math.cos(p))).composeRotation(new Quaternion(Math.sin(r), 0.0, 0.0, Math.cos(r)));
        this.qaxis = result.qaxis;
        this.phase = result.phase;
    }

    Quaternion(VRMLRotation v) {
        double angle = v.angle * 0.5;
        this.qaxis = v.axis.scaleCoord3(Math.sin(angle));
        this.phase = Math.cos(angle);
    }

    String makeString() {
        return String.valueOf(this.qaxis.makeString()) + "[" + JRKUtils.DoubleToString(this.phase, 3) + "]";
    }

    double SinPhase() {
        return this.qaxis.length();
    }

    Coord3 RotAxis() {
        if (this.phase == 1.0) {
            return new Coord3(0.0, 0.0, 1.0);
        }
        return this.qaxis.unitVector();
    }

    double RotAngle() {
        return Math.atan2(this.SinPhase(), this.phase) * 2.0;
    }

    Coord3 applyRotation(Coord3 s) {
        Quaternion sq = new Quaternion(s, 0.0);
        Quaternion result = this.composeRotation(sq.composeRotation(this.inverseRotation()));
        return result.qaxis;
    }

    Quaternion composeRotation(Quaternion q) {
        return new Quaternion(this.phase * q.qaxis.xyz[0] + this.qaxis.xyz[0] * q.phase + this.qaxis.xyz[1] * q.qaxis.xyz[2] - this.qaxis.xyz[2] * q.qaxis.xyz[1], this.phase * q.qaxis.xyz[1] + this.qaxis.xyz[1] * q.phase + this.qaxis.xyz[2] * q.qaxis.xyz[0] - this.qaxis.xyz[0] * q.qaxis.xyz[2], this.phase * q.qaxis.xyz[2] + this.qaxis.xyz[2] * q.phase + this.qaxis.xyz[0] * q.qaxis.xyz[1] - this.qaxis.xyz[1] * q.qaxis.xyz[0], this.phase * q.phase - this.qaxis.xyz[0] * q.qaxis.xyz[0] - this.qaxis.xyz[1] * q.qaxis.xyz[1] - this.qaxis.xyz[2] * q.qaxis.xyz[2]);
    }

    Quaternion inverseRotation() {
        return new Quaternion(this.qaxis.scaleCoord3(-1.0), this.phase);
    }
}

