/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class Projection {
    Coord3 v;
    Coord3 i;
    Coord3 j;
    static final double VERYBIG = 1.0;
    double vv;
    double scale;

    Projection(Coord3 v0, double s) {
        this.initialise(v0, s);
    }

    Projection() {
        this.initialise(new Coord3(10.0, 10.0, 10.0), 40.0);
    }

    boolean Equals(Projection p) {
        return p != null && this.v.Equals(p.v) && this.scale == p.scale;
    }

    void initialise(Coord3 v0, double s) {
        this.v = v0;
        this.i = new Coord3(v0.xyz[2], 0.0, -v0.xyz[0]).unitVector();
        this.j = this.i.crossProduct(v0).unitVector();
        this.vv = v0.dotProduct(v0);
        this.scale = s;
    }

    public boolean Project(Coord3 x, Coord2 result) {
        double xv = x.dotProduct(this.v);
        double xi = x.dotProduct(this.i);
        double xj = x.dotProduct(this.j);
        Coord2 localResult = new Coord2(xi, xj);
        localResult = localResult.scaleCoord2(this.vv != xv ? this.vv / (this.vv - xv) : 1.0);
        result.x = localResult.x;
        result.y = localResult.y;
        return this.vv >= xv;
    }

    public void DrawLine(Graphics g, Coord3 fromPoint, Coord3 toPoint) {
        Coord2 from2 = new Coord2();
        Coord2 to2 = new Coord2();
        boolean fromOk = this.Project(fromPoint, from2);
        boolean toOk = this.Project(toPoint, to2);
        from2 = from2.scaleCoord2(this.scale);
        to2 = to2.scaleCoord2(this.scale);
        if (fromOk) {
            if (toOk) {
                Coord2.DrawLine(g, from2, to2);
            } else {
                Coord2.DrawLine(g, from2, this.Opposite(from2, to2));
            }
        } else if (toOk) {
            Coord2.DrawLine(g, this.Opposite(to2, from2), to2);
        }
    }

    public Coord2 Opposite(Coord2 fromPoint, Coord2 toPoint) {
        return fromPoint.addCoord2(fromPoint.subtractCoord2(toPoint).scaleCoord2(1.0));
    }

    public void DrawBlob(Graphics g, Coord3 atPoint, double diameter) {
        double xv = atPoint.dotProduct(this.v);
        if (this.vv <= xv) {
            return;
        }
        double a = this.vv / (this.vv - xv);
        Coord2 centre2d = new Coord2(atPoint.dotProduct(this.i), atPoint.dotProduct(this.j)).scaleCoord2(a);
        double diameter2d = diameter * a;
        g.fillOval((int)(this.scale * (centre2d.x - diameter2d / 2.0)), (int)(this.scale * (centre2d.y - diameter2d / 2.0)), (int)(this.scale * diameter2d), (int)(this.scale * diameter2d));
    }

    public void DrawEllipsoid(Graphics g, Coord3 size, Coord3 translation, Rotation orientation, Color front, Color sides, Color back) {
        double a = size.xyz[0];
        double b = size.xyz[1];
        double c = size.xyz[2];
        g.setColor(sides);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        g.setColor(front);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        g.setColor(back);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
    }
}

