/*
 * Decompiled with CFR 0.152.
 */
class PIDController
extends Controller {
    static final int NUM_CONTROL_PARAMS = 4;
    static final double MAXABSOUTPUT = 1000.0;
    static final int PROP_FACTOR = 0;
    static final int DIFF_FACTOR = 1;
    static final int INTEG_FACTOR = 2;
    static final int LEAK_FACTOR = 3;
    double minOutput = -1000.0;
    double maxOutput = 1000.0;
    double[] controlParams = new double[4];

    PIDController() {
        this.initPIDController(50.0, 10.0, 0.0, 0.5);
    }

    PIDController(double k0, double k1, double k2, double leak) {
        this.initPIDController(k0, k1, k2, leak);
    }

    void initPIDController(double k0, double k1, double k2, double leak) {
        this.controlParams[0] = k0;
        this.controlParams[1] = k1;
        this.controlParams[2] = k2;
        this.controlParams[3] = leak;
    }

    void outputFunction() {
        if (this.time > this.previousTime) {
            if (this.enabled) {
                double deltaTime = this.time - this.previousTime;
                double err = this.error();
                this.accumulatedError = this.previousAccumulatedError * Math.exp(-this.controlParams[3] * deltaTime) + err * deltaTime;
                double diffPart = this.controlParams[1] * (err - this.previousError) / deltaTime;
                this.output = -this.controlParams[0] * err - diffPart - this.controlParams[2] * this.accumulatedError;
                this.output = JRKUtils.TrimDouble(this.minOutput, this.output, this.maxOutput);
            } else {
                this.output = 0.0;
            }
        }
    }
}

