/*
 * Decompiled with CFR 0.152.
 */
class HPRRotation {
    double heading;
    double pitch;
    double roll;

    HPRRotation(double h, double p, double r) {
        this.heading = h;
        this.pitch = p;
        this.roll = r;
    }

    HPRRotation() {
        this.heading = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
    }

    HPRRotation(RotMatrix m) {
        double x11 = m.cols[1].xyz[1];
        double x12 = m.cols[2].xyz[1];
        double cp = Math.sqrt(x12 * x12 + x11 * x11);
        double x10 = m.cols[0].xyz[1];
        if (cp == 0.0) {
            this.heading = 0.0;
            double x21 = m.cols[1].xyz[2];
            double x22 = m.cols[2].xyz[2];
            this.roll = Math.atan2(x21, x22);
            this.pitch = x10 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            double x00 = m.cols[0].xyz[0];
            double x20 = m.cols[0].xyz[2];
            this.roll = -Math.atan2(x12, x11);
            this.pitch = Math.asin(x10);
            this.heading = Math.atan2(x20, x00);
        }
    }

    HPRRotation(Quaternion q) {
        HPRRotation hpr = HPRRotation.RMtoHPR(new RotMatrix(q));
        this.heading = hpr.heading;
        this.pitch = hpr.pitch;
        this.roll = hpr.roll;
    }

    private static HPRRotation RMtoHPR(RotMatrix m) {
        return new HPRRotation(m);
    }

    String makeString() {
        return "( H " + JRKUtils.DoubleToString(this.heading, 3) + " P " + JRKUtils.DoubleToString(this.pitch, 3) + " R " + JRKUtils.DoubleToString(this.roll, 3) + " )";
    }
}

