/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class ElevationGrid
extends Terrain {
    int numSegments = 20;
    double diameter = this.semiDiameter + this.semiDiameter;
    double[][] elevationValues;

    ElevationGrid() {
        this.initElevationGrid(20, 200.0, 20.0, 1);
    }

    ElevationGrid(int nS, double sD, double maxHeight, int smoothness) {
        this.initElevationGrid(nS, sD, maxHeight, smoothness);
    }

    void initElevationGrid(int nS, double sD, double maxHeight, int smoothness) {
        this.terrainType = 1;
        this.numSegments = nS;
        this.semiDiameter = sD;
        this.diameter = this.semiDiameter + this.semiDiameter;
        this.elevationValues = new double[nS][nS];
        int i = 0;
        while (i < nS) {
            double[] eVs = this.elevationValues[i];
            int j = 0;
            while (j < nS) {
                eVs[j] = (Math.random() - 0.5) * maxHeight;
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < smoothness) {
            int i2 = 0;
            while (i2 < nS) {
                double[] eVsa = this.elevationValues[(nS + i2 - 1) % nS];
                double[] eVsb = this.elevationValues[i2];
                double[] eVsc = this.elevationValues[(i2 + 1) % nS];
                int j = 0;
                while (j < nS) {
                    eVsb[j] = (eVsa[j] + eVsb[(nS + j - 1) % nS] + eVsb[j] + eVsb[(j + 1) % nS] + eVsc[j]) / 5.0;
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
    }

    double HeightAt(double x, double z) {
        int ix = JRKUtils.ScaleDoubleToInt(x, -this.semiDiameter, this.semiDiameter, this.numSegments);
        double xi = JRKUtils.ScaleIntToDouble(ix, this.numSegments, -this.semiDiameter, this.semiDiameter);
        int iz = JRKUtils.ScaleDoubleToInt(z, -this.semiDiameter, this.semiDiameter, this.numSegments);
        double zi = JRKUtils.ScaleIntToDouble(iz, this.numSegments, -this.semiDiameter, this.semiDiameter);
        ix = (ix + this.numSegments / 2) % this.numSegments;
        iz = (iz + this.numSegments / 2) % this.numSegments;
        int ix1 = (ix + 1) % this.numSegments;
        int iz1 = (iz + 1) % this.numSegments;
        double x0z0 = this.elevationValues[ix][iz];
        double x0z1 = this.elevationValues[ix][iz1];
        double x1z0 = this.elevationValues[ix1][iz];
        double x1z1 = this.elevationValues[ix1][iz1];
        double dx = (x - xi) * (double)this.numSegments / this.diameter;
        double dz = (z - zi) * (double)this.numSegments / this.diameter;
        if (dx < -1.0E-4 || dx > 1.001 || dz < -1.0E-4 || dz > 1.001) {
            return 0.0;
        }
        double result = (x0z0 * (1.0 - dx) + x1z0 * dx) * (1.0 - dz) + (x0z0 * (1.0 - dx) + x1z0 * dx) * dz;
        return result;
    }

    Coord3 LocationAt(int ix, int iz) {
        double height = this.elevationValues[(this.numSegments + ix) % this.numSegments][(this.numSegments + iz) % this.numSegments];
        double x = (double)ix * this.diameter / (double)this.numSegments;
        double z = (double)iz * this.diameter / (double)this.numSegments;
        return new Coord3(x, height, z);
    }

    void DrawNewSelf(Graphics g, Projection p) {
        g.setColor(Color.yellow);
        int lo = -this.numSegments / 2;
        int hi = this.numSegments / 2;
        int i = lo;
        while (i <= hi) {
            int j = lo;
            while (j < hi) {
                p.DrawLine(g, this.LocationAt(i, j), this.LocationAt(i, j + 1));
                ++j;
            }
            ++i;
        }
        int i2 = lo;
        while (i2 < hi) {
            int j = lo;
            while (j <= hi) {
                p.DrawLine(g, this.LocationAt(i2, j), this.LocationAt(i2 + 1, j));
                ++j;
            }
            ++i2;
        }
    }
}

