/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

class BugCanvas
extends Canvas {
    Bug theBug;
    Projection projection;
    Image offScreen;
    Image terrainImage = null;
    int halfWidth = 0;
    int halfHeight = 0;

    BugCanvas(Bug b, Projection p) {
        this.theBug = b;
        this.projection = p;
    }

    public void drawAgain() {
        Graphics g = this.getGraphics();
        this.paint(g);
        g.dispose();
    }

    public void MakeBuffer() {
        Dimension d = this.getSize();
        this.halfWidth = d.width / 2;
        this.halfHeight = d.height / 2;
        this.terrainImage = this.createImage(d.width, d.height);
        this.offScreen = this.createImage(d.width, d.height);
        this.theBug.terrain.currentImage = this.terrainImage;
    }

    public void UnbufferedPaint(Graphics g) {
        if (this.halfWidth == 0) {
            Dimension d = this.getSize();
            this.halfWidth = d.width / 2;
            this.halfHeight = d.height / 2;
        }
        g.translate(this.halfWidth, this.halfHeight);
        this.theBug.DrawSelf(g, this.projection);
    }

    public void BufferedPaint(Graphics g) {
        Graphics offg = this.offScreen.getGraphics();
        offg.setColor(Color.lightGray);
        offg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        offg.translate(this.halfWidth, this.halfHeight);
        this.theBug.DrawSelf(offg, this.projection);
        offg.dispose();
        g.drawImage(this.offScreen, 0, 0, this);
    }

    public void paint(Graphics g) {
        if (this.offScreen == null) {
            this.MakeBuffer();
        }
        if (this.offScreen == null) {
            this.UnbufferedPaint(g);
        } else {
            this.BufferedPaint(g);
        }
    }
}

