/*
 * Decompiled with CFR 0.152.
 */
class Program {
    Bug theBug;
    int programID = 0;
    int numSteps = 0;
    double timeStep;
    boolean running = false;
    int[] numActions;
    int[][] withArm;
    int[][] doAction;
    double amplitude;
    double nextTime;
    int curStep = 0;

    Program(Bug tB, double tS, double time, double amp, int cannedProgram) {
        this.programID = cannedProgram;
        this.initProgram(tB, tS, time, amp, 0, null, null, null);
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 1;
        int[] aa = nArray;
        int aan = 4;
        int[] bb = new int[]{4, 4};
        int bbn = 2;
        switch (cannedProgram) {
            case 2: 
            case 3: {
                if (cannedProgram != 3) break;
                this.amplitude = -amp;
                break;
            }
            case 4: 
            case 5: {
                if (cannedProgram == 5) {
                    this.amplitude = -amp;
                }
                aa[3] = 3;
                break;
            }
        }
        this.numSteps = Bug.numArms;
        this.withArm = new int[this.numSteps][];
        this.doAction = new int[this.numSteps][];
        this.numActions = new int[this.numSteps];
        int s = 0;
        int i = 0;
        while (i < Bug.numArms / 2) {
            int firstArm = i;
            int secondArm = Bug.numArms - i - 1;
            int[] xx = new int[]{firstArm, secondArm, firstArm, secondArm};
            int[] yy = new int[]{firstArm, secondArm};
            this.withArm[s] = xx;
            this.doAction[s] = aa;
            this.numActions[s] = aan;
            this.withArm[++s] = yy;
            this.doAction[s] = bb;
            this.numActions[s] = bbn;
            ++s;
            ++i;
        }
    }

    Program(Bug tB, double tS, double time, double amp, int nS, int[] nA, int[][] wA, int[][] dA) {
        this.initProgram(tB, tS, time, amp, nS, nA, wA, dA);
    }

    void initProgram(Bug tB, double tS, double time, double amp, int nS, int[] nA, int[][] wA, int[][] dA) {
        this.theBug = tB;
        this.numSteps = nS;
        this.timeStep = tS;
        this.numActions = nA;
        this.withArm = wA;
        this.doAction = dA;
        this.amplitude = amp;
        this.nextTime = time + this.timeStep;
        this.curStep = 0;
        this.running = false;
    }

    boolean doNextStep() {
        if (!this.running) {
            return true;
        }
        int[] curArm = this.withArm[this.curStep];
        int[] curAction = this.doAction[this.curStep];
        int numActs = this.numActions[this.curStep];
        boolean ok = true;
        int i = 0;
        while (i < numActs) {
            boolean stillOk = this.theBug.WalkLeg(curArm[i], curAction[i], this.amplitude);
            ok = ok && stillOk;
            ++i;
        }
        if (ok) {
            this.curStep = (this.curStep + 1) % this.numSteps;
        }
        return ok;
    }

    void acceptTime() {
        if (!this.running) {
            return;
        }
        if (Bug.globalTime < this.nextTime) {
            return;
        }
        this.doNextStep();
        this.nextTime += this.timeStep;
    }

    void startProgram() {
        this.curStep = 0;
        this.nextTime = Bug.globalTime + this.timeStep;
        this.running = true;
    }

    void stopProgram() {
        this.running = false;
    }
}

