/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class BugApplet
extends Applet
implements ActionListener,
ItemListener,
AdjustmentListener {
    static final TextArea messageArea = new TextArea("BugApplet version 1.2, 98Nov08 11:00 BST.\nWritten by Richard Kennaway, jrk@sys.uea.ac.uk.\n\n", 15, 40);
    static final int TOP_INDEX = 0;
    static final int SHP_INDEX = 1;
    static final int ELB_INDEX = 2;
    static final int SHY_INDEX = 3;
    static final int LIN_INDEX = 4;
    static final int PER_INDEX = 5;
    static final int REF_INDEX = 6;
    static final int ERR_INDEX = 7;
    static final int OUT_INDEX = 8;
    static final int TOPPAR_INDEX = 9;
    static final int PAR_INDEX = 10;
    static final int SWITCH_INDEX = 11;
    static final int FEET_INDEX = 12;
    static final int FEET_PARAM_INDEX = 13;
    static final int WALK_INDEX = 14;
    static final int TERRAIN_INDEX = 15;
    static final int BLANK_INDEX = 16;
    static final int NUM_PANELS = 17;
    int currentCard = -1;
    static final int[] PANEL_CONNECTIONS;
    int validPanels = 0;
    static int MAX_BODYDF_ARMS;
    static int DELTA_BODYDF_ARMS;
    static final String[] panelNames;
    static final int NUM_COLUMNS = 5;
    static final String[] cardColumnNames;
    static final String[] upperNames;
    static final String[] jointNames;
    static final String[] dfNames;
    static final String[] panelIndexString;
    static Label timeLabel;
    static Label errorLabel;
    static final int NUM_DISPLAYS = 3;
    static final int ANIMATION_DISPLAY = 0;
    static final int OSCILLOSCOPE_DISPLAY = 1;
    static final int NO_DISPLAY = 2;
    static int DisplayMode;
    static final String[] displayIndexString;
    Panel displayPanel = new Panel();
    CardLayout displayPanelLayout = new CardLayout();
    CheckboxGroup displaySelectorGroup = new CheckboxGroup();
    Checkbox[] displaySelectorBoxes = new Checkbox[3];
    static int AnimationInterval;
    static int TicksSinceDrawn;
    static double totalError;
    CheckboxGroup terrainGroup = new CheckboxGroup();
    Checkbox[] terrainCheckboxes = new Checkbox[3];
    static Label frameRateLabel;
    static Label[] perception2Label;
    static Label[] reference2Label;
    static Scrollbar[] reference2Scroll;
    static Panel[] reference2Panel;
    static Label[] error2Label;
    static Label[] output2Label;
    static Checkbox[] enabled2Checkbox;
    static Label[][] perception1Label;
    static Label[][] reference1Label;
    static Scrollbar[][] reference1Scroll;
    static Panel[][] reference1Panel;
    static Label[][] error1Label;
    static Label[][] output1Label;
    static Checkbox[][] enabled1Checkbox;
    static Label[][] footPerceptionLabel;
    static Label[][] footOutputLabel;
    static Checkbox[][] footEnabledCheckbox;
    static final int[] reference2imax;
    static final double[] reference2dmin;
    static final double[] reference2dmax;
    static final int[] reference1imax;
    static final double[] reference1dmin;
    static final double[] reference1dmax;
    static Label[][] linkageLabel;
    static Checkbox[] armAliveCheckbox;
    static Checkbox[] armGroundedCheckbox;
    static final int NUM_PARAMETERS = 19;
    static final int PROP_PARAM = 0;
    static final int DIFF_PARAM = 1;
    static final int INT_PARAM = 2;
    static final int LEAK_PARAM = 3;
    static final int MASS_PARAM = 4;
    static final int DIST_PARAM = 5;
    static final int ANGDIST_PARAM = 6;
    static final int DISTLEAK_PARAM = 7;
    static final int ANIM_DELTA_PARAM = 8;
    static final int ANIM_REDRAW_PARAM = 9;
    static final int CORR_PARAM = 10;
    static final int POKE_FORCE_PARAM = 11;
    static final int POKE_TORQUE_PARAM = 12;
    static final int POKE_PERIOD_PARAM = 13;
    static final int POKE_INT_PARAM = 14;
    static final int POKE_POINT_PARAM = 15;
    static final int WALK_TIME_PARAM = 16;
    static final int GOAL_X_PARAM = 17;
    static final int GOAL_Z_PARAM = 18;
    double[] parameterdmin;
    double[] parameterdmax;
    int[] parameterimax;
    String[] parameterStrings;
    Label[] parameterName;
    Label[] parameterLabel;
    Scrollbar[] parameterScroll;
    Checkbox forceCheckbox;
    Panel[][] upperParamPanel;
    String[] controlParamNames;
    Label[][] controlParamLabel;
    Scrollbar[][] controlParamScroll;
    double[] controlParamdmin;
    double[] controlParamdmax;
    int[] controlParamimax;
    Panel[][] footParamPanel;
    Label[][] footControlParamLabel;
    Scrollbar[][] footControlParamScroll;
    double[] footControlParamdmin;
    double[] footControlParamdmax;
    int[] footControlParamimax;
    String[] walkActionNames;
    String[] walkProgramNames;
    Button[][] walkButton;
    Button[] walkProgramButton;
    Bug theBug;
    static final double initViewDistance = 300.0;
    static final double minViewDistance = 60.0;
    static final double maxViewDistance = 1500.0;
    static double viewDistance;
    static final double INITPROJECTIONSCALE = 1.0;
    Projection projection;
    BugCanvas bugCanvas;
    OscilloscopeCanvas oscilloscopeCanvas;
    static final int NUM_POKE_BUTTONS = 6;
    static final int HT_BUTTON = 0;
    static final int FWD_BUTTON = 1;
    static final int RT_BUTTON = 2;
    static final int HDG_BUTTON = 3;
    static final int PCH_BUTTON = 4;
    static final int RL_BUTTON = 5;
    String[] pokeButtonNames;
    Button[] pokeButtons;
    Button runButton;
    Button stepButton;
    Button corrButton;
    Button initGeomButton;
    Button initViewButton;
    Button clearMessagesButton;
    Scrollbar headingScroll;
    Scrollbar pitchScroll;
    Scrollbar zoomScroll;
    Panel cardsPanel;
    CardLayout cardsPanelLayout;
    CheckboxGroup cardSelectorGroup;
    static final int NUM_CARDS = 16;
    Checkbox[] cardSelectorBoxes;
    Panel[] cardsPanels;
    static final double MAXHEIGHT = 100.0;
    static final double MAXNETFORCE = 10.0;
    static final double MAXTORQUE = 10.0;
    static final int SCROLLMAXTORQUE = 1000;
    static final int INITHEADING = 45;
    static final int INITPITCH = -30;
    static final int INITZOOM = 16;
    static final String setAString = "Show angles";
    static final String setARefString = "Show angle ref. values";
    static boolean allowDebugMessages;
    static boolean allowAnimation;
    static double delta_t;
    long lastTime;
    int NUMTIMES;
    int lastTimeIndex;
    double[] lastTimes;
    static boolean showForces;
    static AnimationThread animation;
    static boolean doPokeForce;
    static int pokeComponent;
    static double pokeTime;
    static double pokeStopTime;
    static double pokeInterval;
    static double pokePeriod;
    static double pokeForce;
    static double pokeTorque;
    static double pokePointiness;
    static double correlationInterval;
    static double correlationStart;
    static double correlationStop;
    double x_mean;
    double y_mean;
    double z_mean;
    double x_delta;
    double y_delta;
    double z_delta;
    double x_sq;
    double y_sq;
    double z_sq;
    double xy_moment;
    double xz_moment;
    int numCorrValues;
    static final int NUM_WALK_PROGRAMS = 6;
    static final int RESET_ARMS = 0;
    static final int STOP_WALKING = 1;
    static final int WALK_FORWARDS = 2;
    static final int WALK_BACKWARDS = 3;
    static final int TURN_RIGHT = 4;
    static final int TURN_LEFT = 5;
    int walkProgram;
    static double walkInterval;
    int lastWalkedLeg;
    double nextStepTime;

    public void init() {
        this.createLayout();
        this.InitFrameRate();
        this.initialiseBug();
    }

    public void stop() {
        this.StopAnimation();
    }

    public void initialiseBug() {
        timeLabel.setText("Time " + JRKUtils.DoubleToString(Bug.globalTime, 3));
        AnimationInterval = 0;
        this.walkProgram = 1;
        walkInterval = 0.1;
        this.lastWalkedLeg = 0;
        this.nextStepTime = 0.0;
        pokeStopTime = 0.0;
        if (correlationStop > 0.0) {
            this.StopCorrelations();
        }
        int i = 0;
        while (i < Bug.numArms) {
            Arm a = this.theBug.arms[i];
            a.aliveBox = armAliveCheckbox[i];
            a.groundBox = armGroundedCheckbox[i];
            a.aliveBox.setState(a.alive);
            a.groundBox.setState(a.groundContact);
            ++i;
        }
        this.SetReferencesFromCurrentPerceptions();
        this.theBug.UpdateControl();
        this.RestoreControlValues(true);
        this.RestoreCheckboxes();
    }

    String ArmName(int i) {
        return i < Bug.numArms / 2 ? "Left " + i : "Right " + (Bug.numArms - 1 - i);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean result;
        boolean wasAnimating = this.SuspendAnimation();
        int operation = adjustmentEvent.getAdjustmentType();
        Scrollbar bar = (Scrollbar)adjustmentEvent.getSource();
        boolean bl = result = this.DOheadingPitchScroll(bar) ? true : this.DOcontrolScroll(bar);
        if (wasAnimating) {
            this.ResumeAnimation(wasAnimating);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean wasAnimating = this.SuspendAnimation();
        Button button = (Button)actionEvent.getSource();
        if (this.DOpokeButtons(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOrunButton(button)) {
            return;
        }
        if (this.DOstepButton(button)) {
            return;
        }
        if (this.DOcorrButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOinitGeomButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOinitViewButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOclearMessagesButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOwalkButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOwalkProgramButton(button)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        this.ResumeAnimation(wasAnimating);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean wasAnimating = this.SuspendAnimation();
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (this.DOdisplaySelectorGroup(checkbox)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOcardSelectorGroup(checkbox)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOcontrolEnable(checkbox)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOforceCheckbox(checkbox)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        if (this.DOterrainGroup(checkbox)) {
            this.ResumeAnimation(wasAnimating);
            return;
        }
        this.ResumeAnimation(wasAnimating);
    }

    void RestoreCheckboxes() {
        Controller[] cs = this.theBug.bodyController;
        boolean allEnabled = true;
        int i = 0;
        while (i < 6) {
            boolean enabled = cs[i].enabled;
            enabled2Checkbox[i].setState(enabled);
            allEnabled &= enabled;
            ++i;
        }
        allEnabled = true;
        int i2 = 0;
        while (i2 < Bug.numArms) {
            cs = this.theBug.armJointVelController[i2];
            int j = 0;
            while (j < 3) {
                boolean enabled = cs[j].enabled;
                enabled1Checkbox[i2][j].setState(enabled);
                allEnabled &= enabled;
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < Bug.numArms) {
            armAliveCheckbox[i3].setState(this.theBug.arms[i3].alive);
            ++i3;
        }
        int i4 = 0;
        while (i4 < Bug.numArms) {
            armGroundedCheckbox[i4].setState(this.theBug.arms[i4].groundContact);
            ++i4;
        }
    }

    void UpdateReferencesFromUser() {
        boolean haveControl = false;
        int i = 0;
        while (i < 6) {
            double v = JRKUtils.ScaleIntToDouble(reference2Scroll[i].getValue(), reference2imax[i], reference2dmin[i], reference2dmax[i]);
            Controller c = this.theBug.bodyController[i];
            c.acceptReference(v);
            haveControl |= c.enabled;
            ++i;
        }
        if (haveControl) {
            int i2 = 0;
            while (i2 < Bug.numArms) {
                Controller[] cs = this.theBug.armJointVelController[i2];
                int j = 0;
                while (j < 3) {
                    double v = JRKUtils.ScaleIntToDouble(reference1Scroll[i2][j].getValue(), reference2imax[i2], reference2dmin[i2], reference2dmax[i2]);
                    cs[j].acceptReference(v);
                    ++j;
                }
                ++i2;
            }
        }
    }

    public void SetReferencesFromCurrentPerceptions() {
        Coord3 positionPerception = new Coord3();
        HPRRotation orientationPerception = new HPRRotation();
        this.theBug.PositionPerception(positionPerception, orientationPerception);
        Controller[] c = this.theBug.bodyController;
        c[0].acceptReference(positionPerception.xyz[1]);
        c[1].acceptReference(positionPerception.xyz[0]);
        c[2].acceptReference(positionPerception.xyz[2]);
        c[3].acceptReference(orientationPerception.heading);
        c[4].acceptReference(orientationPerception.pitch);
        c[5].acceptReference(orientationPerception.roll);
        Arm[] a = this.theBug.arms;
        int i = 0;
        while (i < Bug.numArms) {
            Controller[] cs = this.theBug.armJointVelController[i];
            int j = 0;
            while (j < 3) {
                cs[j].acceptReference(a[i].jointAngles[j]);
                ++j;
            }
            ++i;
        }
    }

    void createControls() {
        Button b;
        this.runButton = new Button("Run");
        this.runButton.addActionListener(this);
        this.stepButton = new Button("Step");
        this.stepButton.addActionListener(this);
        this.corrButton = new Button("Corr.");
        this.corrButton.addActionListener(this);
        this.initGeomButton = new Button("Reset bug");
        this.initGeomButton.addActionListener(this);
        this.initViewButton = new Button("Reset view");
        this.initViewButton.addActionListener(this);
        this.clearMessagesButton = new Button("Clear messages");
        this.clearMessagesButton.addActionListener(this);
        int i = 0;
        while (i < 6) {
            Button b2;
            this.pokeButtons[i] = b2 = new Button(this.pokeButtonNames[i]);
            b2.addActionListener(this);
            ++i;
        }
        this.walkButton = new Button[Bug.numArms / 2][9];
        int i2 = 0;
        while (i2 < Bug.numArms / 2) {
            int j = 0;
            while (j < 9) {
                this.walkButton[i2][j] = b = new Button(" ");
                b.addActionListener(this);
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 6) {
            this.walkProgramButton[i3] = b = new Button(this.walkProgramNames[i3]);
            b.addActionListener(this);
            ++i3;
        }
        this.terrainCheckboxes[0] = new Checkbox("Flat", this.terrainGroup, false);
        this.terrainCheckboxes[1] = new Checkbox("Random", this.terrainGroup, false);
        this.terrainCheckboxes[2] = new Checkbox("Staircase", this.terrainGroup, true);
        int i4 = 0;
        while (i4 < 3) {
            this.terrainCheckboxes[i4].addItemListener(this);
            ++i4;
        }
        frameRateLabel = new Label("0.0 fr/sec", 0);
        this.forceCheckbox = new Checkbox("Show forces", true);
        this.forceCheckbox.addItemListener(this);
        this.displaySelectorBoxes[0] = new Checkbox("Animation", this.displaySelectorGroup, true);
        this.displaySelectorBoxes[1] = new Checkbox("Oscilloscope", this.displaySelectorGroup, false);
        this.displaySelectorBoxes[2] = new Checkbox("No display", this.displaySelectorGroup, false);
        int i5 = 0;
        while (i5 < 3) {
            this.displaySelectorBoxes[i5].addItemListener(this);
            ++i5;
        }
        this.cardSelectorBoxes[0] = new Checkbox("Top level", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[1] = new Checkbox("Sh. pitch", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[2] = new Checkbox("Elbow", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[3] = new Checkbox("Sh. yaw", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[4] = new Checkbox("Linkage", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[5] = new Checkbox("Perceptions", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[6] = new Checkbox("References", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[7] = new Checkbox("Errors", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[8] = new Checkbox("Outputs", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[9] = new Checkbox("Top params.", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[10] = new Checkbox("Parameters", this.cardSelectorGroup, true);
        this.cardSelectorBoxes[11] = new Checkbox("Switches", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[12] = new Checkbox("Feet", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[13] = new Checkbox("Feet params.", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[14] = new Checkbox("Walk", this.cardSelectorGroup, false);
        this.cardSelectorBoxes[15] = new Checkbox("Terrain", this.cardSelectorGroup, false);
        int i6 = 0;
        while (i6 < 16) {
            this.cardSelectorBoxes[i6].addItemListener(this);
            ++i6;
        }
        this.headingScroll = new Scrollbar(0, 45, 1, -225, 135);
        this.headingScroll.addAdjustmentListener(this);
        this.headingScroll.setUnitIncrement(1);
        this.headingScroll.setBlockIncrement(10);
        this.pitchScroll = new Scrollbar(0, -30, 1, -90, 90);
        this.pitchScroll.addAdjustmentListener(this);
        this.pitchScroll.setUnitIncrement(1);
        this.pitchScroll.setBlockIncrement(10);
        this.zoomScroll = new Scrollbar(0, 16, 1, 0, 100);
        this.zoomScroll.addAdjustmentListener(this);
        this.zoomScroll.setUnitIncrement(1);
        this.zoomScroll.setBlockIncrement(10);
        int i7 = 0;
        while (i7 < 6) {
            BugApplet.perception2Label[i7] = new Label("000.0", 1);
            BugApplet.reference2Label[i7] = new Label("000.0", 2);
            BugApplet.reference2Scroll[i7] = new Scrollbar(0, JRKUtils.ScaleDoubleToInt(0.0, reference2dmin[i7], reference2dmax[i7], reference2imax[i7]), 10, 0, reference2imax[i7]);
            reference2Scroll[i7].addAdjustmentListener(this);
            BugApplet.error2Label[i7] = new Label("000.0", 1);
            BugApplet.output2Label[i7] = new Label("000.0", 1);
            BugApplet.enabled2Checkbox[i7] = new Checkbox("");
            enabled2Checkbox[i7].addItemListener(this);
            perception2Label[i7].setText("0.0");
            reference2Label[i7].setText("0.0");
            error2Label[i7].setText("0.0");
            output2Label[i7].setText("0.0");
            ++i7;
        }
        perception1Label = new Label[Bug.numArms][3];
        reference1Label = new Label[Bug.numArms][3];
        reference1Scroll = new Scrollbar[Bug.numArms][3];
        reference1Panel = new Panel[Bug.numArms][3];
        error1Label = new Label[Bug.numArms][3];
        output1Label = new Label[Bug.numArms][3];
        enabled1Checkbox = new Checkbox[Bug.numArms][3];
        int i8 = 0;
        while (i8 < Bug.numArms) {
            int j = 0;
            while (j < 3) {
                BugApplet.perception1Label[i8][j] = new Label("000.0", 1);
                BugApplet.reference1Label[i8][j] = new Label("000.0", 1);
                BugApplet.reference1Scroll[i8][j] = new Scrollbar(0, JRKUtils.ScaleDoubleToInt(0.0, reference1dmin[j], reference1dmax[j], reference1imax[j]), 10, 0, reference1imax[j]);
                reference1Scroll[i8][j].addAdjustmentListener(this);
                BugApplet.error1Label[i8][j] = new Label("000.0", 1);
                BugApplet.output1Label[i8][j] = new Label("000.0", 1);
                BugApplet.enabled1Checkbox[i8][j] = new Checkbox("");
                enabled1Checkbox[i8][j].addItemListener(this);
                perception1Label[i8][j].setText("0.0");
                reference1Label[i8][j].setText("0.0");
                error1Label[i8][j].setText("0.0");
                output1Label[i8][j].setText("0.0");
                ++j;
            }
            ++i8;
        }
        linkageLabel = new Label[Bug.numArms][6];
        int i9 = 0;
        while (i9 < Bug.numArms) {
            int j = 0;
            while (j < 6) {
                BugApplet.linkageLabel[i9][j] = new Label("(...)", 1);
                ++j;
            }
            ++i9;
        }
        int i10 = 0;
        while (i10 < 19) {
            this.parameterName[i10] = new Label(this.parameterStrings[i10], 0);
            this.parameterLabel[i10] = new Label("0.000", 2);
            this.parameterScroll[i10] = new Scrollbar(0, JRKUtils.ScaleDoubleToInt(0.0, this.parameterdmin[i10], this.parameterdmax[i10], this.parameterimax[i10]), 10, 0, this.parameterimax[i10]);
            this.parameterScroll[i10].addAdjustmentListener(this);
            ++i10;
        }
        armAliveCheckbox = new Checkbox[Bug.numArms];
        armGroundedCheckbox = new Checkbox[Bug.numArms];
        int i11 = 0;
        while (i11 < Bug.numArms) {
            BugApplet.armAliveCheckbox[i11] = new Checkbox("");
            armAliveCheckbox[i11].addItemListener(this);
            BugApplet.armGroundedCheckbox[i11] = new Checkbox("");
            armGroundedCheckbox[i11].addItemListener(this);
            ++i11;
        }
        footPerceptionLabel = new Label[Bug.numArms][2];
        footOutputLabel = new Label[Bug.numArms][2];
        footEnabledCheckbox = new Checkbox[Bug.numArms][2];
        int i12 = 0;
        while (i12 < Bug.numArms) {
            int j = 0;
            while (j < 2) {
                BugApplet.footPerceptionLabel[i12][j] = new Label("000.0", 1);
                BugApplet.footOutputLabel[i12][j] = new Label("000.0", 1);
                Checkbox cb = new Checkbox("");
                cb.setState(true);
                cb.addItemListener(this);
                BugApplet.footEnabledCheckbox[i12][j] = cb;
                ++j;
            }
            ++i12;
        }
        int i13 = 0;
        while (i13 < 6) {
            int j = 0;
            while (j < 4) {
                Label q;
                this.controlParamLabel[i13][j] = q = new Label("000.00");
                Scrollbar r = new Scrollbar(0, JRKUtils.ScaleDoubleToInt(0.0, this.controlParamdmin[j], this.controlParamdmax[j], this.controlParamimax[j]), 10, 0, this.controlParamimax[j]);
                r.addAdjustmentListener(this);
                this.controlParamScroll[i13][j] = r;
                ++j;
            }
            ++i13;
        }
        int i14 = 0;
        while (i14 < 2) {
            int j = 0;
            while (j < 4) {
                Label q = new Label("000.00");
                Scrollbar r = new Scrollbar(0, JRKUtils.ScaleDoubleToInt(0.0, this.footControlParamdmin[j], this.footControlParamdmax[j], this.footControlParamimax[j]), 10, 0, this.footControlParamimax[j]);
                r.addAdjustmentListener(this);
                this.footControlParamLabel[i14][j] = q;
                this.footControlParamScroll[i14][j] = r;
                ++j;
            }
            ++i14;
        }
    }

    void createLayout() {
        this.createControls();
        MAX_BODYDF_ARMS = Bug.numArms < 6 ? 6 : Bug.numArms;
        DELTA_BODYDF_ARMS = 6 - Bug.numArms;
        this.setLayout(new GridLayout(0, 1));
        Panel topPanel = new Panel();
        Panel rightPanel = new Panel();
        Panel bottomPanel = new Panel();
        this.add(topPanel);
        this.add(bottomPanel);
        topPanel.setLayout(new GridLayout(1, 0));
        topPanel.add(this.displayPanel);
        topPanel.add(rightPanel);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        rightPanel.setLayout(gridBag);
        Panel pokePanel = new Panel();
        this.AddToGrid(rightPanel, pokePanel, gridBag, c, 1, 1, 1, 1, 0, 1);
        this.AddToGrid(rightPanel, messageArea, gridBag, c, 2, 1, 1, 1, 1, 1);
        rightPanel.add(pokePanel);
        rightPanel.add(messageArea);
        pokePanel.setLayout(new GridLayout(0, 1));
        int i = 0;
        while (i < 6) {
            pokePanel.add(this.pokeButtons[i]);
            ++i;
        }
        gridBag = new GridBagLayout();
        c = new GridBagConstraints();
        c.fill = 1;
        bottomPanel.setLayout(gridBag);
        Panel buttonsPanel = new Panel();
        Panel bugViewPanel = new Panel();
        Panel selectorsPanel = new Panel();
        this.AddToGrid(bottomPanel, buttonsPanel, gridBag, c, 1, 1, 1, 1, 0, 1);
        this.AddToGrid(bottomPanel, bugViewPanel, gridBag, c, 2, 1, 1, 1, 0, 1);
        this.AddToGrid(bottomPanel, selectorsPanel, gridBag, c, 1, 2, 2, 1, 0, 1);
        this.AddToGrid(bottomPanel, this.cardsPanel, gridBag, c, 1, 3, 2, 1, 1, 1);
        gridBag = new GridBagLayout();
        c = new GridBagConstraints();
        c.fill = 1;
        buttonsPanel.setLayout(gridBag);
        Panel stopGoPanel = new Panel();
        Panel enablersPanel = new Panel();
        this.AddToGrid(buttonsPanel, stopGoPanel, gridBag, c, 1, 1, 1, 1, 0, 1);
        this.AddToGrid(buttonsPanel, enablersPanel, gridBag, c, 1, 2, 1, 1, 0, 1);
        stopGoPanel.setLayout(new GridLayout(0, 3, 2, 2));
        stopGoPanel.add(this.runButton);
        stopGoPanel.add(this.stepButton);
        stopGoPanel.add(this.corrButton);
        stopGoPanel.add(this.initGeomButton);
        stopGoPanel.add(this.initViewButton);
        stopGoPanel.add(this.clearMessagesButton);
        this.displayPanel.setLayout(this.displayPanelLayout);
        this.bugCanvas = new BugCanvas(this.theBug, this.projection);
        Panel emptyCanvas = new Panel();
        this.displayPanel.add(displayIndexString[0], this.bugCanvas);
        this.displayPanel.add(displayIndexString[1], this.oscilloscopeCanvas);
        this.displayPanel.add(displayIndexString[2], emptyCanvas);
        enablersPanel.setLayout(new GridLayout(0, 3));
        enablersPanel.add(timeLabel);
        enablersPanel.add(frameRateLabel);
        enablersPanel.add(this.forceCheckbox);
        enablersPanel.add(errorLabel);
        enablersPanel.add(this.displaySelectorBoxes[0]);
        enablersPanel.add(this.displaySelectorBoxes[1]);
        gridBag = new GridBagLayout();
        c = new GridBagConstraints();
        c.fill = 2;
        bugViewPanel.setLayout(gridBag);
        this.AddToGrid(bugViewPanel, new Label("Heading", 1), gridBag, c, 1, 1, 1, 1, 0, 0);
        this.AddToGrid(bugViewPanel, this.headingScroll, gridBag, c, 2, 1, 1, 1, 1, 0);
        this.AddToGrid(bugViewPanel, new Label("Pitch", 1), gridBag, c, 1, 2, 1, 1, 0, 0);
        this.AddToGrid(bugViewPanel, this.pitchScroll, gridBag, c, 2, 2, 1, 1, 1, 0);
        this.AddToGrid(bugViewPanel, new Label("Zoom", 1), gridBag, c, 1, 3, 1, 1, 0, 0);
        this.AddToGrid(bugViewPanel, this.zoomScroll, gridBag, c, 2, 3, 1, 1, 1, 0);
        selectorsPanel.setLayout(new GridLayout(0, 5));
        int i2 = 0;
        while (i2 < 16) {
            selectorsPanel.add(this.cardSelectorBoxes[i2]);
            ++i2;
        }
        this.cardsPanel.setLayout(this.cardsPanelLayout);
        int i3 = 0;
        while (i3 < 17) {
            Panel p;
            this.cardsPanels[i3] = p = new Panel();
            this.cardsPanel.add(panelIndexString[i3], p);
            ++i3;
        }
        this.cardsPanels[0].setLayout(new GridLayout(0, 6));
        this.cardsPanels[1].setLayout(new GridLayout(0, 6));
        this.cardsPanels[2].setLayout(new GridLayout(0, 6));
        this.cardsPanels[3].setLayout(new GridLayout(0, 6));
        this.cardsPanels[4].setLayout(new GridLayout(0, 7));
        this.cardsPanels[5].setLayout(new GridLayout(0, MAX_BODYDF_ARMS + 1));
        this.cardsPanels[6].setLayout(new GridLayout(0, MAX_BODYDF_ARMS + 1));
        this.cardsPanels[7].setLayout(new GridLayout(0, MAX_BODYDF_ARMS + 1));
        this.cardsPanels[8].setLayout(new GridLayout(0, MAX_BODYDF_ARMS + 1));
        this.cardsPanels[9].setLayout(new GridLayout(0, 5));
        this.cardsPanels[10].setLayout(new GridLayout(0, 9, 2, 0));
        this.cardsPanels[11].setLayout(new GridLayout(0, 3));
        this.cardsPanels[12].setLayout(new GridLayout(0, 7));
        this.cardsPanels[13].setLayout(new GridLayout(0, 5));
        this.cardsPanels[14].setLayout(new GridLayout(0, 10));
        this.cardsPanels[15].setLayout(new GridLayout(0, 1));
        int i4 = 0;
        while (i4 < 6) {
            BugApplet.reference2Panel[i4] = new Panel();
            reference2Panel[i4].setLayout(new GridLayout(1, 0));
            reference2Panel[i4].add(reference2Label[i4]);
            reference2Panel[i4].add(reference2Scroll[i4]);
            ++i4;
        }
        int i5 = 0;
        while (i5 < Bug.numArms) {
            int k = 0;
            while (k < 3) {
                BugApplet.reference1Panel[i5][k] = new Panel();
                reference1Panel[i5][k].setLayout(new GridLayout(1, 0));
                reference1Panel[i5][k].add(reference1Label[i5][k]);
                reference1Panel[i5][k].add(reference1Scroll[i5][k]);
                ++k;
            }
            ++i5;
        }
        this.SelectDisplayCard(0);
        this.SelectControlCard(10);
        BugApplet.DebugMessage("Bug size " + this.theBug.size.xyz[0] + " long, " + this.theBug.size.xyz[2] + " wide, " + this.theBug.size.xyz[1] + " tall.\n" + "Moment of inertia = " + this.theBug.moments.makeString() + "\n\n");
    }

    Panel Panellise(Component c) {
        Panel p = new Panel();
        p.add(c);
        return p;
    }

    void AddToGrid(Container c, Component cpt, GridBagLayout g, GridBagConstraints gbc, int x, int y, int xw, int yw, int xwt, int ywt) {
        gbc.gridwidth = xw;
        gbc.gridheight = yw;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weightx = xwt;
        gbc.weighty = ywt;
        g.setConstraints(cpt, gbc);
        c.add(cpt);
    }

    public boolean DOrunButton(Button button) {
        if (button.equals(this.runButton)) {
            if (BugApplet.HaveAnimation()) {
                this.StopAnimation();
            } else {
                this.StartAnimation(0);
            }
            return true;
        }
        return false;
    }

    public boolean DOstepButton(Button button) {
        if (button.equals(this.stepButton)) {
            this.StopAnimation();
            this.IterateBug();
            return true;
        }
        return false;
    }

    public boolean DOcorrButton(Button button) {
        if (button.equals(this.corrButton)) {
            this.StartCorrelations();
            return true;
        }
        return false;
    }

    public void StartCorrelations() {
        SendMessage.Tell("Calculating correlation of vertical force disturbance with vertical position and output of height controller over " + correlationInterval + " seconds.\n");
        correlationStart = Bug.globalTime;
        correlationStop = correlationStart + correlationInterval;
        this.x_mean = 0.0;
        this.y_mean = 0.0;
        this.z_mean = 0.0;
        this.x_delta = 0.0;
        this.y_delta = 0.0;
        this.z_delta = 0.0;
        this.x_sq = 0.0;
        this.y_sq = 0.0;
        this.z_sq = 0.0;
        this.xy_moment = 0.0;
        this.xz_moment = 0.0;
        this.numCorrValues = 0;
    }

    public void IncrCorrelations(double x, double y, double z) {
        int num1 = this.numCorrValues + 1;
        this.x_delta = (x - this.x_mean) / (double)num1;
        this.y_delta = (y - this.y_mean) / (double)num1;
        this.z_delta = (z - this.z_mean) / (double)num1;
        this.x_sq = (double)this.numCorrValues * (this.x_sq / (double)num1 + this.x_delta * this.x_delta);
        this.y_sq = (double)this.numCorrValues * (this.y_sq / (double)num1 + this.y_delta * this.y_delta);
        this.z_sq = (double)this.numCorrValues * (this.z_sq / (double)num1 + this.z_delta * this.z_delta);
        this.xy_moment = (double)this.numCorrValues * (this.xy_moment / (double)num1 + this.x_delta * this.y_delta);
        this.xz_moment = (double)this.numCorrValues * (this.xz_moment / (double)num1 + this.x_delta * this.z_delta);
        this.x_mean += this.x_delta;
        this.y_mean += this.y_delta;
        this.z_mean += this.z_delta;
        this.numCorrValues = num1;
    }

    public void StopCorrelations() {
        if (this.numCorrValues == 0) {
            SendMessage.Tell("Correlation not defined, N = 0.\n");
        } else {
            double x_rms = Math.sqrt(this.x_sq * this.x_sq);
            double y_rms = Math.sqrt(this.y_sq * this.y_sq);
            double xy_rms = Math.sqrt(this.x_sq * this.y_sq);
            double xz_rms = Math.sqrt(this.x_sq * this.z_sq);
            double correlationXY = this.xy_moment / xy_rms;
            double correlationXZ = this.xz_moment / xz_rms;
            double rejectionRatio = Math.log(x_rms / y_rms) * 10.0 / Math.log(10.0);
            SendMessage.Tell("Correlations:\nDisturbance vs. perception =\n  " + JRKUtils.DoubleToString(correlationXY, 3) + " = " + JRKUtils.DoubleToString(this.xy_moment, 3) + "/sqrt(" + JRKUtils.DoubleToString(this.x_sq * this.y_sq, 3) + ").\n");
            SendMessage.Tell("Disturbance. vs. output =\n  " + JRKUtils.DoubleToString(correlationXZ, 3) + " = " + JRKUtils.DoubleToString(this.xz_moment, 3) + "/sqrt(" + JRKUtils.DoubleToString(this.x_sq * this.z_sq, 3) + ").\n");
            SendMessage.Tell("Rejection ratio =\n  " + JRKUtils.DoubleToString(rejectionRatio, 3) + " dB\n");
            SendMessage.Tell("N = " + this.numCorrValues + "\n");
        }
        correlationStop = 0.0;
    }

    public boolean DOinitGeomButton(Button button) {
        if (button.equals(this.initGeomButton)) {
            this.StopAnimation();
            this.theBug.reinitBug();
            this.initialiseBug();
            this.oscilloscopeCanvas.clear();
            this.RepaintDisplay();
            return true;
        }
        return false;
    }

    public boolean DOinitViewButton(Button button) {
        if (button.equals(this.initViewButton)) {
            this.headingScroll.setValue(45);
            this.pitchScroll.setValue(-30);
            this.zoomScroll.setValue(16);
            this.ChangeView();
            return true;
        }
        return false;
    }

    public boolean DOclearMessagesButton(Button button) {
        if (button.equals(this.clearMessagesButton)) {
            messageArea.replaceRange("", 0, Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    public boolean DOwalkButton(Button button) {
        int i = 0;
        while (i < Bug.numArms / 2) {
            int j = 0;
            while (j < 9) {
                if (button.equals(this.walkButton[i][j])) {
                    this.theBug.WalkLegPair(i, j, 1.0);
                    this.Tickle();
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean DOwalkProgramButton(Button button) {
        int i = 0;
        while (i < 6) {
            if (button.equals(this.walkProgramButton[i])) {
                this.walkProgram = i;
                switch (this.walkProgram) {
                    case 0: {
                        int j = 0;
                        while (j < Bug.numArms) {
                            this.theBug.WalkLeg(j, 2, 1.0);
                            ++j;
                        }
                        this.walkProgram = 1;
                        break;
                    }
                    case 1: {
                        int j = 0;
                        while (j < Bug.numArms) {
                            this.theBug.WalkLeg(j, 4, 1.0);
                            ++j;
                        }
                        this.theBug.currentProgram = null;
                        break;
                    }
                    case 2: {
                        this.theBug.currentProgram = this.theBug.walkFwdProgram;
                        this.theBug.currentProgram.startProgram();
                        break;
                    }
                    case 3: {
                        this.theBug.currentProgram = this.theBug.walkBackProgram;
                        this.theBug.currentProgram.startProgram();
                        break;
                    }
                    case 4: {
                        this.theBug.currentProgram = this.theBug.turnRightProgram;
                        this.theBug.currentProgram.startProgram();
                        break;
                    }
                    case 5: {
                        this.theBug.currentProgram = this.theBug.turnLeftProgram;
                        this.theBug.currentProgram.startProgram();
                        break;
                    }
                    default: {
                        this.nextStepTime = Bug.globalTime;
                    }
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean DOheadingPitchScroll(Scrollbar bar) {
        if (bar.equals(this.headingScroll) || bar.equals(this.pitchScroll) || bar.equals(this.zoomScroll)) {
            this.ChangeView();
            return true;
        }
        return false;
    }

    public static boolean HaveAnimation() {
        return animation != null && animation.isAlive();
    }

    public boolean SuspendAnimation() {
        boolean wasAnimating = BugApplet.HaveAnimation();
        if (wasAnimating) {
            animation.checkAccess();
            animation.suspend();
        }
        return wasAnimating;
    }

    public void ResumeAnimation(boolean wasAnimating) {
        if (wasAnimating && BugApplet.HaveAnimation()) {
            animation.checkAccess();
            animation.resume();
        }
    }

    public void StartAnimation(int numIters) {
        TicksSinceDrawn = 0;
        allowAnimation = true;
        this.runButton.setLabel("Stop");
        animation = new AnimationThread(this, numIters);
        animation.setPriority(3);
        animation.start();
    }

    public boolean StopAnimation() {
        boolean wasAnimating = allowAnimation;
        allowAnimation = false;
        if (animation != null && animation.isAlive()) {
            animation.checkAccess();
            this.RepaintDisplay();
        }
        animation = null;
        this.runButton.setLabel("Run");
        this.RestoreControlValues(false);
        return wasAnimating;
    }

    public void InitFrameRate() {
        this.lastTimeIndex = 0;
        double curTime = System.currentTimeMillis();
        int i = 0;
        while (i < this.NUMTIMES) {
            this.lastTimes[i] = curTime;
            ++i;
        }
        frameRateLabel.setText("0.0 fr/sec");
    }

    public void UpdateFrameRate() {
        double lastTime;
        long newTime = System.currentTimeMillis();
        if ((double)newTime > (lastTime = this.lastTimes[this.lastTimeIndex])) {
            double frameRate = (double)this.NUMTIMES * 1000.0 / ((double)newTime - lastTime);
            frameRateLabel.setText(String.valueOf(JRKUtils.DoubleToString(frameRate, 3)) + " fr/sec");
            this.lastTimes[this.lastTimeIndex] = newTime;
            this.lastTimeIndex = (this.lastTimeIndex + 1) % this.NUMTIMES;
        }
    }

    double DisturbanceSize(double t) {
        if (pokePeriod == 0.0) {
            return 0.0;
        }
        double phase = (t / pokePeriod - (double)((int)(t / pokePeriod))) * Math.PI * 2.0;
        double x = Math.sin(phase);
        if (x == 0.0) {
            return 0.0;
        }
        double r = Math.pow(Math.abs(x), 1.0 - pokePointiness);
        return x > 0.0 ? r : -r;
    }

    public void IterateBug() {
        if (Bug.globalTime < pokeStopTime) {
            double disturbSize = this.DisturbanceSize(pokeTime += delta_t);
            if (doPokeForce) {
                Bug.constDisturbingForce.xyz[BugApplet.pokeComponent] = pokeForce * disturbSize;
            } else {
                Bug.constDisturbingTorque.xyz[BugApplet.pokeComponent] = pokeTorque * disturbSize;
            }
        }
        this.theBug.MoveBug(delta_t);
        double x = this.theBug.translation.xyz[0];
        double z = this.theBug.translation.xyz[2];
        double distanceSq = x * x + z * z;
        double terrainSemiDiameter = this.theBug.terrain.semiDiameter;
        if (distanceSq > terrainSemiDiameter * terrainSemiDiameter) {
            double th = this.theBug.terrain.HeightAt(this.theBug.translation.xyz[0], this.theBug.translation.xyz[2]);
            this.theBug.translation.xyz[0] = this.theBug.terrain.initialX;
            this.theBug.translation.xyz[1] = this.theBug.translation.xyz[1] + (this.theBug.terrain.HeightAt(this.theBug.terrain.initialX, this.theBug.terrain.initialZ) - th);
            this.theBug.translation.xyz[2] = this.theBug.terrain.initialZ;
            this.theBug.velocity.xyz[0] = 0.0;
            this.theBug.velocity.xyz[2] = 0.0;
            this.theBug.PutFeetOnGround();
        }
        if (this.theBug.translation.xyz[1] > 100.0) {
            this.theBug.translation.xyz[1] = 100.0;
            this.theBug.velocity.xyz[1] = 0.0;
        }
        if (pokeStopTime > 0.0 && Bug.globalTime >= pokeStopTime) {
            Bug.constDisturbingForce = new Coord3();
            Bug.constDisturbingTorque = new Coord3();
            pokeStopTime = 0.0;
            SendMessage.Tell("Poke force and torque = 0\n");
        }
        if (correlationStop > 0.0) {
            this.IncrCorrelations(Bug.totalDisturbingForce.xyz[1], this.theBug.bodyController[0].perception, this.theBug.bodyController[0].output);
        }
        if (correlationStop > 0.0 && Bug.globalTime >= correlationStop) {
            this.StopCorrelations();
        }
        if (this.walkProgram != 1 && Bug.globalTime >= this.nextStepTime) {
            this.theBug.currentProgram.doNextStep();
            this.nextStepTime = Bug.globalTime + walkInterval;
        }
        timeLabel.setText("Time " + JRKUtils.DoubleToString(Bug.globalTime, 3));
        totalError = this.theBug.totalError();
        this.RestoreControlValues(false);
        this.UpdateFrameRate();
        this.oscilloscopeNewData();
        if (AnimationInterval == 0 || ++TicksSinceDrawn % AnimationInterval == 0) {
            switch (DisplayMode) {
                case 0: {
                    this.bugCanvas.drawAgain();
                    break;
                }
            }
        }
    }

    public void oscilloscopeNewData() {
        Graphics g = DisplayMode == 1 ? this.oscilloscopeCanvas.getGraphics() : null;
        this.oscilloscopeCanvas.stepTime(g);
        this.oscilloscopeCanvas.acceptPoint(g, 0, this.theBug.bodyController[0].perception);
        this.oscilloscopeCanvas.acceptPoint(g, 1, this.theBug.bodyController[0].output);
        this.oscilloscopeCanvas.acceptPoint(g, 2, this.theBug.bodyController[0].error());
        this.oscilloscopeCanvas.acceptPoint(g, 3, Bug.totalDisturbingForce.xyz[1]);
        this.oscilloscopeCanvas.acceptPoint(g, 4, totalError);
        this.oscilloscopeCanvas.acceptPoint(g, 5, 0.0);
        if (g != null) {
            g.dispose();
        }
    }

    public void RepaintDisplay(int onlyMode) {
        if (onlyMode == DisplayMode) {
            this.RepaintDisplay();
        }
    }

    public void RepaintDisplay() {
        switch (DisplayMode) {
            case 0: {
                this.bugCanvas.drawAgain();
                break;
            }
            case 1: {
                this.oscilloscopeCanvas.repaint();
                break;
            }
        }
    }

    public void ChangeView() {
        int pitchScrollValue = -this.pitchScroll.getValue();
        double rawPitch = (double)pitchScrollValue > 89.999 ? 89.999 : ((double)pitchScrollValue < -89.999 ? -89.999 : (double)pitchScrollValue);
        double heading = (double)(360 - this.headingScroll.getValue()) * Math.PI / 180.0;
        double pitch = rawPitch * Math.PI / 180.0;
        double effectiveViewDistance = 60.0 + 1440.0 * (double)this.zoomScroll.getValue() / 100.0;
        double ch = Math.cos(heading);
        double sh = Math.sin(heading);
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        this.projection.initialise(new Coord3(ch * cp, sp, -sh * cp).scaleCoord3(effectiveViewDistance), 300.0 / effectiveViewDistance);
        this.theBug.terrain.imageIsValid = false;
        this.RepaintDisplay(0);
    }

    public void SelectDisplayCard(int cardIndex) {
        DisplayMode = cardIndex;
        this.displayPanelLayout.show(this.displayPanel, displayIndexString[cardIndex]);
    }

    public void SelectControlCard(int cardIndex) {
        this.cardsPanelLayout.show(this.cardsPanel, panelIndexString[16]);
        if (this.ValidPanel(cardIndex)) {
            this.RestoreControlValues(cardIndex, true);
        } else {
            this.ReconstructCard(cardIndex);
        }
        this.cardsPanelLayout.show(this.cardsPanel, panelIndexString[cardIndex]);
        this.currentCard = cardIndex;
    }

    public boolean DOdisplaySelectorGroup(Checkbox checkbox) {
        int i = 0;
        while (i < 3) {
            if (checkbox.equals(this.displaySelectorBoxes[i])) {
                this.SelectDisplayCard(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean DOterrainGroup(Checkbox checkbox) {
        int i = 0;
        while (i < 3) {
            if (checkbox.equals(this.terrainCheckboxes[i])) {
                this.theBug.SelectTerrain(i);
                this.theBug.terrain.currentImage = this.bugCanvas.terrainImage;
                this.Tickle();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean DOcardSelectorGroup(Checkbox checkbox) {
        int i = 0;
        while (i < 16) {
            if (checkbox.equals(this.cardSelectorBoxes[i])) {
                this.SelectControlCard(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean DOpokeButtons(Button button) {
        int b = 0;
        while (b < 6) {
            if (button.equals(this.pokeButtons[b])) {
                switch (b) {
                    case 0: {
                        doPokeForce = true;
                        pokeComponent = 1;
                        break;
                    }
                    case 1: {
                        doPokeForce = true;
                        pokeComponent = 0;
                        break;
                    }
                    case 2: {
                        doPokeForce = true;
                        pokeComponent = 2;
                        break;
                    }
                    case 3: {
                        doPokeForce = false;
                        pokeComponent = 1;
                        break;
                    }
                    case 4: {
                        doPokeForce = false;
                        pokeComponent = 2;
                        break;
                    }
                    case 5: {
                        doPokeForce = false;
                        pokeComponent = 0;
                        break;
                    }
                }
                pokeStopTime = Bug.globalTime + pokeInterval;
                pokeTime = 0.0;
                SendMessage.Tell(String.valueOf(doPokeForce ? "Poke force(" : "Poke torque(") + pokeComponent + ") = " + JRKUtils.DoubleToString(doPokeForce ? pokeForce : pokeTorque, 3) + ", pointiness = " + JRKUtils.DoubleToString(pokePointiness, 3) + "\n");
                return true;
            }
            ++b;
        }
        return false;
    }

    public boolean DOforceCheckbox(Checkbox checkbox) {
        if (checkbox.equals(this.forceCheckbox)) {
            showForces = this.forceCheckbox.getState();
            this.RepaintDisplay(0);
            return true;
        }
        return false;
    }

    public boolean DOcontrolEnable(Checkbox checkbox) {
        int i = 0;
        while (i < 6) {
            if (checkbox.equals(enabled2Checkbox[i])) {
                this.theBug.bodyController[i].enable(enabled2Checkbox[i].getState());
                this.Tickle();
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < Bug.numArms) {
            int j = 0;
            while (j < 3) {
                if (checkbox.equals(enabled1Checkbox[i2][j])) {
                    this.theBug.armJointVelController[i2][j].enable(enabled1Checkbox[i2][j].getState());
                    this.Tickle();
                    return true;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < Bug.numArms) {
            if (checkbox.equals(armAliveCheckbox[i3])) {
                this.theBug.arms[i3].alive = armAliveCheckbox[i3].getState();
                this.Tickle();
                return true;
            }
            if (checkbox.equals(armGroundedCheckbox[i3])) {
                if (armGroundedCheckbox[i3].getState()) {
                    this.theBug.MakeFootContact(i3);
                } else {
                    this.theBug.arms[i3].LoseContact();
                }
                this.Tickle();
                return true;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < Bug.numArms) {
            int j = 0;
            while (j < 2) {
                if (checkbox.equals(footEnabledCheckbox[i4][j])) {
                    boolean enabled = footEnabledCheckbox[i4][j].getState();
                    this.theBug.footController[i4][j].enable(enabled);
                    this.Tickle();
                    return true;
                }
                ++j;
            }
            ++i4;
        }
        return false;
    }

    public static String BracketString(boolean enable, String s) {
        return enable ? s : "(" + s + ")";
    }

    public void Tickle() {
        if (!BugApplet.HaveAnimation()) {
            this.theBug.UpdateControl();
            this.RestoreControlValues(false);
            this.RepaintDisplay(0);
        }
    }

    public void UpdateArmCheckboxes() {
        int i = 0;
        while (i < Bug.numArms) {
            armGroundedCheckbox[i].setState(this.theBug.arms[i].groundContact);
            ++i;
        }
    }

    public boolean DOcontrolScroll(Scrollbar bar) {
        int i = 0;
        while (i < 6) {
            if (bar.equals(reference2Scroll[i])) {
                double r = JRKUtils.ScaleIntToDouble(reference2Scroll[i].getValue(), reference2imax[i], reference2dmin[i], reference2dmax[i]);
                Controller c = this.theBug.bodyController[i];
                c.acceptReference(r);
                reference2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(r, 2)));
                this.Tickle();
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < Bug.numArms) {
            int j = 0;
            while (j < 3) {
                if (bar.equals(reference1Scroll[i2][j])) {
                    double r = JRKUtils.ScaleIntToDouble(reference1Scroll[i2][j].getValue(), reference1imax[j], reference1dmin[j], reference1dmax[j]);
                    Controller c = this.theBug.armJointVelController[i2][j];
                    c.acceptReference(r);
                    reference1Label[i2][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(r, 2)));
                    this.Tickle();
                    return true;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 6) {
            int j = 0;
            while (j < 4) {
                if (bar.equals(this.controlParamScroll[i3][j])) {
                    double r = JRKUtils.ScaleIntToDouble(this.controlParamScroll[i3][j].getValue(), this.controlParamimax[j], this.controlParamdmin[j], this.controlParamdmax[j]);
                    Controller c = this.theBug.bodyController[i3];
                    ((PIDController)c).controlParams[j] = r;
                    this.controlParamLabel[i3][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(r, 2)));
                    this.Tickle();
                    return true;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < 2) {
            Scrollbar[] fCPSs = this.footControlParamScroll[i4];
            int k = 0;
            while (k < 4) {
                Scrollbar fCPS = fCPSs[k];
                if (bar.equals(fCPS)) {
                    double r = JRKUtils.ScaleIntToDouble(fCPS.getValue(), this.footControlParamimax[k], this.footControlParamdmin[k], this.footControlParamdmax[k]);
                    this.footControlParamLabel[i4][k].setText(JRKUtils.DoubleToString(r, 2));
                    int j = 0;
                    while (j < Bug.numArms) {
                        ((PIDController)this.theBug.footController[j][i4]).controlParams[k] = r;
                        ++j;
                    }
                    this.Tickle();
                    return true;
                }
                ++k;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < 19) {
            if (bar.equals(this.parameterScroll[i5])) {
                int ivalue = this.parameterScroll[i5].getValue();
                double r = JRKUtils.ScaleIntToDouble(ivalue, this.parameterimax[i5], this.parameterdmin[i5], this.parameterdmax[i5]);
                this.parameterLabel[i5].setText(i5 == 9 ? String.valueOf(ivalue) : JRKUtils.DoubleToString(r, 3));
                switch (i5) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int k = 0;
                        while (k < Bug.numArms) {
                            Controller[] cs = this.theBug.armJointVelController[k];
                            int j = 0;
                            while (j < 3) {
                                ((PIDController)cs[j]).controlParams[i5] = r;
                                ++j;
                            }
                            ++k;
                        }
                        this.Tickle();
                        break;
                    }
                    case 4: {
                        this.theBug.mass = r;
                        this.Tickle();
                        break;
                    }
                    case 5: {
                        Bug.disturbForceScale = r;
                        this.Tickle();
                        break;
                    }
                    case 6: {
                        Bug.disturbTorqueScale = r;
                        this.Tickle();
                        break;
                    }
                    case 7: {
                        Bug.disturbLeakage = r;
                        break;
                    }
                    case 8: {
                        delta_t = r;
                        break;
                    }
                    case 9: {
                        AnimationInterval = ivalue;
                        break;
                    }
                    case 10: {
                        correlationInterval = r;
                        break;
                    }
                    case 11: {
                        pokeForce = r;
                        break;
                    }
                    case 12: {
                        pokeTorque = r;
                        break;
                    }
                    case 13: {
                        pokePeriod = r;
                        break;
                    }
                    case 14: {
                        pokeInterval = r;
                        break;
                    }
                    case 15: {
                        pokePointiness = r;
                        break;
                    }
                    case 16: {
                        walkInterval = r;
                        break;
                    }
                    case 17: {
                        this.theBug.landmark.xyz[0] = r;
                        this.Tickle();
                        break;
                    }
                    case 18: {
                        this.theBug.landmark.xyz[2] = r;
                        this.Tickle();
                        break;
                    }
                }
                return true;
            }
            ++i5;
        }
        return false;
    }

    void AddEmptyLabels(Panel p, int numLabels) {
        if (numLabels > 0) {
            int i = 0;
            while (i < numLabels) {
                p.add(new Label(""));
                ++i;
            }
        }
    }

    public void ReconstructCard(int cardIndex) {
        Panel p = this.cardsPanels[cardIndex];
        this.validPanels &= ~PANEL_CONNECTIONS[cardIndex];
        this.validPanels |= 1 << cardIndex;
        p.removeAll();
        int i = 0;
        while (i < 16) {
            if (!this.ValidPanel(i)) {
                this.cardsPanels[i].removeAll();
            }
            ++i;
        }
        switch (cardIndex) {
            case 0: {
                p.add(new Label(panelNames[cardIndex], 1));
                int j = 0;
                while (j < 4) {
                    p.add(new Label(cardColumnNames[j], 1));
                    ++j;
                }
                p.add(new Label(cardColumnNames[4], 0));
                int i2 = 0;
                while (i2 < 6) {
                    p.add(new Label(upperNames[i2], 1));
                    p.add(perception2Label[i2]);
                    p.add(reference2Panel[i2]);
                    p.add(error2Label[i2]);
                    p.add(output2Label[i2]);
                    p.add(enabled2Checkbox[i2]);
                    ++i2;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                p.add(new Label(panelNames[cardIndex], 1));
                int j = 0;
                while (j < 4) {
                    p.add(new Label(cardColumnNames[j], 1));
                    ++j;
                }
                p.add(new Label(cardColumnNames[4], 0));
                int i3 = 0;
                while (i3 < Bug.numArms) {
                    p.add(new Label(this.ArmName(i3), 1));
                    p.add(perception1Label[i3][cardIndex - 1]);
                    p.add(reference1Panel[i3][cardIndex - 1]);
                    p.add(error1Label[i3][cardIndex - 1]);
                    p.add(output1Label[i3][cardIndex - 1]);
                    p.add(enabled1Checkbox[i3][cardIndex - 1]);
                    ++i3;
                }
                break;
            }
            case 4: {
                p.add(new Label(panelNames[cardIndex], 1));
                int i4 = 0;
                while (i4 < 6) {
                    p.add(new Label(upperNames[i4], 1));
                    ++i4;
                }
                i4 = 0;
                while (i4 < Bug.numArms) {
                    p.add(new Label(this.ArmName(i4), 1));
                    int j = 0;
                    while (j < 6) {
                        p.add(linkageLabel[i4][j]);
                        ++j;
                    }
                    ++i4;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                p.add(new Label(panelNames[cardIndex], 1));
                int i5 = 0;
                while (i5 < 6) {
                    p.add(new Label(upperNames[i5], 1));
                    ++i5;
                }
                this.AddEmptyLabels(p, -DELTA_BODYDF_ARMS);
                p.add(new Label(""));
                i5 = 0;
                while (i5 < 6) {
                    switch (cardIndex) {
                        case 5: {
                            p.add(perception2Label[i5]);
                            break;
                        }
                        case 6: {
                            p.add(reference2Panel[i5]);
                            break;
                        }
                        case 7: {
                            p.add(error2Label[i5]);
                            break;
                        }
                        case 8: {
                            p.add(output2Label[i5]);
                            break;
                        }
                    }
                    ++i5;
                }
                this.AddEmptyLabels(p, -DELTA_BODYDF_ARMS);
                p.add(new Label(""));
                i5 = 0;
                while (i5 < Bug.numArms) {
                    p.add(new Label(this.ArmName(i5), 1));
                    ++i5;
                }
                this.AddEmptyLabels(p, DELTA_BODYDF_ARMS);
                int j = 0;
                while (j < 3) {
                    p.add(new Label(jointNames[j], 1));
                    int i6 = 0;
                    while (i6 < Bug.numArms) {
                        switch (cardIndex) {
                            case 5: {
                                p.add(perception1Label[i6][j]);
                                break;
                            }
                            case 6: {
                                p.add(reference1Panel[i6][j]);
                                break;
                            }
                            case 7: {
                                p.add(error1Label[i6][j]);
                                break;
                            }
                            case 8: {
                                p.add(output1Label[i6][j]);
                                break;
                            }
                        }
                        ++i6;
                    }
                    this.AddEmptyLabels(p, DELTA_BODYDF_ARMS);
                    ++j;
                }
                break;
            }
            case 9: {
                p.add(new Label(panelNames[cardIndex], 1));
                int i7 = 0;
                while (i7 < 4) {
                    p.add(new Label(this.controlParamNames[i7], 1));
                    ++i7;
                }
                int i8 = 0;
                while (i8 < 6) {
                    p.add(new Label(upperNames[i8], 1));
                    int j = 0;
                    while (j < 4) {
                        Panel p1;
                        this.upperParamPanel[i8][j] = p1 = new Panel();
                        GridBagLayout gridBag = new GridBagLayout();
                        GridBagConstraints c = new GridBagConstraints();
                        c.fill = 1;
                        p1.setLayout(gridBag);
                        this.AddToGrid(p1, this.controlParamLabel[i8][j], gridBag, c, 1, 1, 1, 1, 0, 1);
                        this.AddToGrid(p1, this.controlParamScroll[i8][j], gridBag, c, 2, 1, 1, 1, 1, 1);
                        p.add(p1);
                        ++j;
                    }
                    ++i8;
                }
                break;
            }
            case 10: {
                int i9 = 0;
                while (i9 < 19) {
                    p.add(this.parameterName[i9]);
                    p.add(this.parameterLabel[i9]);
                    p.add(this.parameterScroll[i9]);
                    ++i9;
                }
                break;
            }
            case 11: {
                p.add(new Label(panelNames[cardIndex], 0));
                p.add(new Label("Alive", 0));
                p.add(new Label("Grounded", 0));
                int i10 = 0;
                while (i10 < Bug.numArms) {
                    p.add(new Label(this.ArmName(i10), 0));
                    p.add(armAliveCheckbox[i10]);
                    p.add(armGroundedCheckbox[i10]);
                    ++i10;
                }
                break;
            }
            case 12: {
                p.add(new Label(panelNames[cardIndex], 1));
                int i11 = 0;
                while (i11 < 2) {
                    p.add(new Label(i11 == 0 ? "Trans. perc." : "Longit. perc.", 1));
                    p.add(new Label(i11 == 0 ? "Trans. output" : "Longit. output", 1));
                    p.add(new Label("Enabled", 0));
                    ++i11;
                }
                i11 = 0;
                while (i11 < Bug.numArms) {
                    p.add(new Label(this.ArmName(i11), 1));
                    int j = 0;
                    while (j < 2) {
                        int k = 0;
                        while (k < Bug.numArms) {
                            p.add(footPerceptionLabel[i11][j]);
                            ++k;
                        }
                        int k2 = 0;
                        while (k2 < Bug.numArms) {
                            p.add(footOutputLabel[i11][j]);
                            ++k2;
                        }
                        int k3 = 0;
                        while (k3 < Bug.numArms) {
                            p.add(footEnabledCheckbox[i11][j]);
                            ++k3;
                        }
                        ++j;
                    }
                    ++i11;
                }
                break;
            }
            case 13: {
                p.add(new Label(panelNames[cardIndex], 1));
                int i12 = 0;
                while (i12 < 4) {
                    p.add(new Label(this.controlParamNames[i12], 1));
                    ++i12;
                }
                int i13 = 0;
                while (i13 < 2) {
                    p.add(new Label(dfNames[i13], 1));
                    int j = 0;
                    while (j < 4) {
                        Panel p1;
                        this.footParamPanel[i13][j] = p1 = new Panel();
                        GridBagLayout gridBag = new GridBagLayout();
                        GridBagConstraints c = new GridBagConstraints();
                        c.fill = 1;
                        p1.setLayout(gridBag);
                        this.AddToGrid(p1, this.footControlParamLabel[i13][j], gridBag, c, 1, 1, 1, 1, 0, 1);
                        this.AddToGrid(p1, this.footControlParamScroll[i13][j], gridBag, c, 2, 1, 1, 1, 1, 1);
                        p.add(p1);
                        ++j;
                    }
                    ++i13;
                }
                break;
            }
            case 14: {
                p.add(new Label(panelNames[cardIndex], 1));
                int halfArms = Bug.numArms / 2;
                int i14 = 0;
                while (i14 < 9) {
                    p.add(new Label(this.walkActionNames[i14], 1));
                    ++i14;
                }
                int i15 = 0;
                while (i15 < halfArms) {
                    p.add(new Label(i15 == 0 ? "Front" : (i15 == halfArms - 1 ? "Rear" : " "), 1));
                    int j = 0;
                    while (j < 9) {
                        p.add(this.walkButton[i15][j]);
                        ++j;
                    }
                    ++i15;
                }
                int i16 = 0;
                while (i16 < 6) {
                    p.add(this.walkProgramButton[i16]);
                    ++i16;
                }
                break;
            }
            case 15: {
                p.add(new Label(panelNames[cardIndex], 0));
                int i17 = 0;
                while (i17 < 3) {
                    p.add(this.terrainCheckboxes[i17]);
                    ++i17;
                }
                break;
            }
        }
        this.RestoreControlValues(cardIndex, true);
    }

    public boolean ValidPanel(int cardIndex) {
        return (this.validPanels >> cardIndex & 1) != 0;
    }

    public void RestoreControlValues(boolean includeUserSettable) {
        this.RestoreControlValues(this.currentCard, includeUserSettable);
    }

    public void RestoreControlValues(int cardIndex, boolean includeUserSettable) {
        errorLabel.setText("Tot. err. " + JRKUtils.DoubleToString(totalError, 2));
        switch (cardIndex) {
            case 0: {
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    Controller c = cs[i];
                    perception2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.perception, 2)));
                    if (includeUserSettable) {
                        reference2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference, 2)));
                        reference2Scroll[i].setValue(JRKUtils.ScaleDoubleToInt(c.reference, reference2dmin[i], reference2dmax[i], reference2imax[i]));
                    }
                    error2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference - c.perception, 2)));
                    output2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.output, 2)));
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int j = cardIndex - 1;
                boolean k = false;
                int i = 0;
                while (i < Bug.numArms) {
                    Controller[] cs = this.theBug.armJointVelController[i];
                    Controller c = cs[j];
                    perception1Label[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.perception, 2)));
                    if (includeUserSettable) {
                        reference1Label[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference, 2)));
                        reference1Scroll[i][j].setValue(JRKUtils.ScaleDoubleToInt(c.reference, reference1dmin[j], reference1dmax[j], reference1imax[j]));
                    }
                    error1Label[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference - c.perception, 2)));
                    output1Label[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.output, 2)));
                    ++i;
                }
                break;
            }
            case 4: {
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    double[][][] owts = Bug.outputCoefficients;
                    boolean enabled = cs[i].enabled;
                    int j = 0;
                    while (j < Bug.numArms) {
                        StringBuffer buf = new StringBuffer(3);
                        int k = 0;
                        while (k < 3) {
                            double o = owts[j][k][i];
                            char c = o < 0.0 ? (char)'-' : (o > 0.0 ? (char)'+' : 'o');
                            buf.insert(buf.length(), c);
                            ++k;
                        }
                        linkageLabel[j][i].setText(BugApplet.BracketString(enabled, buf.toString()));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    Controller c = cs[i];
                    perception2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.perception, 2)));
                    ++i;
                }
                int i2 = 0;
                while (i2 < Bug.numArms) {
                    Controller[] cs2 = this.theBug.armJointVelController[i2];
                    int j = 0;
                    while (j < 3) {
                        Controller c = cs2[j];
                        perception1Label[i2][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.perception, 2)));
                        ++j;
                    }
                    ++i2;
                }
                break;
            }
            case 6: {
                if (!includeUserSettable) break;
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    Controller c = cs[i];
                    reference2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference, 2)));
                    reference2Scroll[i].setValue(JRKUtils.ScaleDoubleToInt(c.reference, reference2dmin[i], reference2dmax[i], reference2imax[i]));
                    ++i;
                }
                int i3 = 0;
                while (i3 < Bug.numArms) {
                    Controller[] cs3 = this.theBug.armJointVelController[i3];
                    int j = 0;
                    while (j < 3) {
                        Controller c = cs3[j];
                        reference1Label[i3][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.reference, 2)));
                        reference1Scroll[i3][j].setValue(JRKUtils.ScaleDoubleToInt(c.reference, reference1dmin[j], reference1dmax[j], reference1imax[j]));
                        ++j;
                    }
                    ++i3;
                }
                break;
            }
            case 7: {
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    Controller c = cs[i];
                    error2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.error(), 2)));
                    ++i;
                }
                int i4 = 0;
                while (i4 < Bug.numArms) {
                    Controller[] cs4 = this.theBug.armJointVelController[i4];
                    int j = 0;
                    while (j < 3) {
                        Controller c = cs4[j];
                        error1Label[i4][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.error(), 2)));
                        ++j;
                    }
                    ++i4;
                }
                break;
            }
            case 8: {
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    Controller c = cs[i];
                    output2Label[i].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.output, 2)));
                    ++i;
                }
                int i5 = 0;
                while (i5 < Bug.numArms) {
                    Controller[] cs5 = this.theBug.armJointVelController[i5];
                    int j = 0;
                    while (j < 3) {
                        Controller c = cs5[j];
                        output1Label[i5][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.output, 2)));
                        ++j;
                    }
                    ++i5;
                }
                break;
            }
            case 9: {
                if (!includeUserSettable) break;
                Controller[] cs = this.theBug.bodyController;
                int i = 0;
                while (i < 6) {
                    PIDController c = (PIDController)cs[i];
                    int j = 0;
                    while (j < 4) {
                        double value = c.controlParams[j];
                        this.controlParamLabel[i][j].setText(JRKUtils.DoubleToString(value, 2));
                        this.controlParamScroll[i][j].setValue(JRKUtils.ScaleDoubleToInt(value, this.controlParamdmin[j], this.controlParamdmax[j], this.controlParamimax[j]));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 10: {
                if (!includeUserSettable) break;
                Controller[] cs = this.theBug.bodyController;
                PIDController c = (PIDController)this.theBug.armJointVelController[0][0];
                this.SetParamIndicator(0, c.controlParams[0]);
                this.SetParamIndicator(1, c.controlParams[1]);
                this.SetParamIndicator(2, c.controlParams[2]);
                this.SetParamIndicator(3, c.controlParams[3]);
                this.SetParamIndicator(4, this.theBug.mass);
                this.SetParamIndicator(5, Bug.disturbForceScale);
                this.SetParamIndicator(6, Bug.disturbTorqueScale);
                this.SetParamIndicator(7, Bug.disturbLeakage);
                this.SetParamIndicator(8, delta_t);
                this.SetParamIntIndicator(9, AnimationInterval);
                this.SetParamIndicator(10, correlationInterval);
                this.SetParamIndicator(11, pokeForce);
                this.SetParamIndicator(12, pokeTorque);
                this.SetParamIndicator(13, pokePeriod);
                this.SetParamIndicator(14, pokeInterval);
                this.SetParamIndicator(15, pokePointiness);
                this.SetParamIndicator(16, walkInterval);
                break;
            }
            case 12: {
                int i = 0;
                while (i < Bug.numArms) {
                    Controller[] cs = this.theBug.footController[i];
                    int j = 0;
                    while (j < 2) {
                        Controller c = cs[j];
                        footPerceptionLabel[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.perception, 2)));
                        footOutputLabel[i][j].setText(BugApplet.BracketString(c.enabled, JRKUtils.DoubleToString(c.output, 2)));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 13: {
                if (!includeUserSettable) break;
                int i = 0;
                while (i < 2) {
                    PIDController c = (PIDController)this.theBug.footController[0][i];
                    int j = 0;
                    while (j < 4) {
                        double value = c.controlParams[j];
                        this.footControlParamLabel[i][j].setText(JRKUtils.DoubleToString(value, 2));
                        this.footControlParamScroll[i][j].setValue(JRKUtils.ScaleDoubleToInt(value, this.footControlParamdmin[j], this.footControlParamdmax[j], this.footControlParamimax[j]));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public void SetParamIndicator(int whichParam, double value) {
        this.parameterLabel[whichParam].setText(JRKUtils.DoubleToString(value, 3));
        this.parameterScroll[whichParam].setValue(JRKUtils.ScaleDoubleToInt(value, this.parameterdmin[whichParam], this.parameterdmax[whichParam], this.parameterimax[whichParam]));
    }

    public void SetParamIntIndicator(int whichParam, int value) {
        this.parameterLabel[whichParam].setText(String.valueOf(value));
        this.parameterScroll[whichParam].setValue(value);
    }

    public static void DebugMessage(String s) {
        if (allowDebugMessages) {
            SendMessage.Tell(s);
        }
    }

    public BugApplet() {
        double[] dArray = new double[19];
        dArray[4] = 0.01;
        dArray[8] = 0.001;
        dArray[11] = -10.0;
        dArray[12] = -100.0;
        dArray[17] = -100.0;
        dArray[18] = -100.0;
        this.parameterdmin = dArray;
        this.parameterdmax = new double[]{200.0, 50.0, 100.0, 5.0, 1.0, 100.0, 100.0, 0.05, 0.1, 4.0, 200.0, 10.0, 100.0, 100.0, 100.0, 1.0, 1.0, 100.0, 100.0};
        this.parameterimax = new int[]{100, 100, 100, 100, 99, 100, 100, 100, 99, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
        this.parameterStrings = new String[]{"Prop.", "Diff.", "Integral", "Int. leakage", "Mass", "Dist. force", "Dist. torque", "Dist. leakage", "Anim. step", "Frames/redraw", "Corr. interval", "Poke force", "Poke torque", "Poke period", "Poke time", "Poke pointiness", "Walk time", "Goal X", "Goal Z"};
        this.parameterName = new Label[19];
        this.parameterLabel = new Label[19];
        this.parameterScroll = new Scrollbar[19];
        this.upperParamPanel = new Panel[6][4];
        this.controlParamNames = new String[]{"Proportional", "Differential", "Integral", "Int. leakage"};
        this.controlParamLabel = new Label[6][4];
        this.controlParamScroll = new Scrollbar[6][4];
        this.controlParamdmin = new double[4];
        this.controlParamdmax = new double[]{100.0, 1.0, 1.0, 0.5};
        this.controlParamimax = new int[]{100, 100, 100, 100};
        this.footParamPanel = new Panel[2][4];
        this.footControlParamLabel = new Label[2][4];
        this.footControlParamScroll = new Scrollbar[2][4];
        this.footControlParamdmin = new double[4];
        this.footControlParamdmax = new double[]{200.0, 1.0, 20.0, 0.5};
        this.footControlParamimax = new int[]{100, 100, 100, 100};
        this.walkActionNames = new String[]{"Raise", "Forwards", "Centre", "Back", "Down", "Step fwd.", "Step back", "Turn right", "Turn left"};
        this.walkProgramNames = new String[]{"Reset arms", "Stop walking", "Walk fwds.", "Walk back", "Turn right", "Turn left"};
        this.walkProgramButton = new Button[6];
        this.theBug = new Bug();
        this.projection = new Projection(new Coord3(viewDistance / 1.732, viewDistance / 1.732, viewDistance / 1.732), 1.0);
        this.oscilloscopeCanvas = new OscilloscopeCanvas(this.theBug, delta_t);
        this.pokeButtonNames = new String[]{"Ht.", "Fwd.", "Rt.", "Hdg.", "Pch.", "Rl."};
        this.pokeButtons = new Button[6];
        this.cardsPanel = new Panel();
        this.cardsPanelLayout = new CardLayout();
        this.cardSelectorGroup = new CheckboxGroup();
        this.cardSelectorBoxes = new Checkbox[16];
        this.cardsPanels = new Panel[17];
        this.lastTime = 0L;
        this.NUMTIMES = 10;
        this.lastTimeIndex = 0;
        this.lastTimes = new double[this.NUMTIMES];
        this.x_mean = 0.0;
        this.y_mean = 0.0;
        this.z_mean = 0.0;
        this.x_delta = 0.0;
        this.y_delta = 0.0;
        this.z_delta = 0.0;
        this.x_sq = 0.0;
        this.y_sq = 0.0;
        this.z_sq = 0.0;
        this.xy_moment = 0.0;
        this.xz_moment = 0.0;
        this.numCorrValues = 0;
        this.walkProgram = 1;
        this.lastWalkedLeg = 0;
        this.nextStepTime = 0.0;
    }

    static {
        int[] nArray = new int[17];
        nArray[0] = 480;
        nArray[1] = 480;
        nArray[2] = 480;
        nArray[3] = 480;
        nArray[5] = 15;
        nArray[6] = 15;
        nArray[7] = 15;
        nArray[8] = 15;
        PANEL_CONNECTIONS = nArray;
        panelNames = new String[]{"TOP LEVEL", "SH. PITCH", "ELBOW", "SH. YAW", "LINKAGE", "PERCEPTIONS", "REFERENCES", "ERRORS", "OUTPUTS", "TOP-LEVEL PARAMS.", "PARAMETERS", "SWITCHES", "FEET", "FEET PARAMS", "WALK", "TERRAIN"};
        cardColumnNames = new String[]{"Perception", "Reference", "Error", "Output", "Enabled"};
        upperNames = new String[]{"Height", "Forwards", "Right", "Heading", "Pitch", "Roll"};
        jointNames = new String[]{"Sh. pitch", "Elbow", "Sh. yaw"};
        dfNames = new String[]{"Transverse", "Longitudinal"};
        panelIndexString = new String[]{"TOP", "SHP", "ELB", "SHY", "LIN", "PER", "REF", "ERR", "OUT", "TPAR", "PAR", "ARM", "FOO", "FOP", "WLK", "TER", "BLA"};
        timeLabel = new Label("Time = 0.0");
        errorLabel = new Label("Tot. err. = 0.0");
        DisplayMode = 0;
        displayIndexString = new String[]{"ANIM", "OSC", "NONE"};
        AnimationInterval = 0;
        TicksSinceDrawn = 0;
        totalError = 0.0;
        perception2Label = new Label[6];
        reference2Label = new Label[6];
        reference2Scroll = new Scrollbar[6];
        reference2Panel = new Panel[6];
        error2Label = new Label[6];
        output2Label = new Label[6];
        enabled2Checkbox = new Checkbox[6];
        reference2imax = new int[]{100, 100, 100, 100, 100, 100};
        double[] dArray = new double[6];
        dArray[1] = -10.0;
        dArray[2] = -10.0;
        dArray[3] = -1.5707963267948966;
        dArray[4] = -1.5707963267948966;
        dArray[5] = -1.5707963267948966;
        reference2dmin = dArray;
        reference2dmax = new double[]{40.0, 10.0, 10.0, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966};
        reference1imax = new int[]{100, 100, 100};
        reference1dmin = new double[]{-1.5707963267948966, -1.5707963267948966, -1.5707963267948966};
        reference1dmax = new double[]{1.5707963267948966, 1.5707963267948966, 1.5707963267948966};
        viewDistance = 300.0;
        allowDebugMessages = false;
        allowAnimation = false;
        delta_t = 0.005;
        showForces = true;
        doPokeForce = true;
        pokeComponent = 0;
        pokeTime = 0.0;
        pokeStopTime = 0.0;
        pokePeriod = pokeInterval = 15.0;
        pokeForce = -5.0;
        pokeTorque = 100.0;
        pokePointiness = 0.0;
        correlationInterval = 6.0;
        correlationStart = 0.0;
        correlationStop = 0.0;
        walkInterval = 0.1;
    }
}

