/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class Bug {
    static final Color orangeLeg = new Color(255, 128, 0);
    static double globalTime = 0.0;
    static final double GRAVITY = 0.981;
    static final double FORCESCALE = 20.0;
    static final double TORQUESCALE = 1.0;
    static final double MAXHEIGHT = 200.0;
    static double disturbForceScale = 0.0;
    static double disturbTorqueScale = 0.0;
    static double disturbLeakage = 0.01;
    static Coord3 constDisturbingForce = new Coord3();
    static Coord3 constDisturbingTorque = new Coord3();
    static Coord3 randomDisturbingForce = new Coord3();
    static Coord3 randomDisturbingTorque = new Coord3();
    static Coord3 totalDisturbingForce = new Coord3();
    static Coord3 totalDisturbingTorque = new Coord3();
    static final int DEFAULT_NUM_ARMS = 6;
    static int numArms = 6;
    Arm[] arms;
    static final double ARM_SPAN = 0.8;
    static final double FORWARD_ARM_YAW = 0.6283185307179586;
    Coord3 size;
    Coord3 moments;
    double mass;
    double density;
    static final int NUM_BODY_DF = 6;
    static final int HEIGHT_DF = 0;
    static final int FORWARDS_DF = 1;
    static final int RIGHT_DF = 2;
    static final int HEADING_DF = 3;
    static final int PITCH_DF = 4;
    static final int ROLL_DF = 5;
    static final int NUM_FEET_DF = 2;
    static final int TRANS_FOOT = 0;
    static final int LONGIT_FOOT = 1;
    Coord3 translation;
    Rotation orientation;
    boolean groundCollision;
    Coord3 groundReaction;
    Coord3 velocity;
    Coord3 angularVelocity;
    Coord3 totalForce;
    Coord3 totalTorque;
    static final int NUM_WALK_ACTIONS = 9;
    static final int NO_ACTION = -1;
    static final int RAISE_LEG = 0;
    static final int FORWARDS_LEG = 1;
    static final int CENTRE_LEG = 2;
    static final int BACK_LEG = 3;
    static final int LOWER_LEG = 4;
    static final int FWD_STEP_LEG = 5;
    static final int BACK_STEP_LEG = 6;
    static final int ROTATE_RIGHT = 7;
    static final int ROTATE_LEFT = 8;
    static final double RAISE_PITCH = 0.5;
    static final double FORWARDS_YAW = 0.5;
    static final double WALK_AMPLITUDE = 1.0;
    Program currentProgram;
    Program walkFwdProgram;
    Program walkBackProgram;
    Program turnRightProgram;
    Program turnLeftProgram;
    Controller[] bodyController;
    Controller[][] footController;
    Controller[][] armJointVelController;
    Controller[][] armJointAngleController;
    Controller goalHeading;
    Controller goalDistance;
    static final double[][][] outputTrends;
    static double[][][] outputCoefficients;
    static final int NUM_TRENDS = 4;
    static final int CONST_TREND = 0;
    static final int BACKFWD_TREND = 1;
    static final int LR_TREND = 2;
    static final int SADDLE_TREND = 3;
    Terrain terrain;
    Coord3 landmark = new Coord3(0.0, 0.0, -100.0);

    double trendCoefficient(int trend, int side, double fwds) {
        switch (trend) {
            case 0: {
                return 1.0;
            }
            case 2: {
                return side;
            }
            case 1: {
                return fwds;
            }
            case 3: {
                return (double)side * fwds;
            }
        }
        return 0.0;
    }

    Bug() {
        this.initBug(6);
    }

    Bug(int a) {
        this.initBug(a);
    }

    void reinitBug() {
        this.initBug(numArms);
    }

    void initBug(int a) {
        if (this.terrain == null) {
            this.terrain = new Staircase();
        }
        numArms = a;
        globalTime = 0.0;
        this.size = new Coord3(40.0, 5.0, 10.0);
        this.mass = 0.04;
        double volume = this.size.xyz[0] * this.size.xyz[1] * this.size.xyz[2] * Math.PI / 6.0;
        this.density = this.mass / volume;
        this.moments = Physics.Moments(this.size, 0.2);
        this.SetupControlHierarchy();
        this.orientation = new Rotation();
        this.velocity = new Coord3();
        this.angularVelocity = new Coord3();
        this.totalForce = new Coord3();
        this.totalTorque = new Coord3();
        this.groundCollision = false;
        this.groundReaction = new Coord3();
        constDisturbingForce = new Coord3();
        constDisturbingTorque = new Coord3();
        randomDisturbingForce = new Coord3();
        randomDisturbingTorque = new Coord3();
        totalDisturbingForce = new Coord3();
        totalDisturbingTorque = new Coord3();
        this.arms = new Arm[numArms];
        int i = 0;
        while (i < numArms) {
            this.arms[i] = new Arm();
            ++i;
        }
        this.SetArmsToInitialPositions();
        this.PutBugAtPosition(this.terrain.initialX, this.terrain.initialZ);
        this.UpdateReaction();
        this.walkFwdProgram = new Program(this, 0.0, 0.0, 1.0, 2);
        this.walkBackProgram = new Program(this, 0.0, 0.0, 1.0, 3);
        this.turnRightProgram = new Program(this, 0.0, 0.0, 1.0, 4);
        this.turnLeftProgram = new Program(this, 0.0, 0.0, 1.0, 5);
        this.currentProgram = null;
    }

    void PutBugAtPosition(double x, double z) {
        this.translation = new Coord3(x, this.terrain.HeightAt(x, z) - this.arms[0].vertReach(), z);
        this.PutFeetOnGround();
    }

    void PutFeetOnGround() {
        int i = 0;
        while (i < numArms) {
            this.arms[i].groundContact = false;
            this.MakeFootContact(i);
            ++i;
        }
    }

    void SetArmsToInitialPositions() {
        if (numArms % 2 != 0) {
            SendMessage.Tell("ERROR in SetArmsToInitialPositions: Bug has " + numArms + ", even number required.\n");
        }
        if (numArms < 4) {
            SendMessage.Tell("ERROR in SetArmsToInitialPositions: Bug has " + numArms + ", at least 4 required.\n");
        }
        int halfNumArms = numArms / 2;
        double armx = 0.8 * this.size.xyz[0];
        double rangeArmx = armx + armx;
        double delta_armx = rangeArmx / (double)(halfNumArms - 1);
        double armz = this.size.xyz[2];
        double minRot = 0.9424777960769379;
        double rangeRot = 1.2566370614359172;
        double deltaRot = rangeRot / (double)(halfNumArms - 1);
        int i = 0;
        while (i < halfNumArms) {
            this.arms[i].translation = new Coord3(armx, 0.0, -armz);
            this.arms[Bug.numArms - 1 - i].translation = new Coord3(armx, 0.0, armz);
            armx -= delta_armx;
            this.arms[i].orientation = new Rotation(new VRMLRotation(0.0, 1.0, 0.0, minRot));
            this.arms[Bug.numArms - 1 - i].orientation = new Rotation(new VRMLRotation(0.0, 1.0, 0.0, -minRot));
            minRot += deltaRot;
            ++i;
        }
        int i2 = 0;
        while (i2 < numArms) {
            double[] jas = this.arms[i2].jointAngles;
            Controller[] ajacs = this.armJointAngleController[i2];
            int j = 0;
            while (j < 3) {
                ajacs[j].acceptReference(jas[j]);
                ++j;
            }
            ++i2;
        }
    }

    void SetupControlHierarchy() {
        double nA2 = (double)numArms / 2.0 - 1.0;
        double a = 2.0 / nA2;
        double b = 1.0 - a * (double)(numArms - 1);
        int i = 0;
        while (i < numArms) {
            int side = i < numArms / 2 ? -1 : 1;
            double fwds = i < numArms / 2 ? 1.0 - a * (double)i : a * (double)i + b;
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 6) {
                    Bug.outputCoefficients[i][j][k] = 0.0;
                    int m = 0;
                    while (m < 4) {
                        double[] dArray = outputCoefficients[i][j];
                        int n = k;
                        dArray[n] = dArray[n] + outputTrends[k][j][m] * this.trendCoefficient(m, side, fwds);
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.bodyController = new PIDController[6];
        this.bodyController[0] = new PIDController(2.0, 0.5, 0.0, 0.1);
        this.bodyController[1] = new PIDController(8.0, 0.5, 0.0, 0.1);
        this.bodyController[2] = new PIDController(2.0, 0.5, 0.0, 0.1);
        this.bodyController[3] = new PIDController(8.0, 0.5, 0.0, 0.1);
        this.bodyController[4] = new PIDController(8.0, 0.5, 0.0, 0.1);
        this.bodyController[5] = new PIDController(2.0, 0.5, 0.0, 0.1);
        this.armJointVelController = new PIDController[numArms][];
        this.armJointAngleController = new PIDController[numArms][];
        this.footController = new PIDController[numArms][];
        int i2 = 0;
        while (i2 < numArms) {
            PIDController[] fcs = new PIDController[2];
            this.footController[i2] = fcs;
            int j = 0;
            while (j < 2) {
                PIDController fc = new PIDController();
                fc.initPIDController(0.0, 0.0, 0.0, 0.1);
                fcs[j] = fc;
                ++j;
            }
            PIDController[] ajvcs = new PIDController[3];
            this.armJointVelController[i2] = ajvcs;
            int j2 = 0;
            while (j2 < 3) {
                PIDController ajvc = new PIDController();
                ajvc.initPIDController(4.0, 0.0, 0.0, 0.1);
                ajvcs[j2] = ajvc;
                ++j2;
            }
            PIDController[] ajacs = new PIDController[3];
            this.armJointAngleController[i2] = ajacs;
            int j3 = 0;
            while (j3 < 3) {
                PIDController ajac = new PIDController();
                ajac.initPIDController(4.0, 0.0, 0.0, 0.1);
                ajacs[j3] = ajac;
                ++j3;
            }
            ++i2;
        }
        PIDController goalHeading = new PIDController();
        goalHeading.initPIDController(0.0, 0.0, 0.0, 0.1);
        PIDController goalDistance = new PIDController();
        goalDistance.initPIDController(0.0, 0.0, 0.0, 0.1);
        goalDistance.acceptReference(this.size.xyz[0] / 3.0);
    }

    double GroundHeight() {
        return this.terrain.HeightAt(this.translation.xyz[0], this.translation.xyz[2]);
    }

    void SelectTerrain(int t) {
        if (t == this.terrain.terrainType) {
            return;
        }
        double oldHeight = this.GroundHeight();
        switch (t) {
            case 0: {
                this.terrain = new FlatTerrain();
                this.PutBugAtPosition(this.terrain.initialX, this.terrain.initialZ);
                break;
            }
            case 1: {
                this.terrain = new ElevationGrid();
                this.PutBugAtPosition(this.terrain.initialX, this.terrain.initialZ);
                break;
            }
            case 2: {
                this.terrain = new Staircase();
                this.PutBugAtPosition(this.terrain.initialX, this.terrain.initialZ);
                break;
            }
        }
        double newHeight = this.GroundHeight();
        this.translation.xyz[1] = this.translation.xyz[1] + (newHeight - oldHeight);
        this.PutFeetOnGround();
    }

    boolean healthy() {
        int i = 0;
        while (i < numArms) {
            Arm a = this.arms[i];
            if (a.alive && (a.groundContact || !a.standing)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Coord3 FootprintOffset() {
        Coord3 result = new Coord3();
        int usedArms = 0;
        int i = 0;
        while (i < numArms) {
            Arm a = this.arms[i];
            if (a.alive && a.standing && a.groundContact) {
                Coord3 shoulderToFoot = this.BugToParentTransformPosition(a.orientation.applyRotation(a.ArmFootPos()));
                result.xyz[0] = result.xyz[0] + shoulderToFoot.xyz[0];
                result.xyz[2] = result.xyz[2] + shoulderToFoot.xyz[2];
                ++usedArms;
            }
            ++i;
        }
        if (usedArms > 0) {
            result.xyz[0] = this.translation.xyz[0] - result.xyz[0] / (double)usedArms;
            result.xyz[2] = this.translation.xyz[2] - result.xyz[2] / (double)usedArms;
        }
        return result;
    }

    double HeadingPerception() {
        double result = 0.0;
        int usedArms = 0;
        int i = 0;
        while (i < numArms) {
            Arm a = this.arms[i];
            if (a.alive && a.groundContact && a.standing) {
                result += a.jointAngles[2];
                ++usedArms;
            }
            ++i;
        }
        if (usedArms > 0) {
            result /= (double)usedArms;
        }
        return result;
    }

    boolean WalkLegPair(int legPair, int action, double amplitude) {
        boolean ok0 = this.WalkLeg(legPair, action, amplitude);
        boolean ok1 = this.WalkLeg(numArms - 1 - legPair, action, amplitude);
        return ok0 && ok1;
    }

    boolean WalkLeg(int leg, int action, double amplitude) {
        Arm a = this.arms[leg];
        switch (action) {
            case 0: {
                if (!a.alive) break;
                a.LoseContact();
                a.standing = false;
                a.jointAngles[0] = 1.0235987755982987;
                a.jointAngles[1] = 1.2566370614359172;
                break;
            }
            case 1: 
            case 3: {
                if (!a.alive) break;
                a.LoseContact();
                a.standing = false;
                double yaw = 0.5 * amplitude;
                if (leg < numArms / 2) {
                    yaw = -yaw;
                }
                if (action == 3) {
                    yaw = -yaw;
                }
                a.jointAngles[2] = 0.0 + yaw;
                a.jointAngles[0] = 1.0235987755982987;
                a.jointAngles[1] = 1.2566370614359172;
                break;
            }
            case 2: {
                if (!a.alive) break;
                a.LoseContact();
                a.jointAngles[0] = 1.0235987755982987;
                a.jointAngles[1] = 1.2566370614359172;
                a.jointAngles[2] = 0.0;
                a.standing = true;
                this.MakeFootContact(leg);
                return this.arms[leg].groundContact;
            }
            case 4: {
                if (!a.alive) break;
                a.standing = true;
                this.MakeFootContact(leg);
                return this.arms[leg].groundContact;
            }
            case 5: 
            case 6: {
                if (!a.alive) break;
                a.LoseContact();
                a.jointAngles[0] = 1.0235987755982987;
                a.jointAngles[1] = 1.2566370614359172;
                double yaw = 0.5 * amplitude;
                if (leg < numArms / 2) {
                    yaw = -yaw;
                }
                if (action == 6) {
                    yaw = -yaw;
                }
                a.jointAngles[2] = 0.0 + yaw;
                a.standing = true;
                this.MakeFootContact(leg);
                return this.arms[leg].groundContact;
            }
            case 7: 
            case 8: {
                if (!a.alive) break;
                a.LoseContact();
                a.jointAngles[0] = 1.0235987755982987;
                a.jointAngles[1] = 1.2566370614359172;
                double yaw = action == 7 ? -0.5 : 0.5;
                a.jointAngles[2] = 0.0 + yaw;
                a.standing = true;
                this.MakeFootContact(leg);
                return this.arms[leg].groundContact;
            }
        }
        return true;
    }

    void PositionPerception(Coord3 positionPerception, HPRRotation orientationPerception) {
        Coord3[] footPositions = new Coord3[numArms];
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double sxx = 0.0;
        double szz = 0.0;
        double sxz = 0.0;
        double sxy = 0.0;
        double syz = 0.0;
        int armsCounted = 0;
        int i = 0;
        while (i < numArms) {
            Arm a = this.arms[i];
            if (a.alive && a.groundContact) {
                footPositions[i] = a.ParentFootPos();
                double x = footPositions[i].xyz[0];
                double y = footPositions[i].xyz[1];
                double z = footPositions[i].xyz[2];
                sx += x;
                sy += y;
                sz += z;
                sxx += x * x;
                szz += z * z;
                sxy += x * y;
                sxz += x * z;
                syz += y * z;
                ++armsCounted;
            }
            ++i;
        }
        double d00 = (sxx /= (double)armsCounted) - (sx /= (double)armsCounted) * sx;
        double d01 = (sxz /= (double)armsCounted) - sx * (sz /= (double)armsCounted);
        double d11 = (szz /= (double)armsCounted) - sz * sz;
        double e0 = (sxy /= (double)armsCounted) - sx * (sy /= (double)armsCounted);
        double e1 = (syz /= (double)armsCounted) - sy * sz;
        double det = d00 * d11 - d01 * d01;
        double a = (d11 * e0 - d01 * e1) / det;
        double b = (-d01 * e0 + d00 * e1) / det;
        double basePitch = Math.atan2(-a, 1.0);
        double baseRoll = Math.atan2(b, 1.0);
        this.OldPositionPerception(positionPerception, orientationPerception);
        orientationPerception.pitch = basePitch;
        orientationPerception.roll = baseRoll;
    }

    void OldPositionPerception(Coord3 positionPerception, HPRRotation orientationPerception) {
        int usedArms = 0;
        double forwards = 0.0;
        double right = 0.0;
        double heading = 0.0;
        int i = 0;
        while (i < numArms / 2) {
            Arm leftArm = this.arms[i];
            if (leftArm.alive && leftArm.groundContact && leftArm.standing) {
                right += leftArm.jointAngles[1] - 1.2566370614359172;
                double yawExcess = leftArm.jointAngles[2] - 0.0;
                forwards += yawExcess;
                heading += yawExcess;
                ++usedArms;
            }
            Arm rightArm = this.arms[numArms - 1 - i];
            if (rightArm.alive && rightArm.groundContact && rightArm.standing) {
                right -= rightArm.jointAngles[1] - 1.2566370614359172;
                double yawExcess = rightArm.jointAngles[2] - 0.0;
                forwards -= yawExcess;
                heading += yawExcess;
                ++usedArms;
            }
            ++i;
        }
        if (usedArms > 0) {
            double armLength = (this.arms[0].upperLength + this.arms[0].lowerLength) / 2.0;
            forwards *= armLength / (double)usedArms;
            right *= armLength / (double)usedArms;
            heading /= (double)usedArms;
        }
        orientationPerception.heading = heading;
        HPRRotation bugHPR = this.orientation.toHPRRotation();
        orientationPerception.pitch = bugHPR.pitch;
        orientationPerception.roll = bugHPR.roll;
        positionPerception.xyz[1] = this.translation.xyz[1] - this.terrain.HeightAt(this.translation.xyz[0], this.translation.xyz[2]);
        positionPerception.xyz[0] = forwards;
        positionPerception.xyz[2] = right;
    }

    void UpdatePerceptionsFromBug() {
        Coord3 positionPerception = new Coord3();
        HPRRotation orientationPerception = new HPRRotation();
        this.PositionPerception(positionPerception, orientationPerception);
        this.bodyController[0].acceptPerception(positionPerception.xyz[1]);
        this.bodyController[1].acceptPerception(positionPerception.xyz[0]);
        this.bodyController[2].acceptPerception(positionPerception.xyz[2]);
        this.bodyController[3].acceptPerception(orientationPerception.heading);
        this.bodyController[4].acceptPerception(orientationPerception.pitch);
        this.bodyController[5].acceptPerception(orientationPerception.roll);
        int whichArm = 0;
        while (whichArm < numArms) {
            int whichJoint = 0;
            while (whichJoint < 3) {
                this.armJointVelController[whichArm][whichJoint].acceptPerception(this.arms[whichArm].jointAngleVelocities[whichJoint]);
                this.armJointAngleController[whichArm][whichJoint].acceptPerception(this.arms[whichArm].jointAngles[whichJoint]);
                ++whichJoint;
            }
            Arm a = this.arms[whichArm];
            if (a.groundContact && a.standing && a.alive) {
                this.footController[whichArm][1].acceptPerception(-this.arms[whichArm].outwardForce);
                this.footController[whichArm][0].acceptPerception(-this.arms[whichArm].transverseForce);
            } else {
                this.footController[whichArm][1].acceptPerception(0.0);
                this.footController[whichArm][0].acceptPerception(0.0);
            }
            ++whichArm;
        }
    }

    void setJointTorque(Arm a, int joint, double output, double weight, boolean add) {
        if (a.groundContact) {
            if (add) {
                int n = joint;
                a.jointTorques[n] = a.jointTorques[n] + output * weight;
            } else {
                a.jointTorques[joint] = output * weight;
            }
        }
    }

    void UpdateArmReactions() {
        int i = 0;
        while (i < numArms) {
            this.arms[i].UpdateReaction();
            ++i;
        }
    }

    void UpdateReaction() {
        this.UpdateArmReactions();
        Coord3 tF = new Coord3(0.0, -this.mass * 0.981, 0.0);
        Coord3 tT = new Coord3();
        int i = 0;
        while (i < numArms) {
            tF = tF.addCoord3(this.arms[i].reactionForce);
            tT = tT.addCoord3(this.arms[i].reactionTorque);
            ++i;
        }
        this.totalForce = tF.addCoord3(totalDisturbingForce);
        this.totalTorque = tT.addCoord3(totalDisturbingTorque);
    }

    Coord3 BugToParentTransformPosition(Coord3 v) {
        return this.translation.addCoord3(this.orientation.applyRotation(v));
    }

    Coord3 BugToParentRotateVector(Coord3 v) {
        return this.orientation.applyRotation(v);
    }

    Rotation BugToParentRotateRotation(Rotation r) {
        Coord3 r1 = r.toCoord3Rotation().rotation;
        Coord3 r2 = this.BugToParentRotateVector(r1);
        Coord3Rotation r3 = new Coord3Rotation(r2);
        return new Rotation(r3);
    }

    Coord3 ParentToBugTransform(Coord3 v) {
        return this.orientation.inverseRotation().applyRotation(v.subtractCoord3(this.translation));
    }

    double totalError() {
        double totErr = 0.0;
        int i = 0;
        while (i < 6) {
            if (this.bodyController[i].enabled) {
                totErr += Math.abs(this.bodyController[i].error());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < numArms) {
            if (this.arms[i2].alive) {
                Controller[] ajvcs = this.armJointVelController[i2];
                int j = 0;
                while (j < 3) {
                    Controller ajvc = ajvcs[j];
                    if (ajvc.enabled) {
                        totErr += Math.abs(ajvc.error());
                    }
                    ++j;
                }
                if (this.arms[i2].standing) {
                    Controller[] fcs = this.footController[i2];
                    Controller fc = fcs[0];
                    if (fc.enabled) {
                        totErr += Math.abs(fc.error());
                    }
                    fc = fcs[1];
                    if (fc.enabled) {
                        totErr += Math.abs(fc.error());
                    }
                } else {
                    int j2 = 0;
                    while (j2 < 3) {
                        Controller ajac = this.armJointAngleController[i2][j2];
                        if (ajac.enabled) {
                            totErr += Math.abs(ajac.error());
                        }
                        ++j2;
                    }
                }
            }
            ++i2;
        }
        return totErr;
    }

    void DrawArm(Arm a, Graphics g, Projection p) {
        g.setColor(a.alive ? (a.groundContact ? Color.black : orangeLeg) : Color.white);
        Coord3 shoulderPosition = this.BugToParentTransformPosition(a.translation);
        Coord3 elbowPosition = this.BugToParentTransformPosition(a.ParentElbowPos());
        p.DrawLine(g, shoulderPosition, elbowPosition);
        Coord3 footPosition = this.BugToParentTransformPosition(a.ParentFootPos());
        p.DrawLine(g, elbowPosition, footPosition);
        p.DrawBlob(g, shoulderPosition, 2.0);
        p.DrawBlob(g, elbowPosition, 2.0);
        p.DrawBlob(g, footPosition, 2.0);
    }

    void DrawVector(Graphics g, Projection p, Coord3 source, Coord3 target) {
        p.DrawLine(g, source, target);
        p.DrawBlob(g, target, 3.0);
    }

    void DrawLandmark(Graphics g, Projection p) {
        g.setColor(Color.black);
        p.DrawBlob(g, this.landmark, 10.0);
    }

    void DrawSelf(Graphics g, Projection p) {
        Color c = g.getColor();
        this.terrain.DrawSelf(g, p);
        Color lightBlue = new Color(127, 32, 255);
        p.DrawEllipsoid(g, this.size, this.translation, this.orientation, lightBlue, Color.blue, Color.blue);
        int i = 0;
        while (i < numArms) {
            this.DrawArm(this.arms[i], g, p);
            if (BugApplet.showForces) {
                g.setColor(Color.blue);
                this.DrawVector(g, p, this.BugToParentTransformPosition(this.arms[i].translation), this.BugToParentTransformPosition(this.arms[i].translation.addCoord3(this.arms[i].reactionForce.scaleCoord3(20.0))));
                g.setColor(new Color(32, 127, 32));
                this.DrawVector(g, p, this.BugToParentTransformPosition(this.arms[i].translation), this.BugToParentTransformPosition(this.arms[i].translation.addCoord3(this.arms[i].reactionTorque.scaleCoord3(1.0))));
            }
            ++i;
        }
        if (BugApplet.showForces) {
            g.setColor(Color.red);
            this.DrawVector(g, p, this.translation, this.BugToParentTransformPosition(this.totalForce.scaleCoord3(20.0)));
            g.setColor(Color.magenta);
            this.DrawVector(g, p, this.translation, this.BugToParentTransformPosition(this.totalTorque.scaleCoord3(1.0)));
            g.setColor(new Color(127, 32, 32));
            this.DrawVector(g, p, this.translation, this.BugToParentTransformPosition(totalDisturbingForce.scaleCoord3(20.0)));
            g.setColor(new Color(127, 32, 127));
            g.setColor(Color.magenta);
            this.DrawVector(g, p, this.translation, this.BugToParentTransformPosition(totalDisturbingTorque.scaleCoord3(1.0)));
        }
        g.setColor(c);
    }

    void UpdateControl() {
        this.UpdateControl(globalTime);
    }

    void UpdateControl(double time) {
        this.UpdatePerceptionsFromBug();
        this.ComputeNewOutputs(time);
        this.UpdateReaction();
    }

    void MakeFootContact(int i) {
        Arm a = this.arms[i];
        if (a.groundContact) {
            return;
        }
        Coord3 globalShoulderPos = this.translation.addCoord3(this.orientation.applyRotation(a.translation));
        double terrainHeight = this.terrain.HeightAt(globalShoulderPos.xyz[0], globalShoulderPos.xyz[2]);
        double shoulderHeight = globalShoulderPos.xyz[1] - terrainHeight;
        globalShoulderPos.xyz[1] = terrainHeight;
        if (shoulderHeight >= a.upperLength + a.lowerLength) {
            return;
        }
        Coord3 globalFootPos = this.BugToGlobal(a.ParentFootPos());
        a.groundContact = true;
        globalFootPos.xyz[1] = this.terrain.HeightAt(globalFootPos.xyz[0], globalFootPos.xyz[2]);
        a.SetFootPos(this.GlobalToBug(globalFootPos), 0.0);
        if (!a.groundContact) {
            Coord3 v = globalFootPos.subtractCoord3(globalShoulderPos);
            double legLength = a.upperLength + a.lowerLength;
            double maxReach = Math.sqrt(shoulderHeight * shoulderHeight + legLength * legLength);
            v = v.scaleCoord3(maxReach * 0.9);
            v.xyz[1] = shoulderHeight;
            a.SetFootPos(this.GlobalToBug(globalFootPos), 0.0);
        }
        if (a.groundContact && a.groundBox != null) {
            a.groundBox.setState(true);
        }
    }

    Coord3 GlobalToBug(Coord3 v) {
        return this.orientation.inverseRotation().applyRotation(v.subtractCoord3(this.translation));
    }

    Coord3 BugToGlobal(Coord3 v) {
        return this.orientation.applyRotation(v).addCoord3(this.translation);
    }

    Coord3 GlobalToArm(Arm a, Coord3 v) {
        return a.ParentToArmTransform(this.GlobalToBug(v));
    }

    Coord3 ArmToGlobal(Arm a, Coord3 v) {
        return this.GlobalToBug(a.ArmToParentTransform(v));
    }

    void ComputeNewOutputs(double time) {
        int i = 0;
        while (i < 6) {
            Controller c = this.bodyController[i];
            c.acceptTime(time);
            c.update();
            ++i;
        }
        int i2 = 0;
        while (i2 < numArms) {
            Controller[] cs = this.armJointAngleController[i2];
            int j = 0;
            while (j < 3) {
                Controller c = cs[j];
                c.acceptTime(time);
                c.update();
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < numArms) {
            int j;
            Controller[] cvs = this.armJointVelController[i3];
            if (this.arms[i3].standing) {
                j = 0;
                while (j < 3) {
                    double signal = 0.0;
                    int topC = 5;
                    while (topC >= 0) {
                        Controller tc = this.bodyController[topC];
                        double ow = outputCoefficients[i3][j][topC];
                        if (ow != 0.0 && tc.enabled) {
                            signal += ow * tc.output;
                        }
                        --topC;
                    }
                    Controller c = cvs[j];
                    c.acceptReference(signal);
                    c.acceptTime(time);
                    c.update();
                    ++j;
                }
            } else {
                j = 0;
                while (j < 3) {
                    Controller cv = cvs[j];
                    Controller ca = this.armJointAngleController[i3][j];
                    cv.acceptReference(ca.output);
                    cv.acceptTime(time);
                    cv.update();
                    ++j;
                }
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < numArms) {
            Controller[] cs = this.footController[i4];
            int j = 0;
            while (j < 2) {
                Controller c = cs[j];
                c.acceptTime(time);
                c.update();
                ++j;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < numArms) {
            Controller[] cs = this.armJointVelController[i5];
            Arm a = this.arms[i5];
            if (a.alive) {
                int j = 0;
                while (j < 3) {
                    if (cs[j].enabled) {
                        this.setJointTorque(a, j, cs[j].output, 1.0, false);
                    }
                    ++j;
                }
                if (a.groundContact && a.standing) {
                    Controller[] fcs = this.footController[i5];
                    if (fcs[0].enabled) {
                        this.setJointTorque(a, 2, fcs[0].output, 1.0, true);
                    }
                    if (fcs[1].enabled) {
                        this.setJointTorque(a, 1, fcs[1].output, 1.0, true);
                    }
                }
            }
            ++i5;
        }
    }

    void NewRandomDisturbingForce(double delta_t) {
        if (disturbLeakage > 0.0) {
            double diminution = Math.exp(-disturbLeakage * delta_t);
            double x = disturbForceScale * (1.0 - diminution) / Math.sqrt(disturbLeakage);
            randomDisturbingForce = new Coord3((Math.random() * 2.0 - 1.0) * x, (Math.random() * 2.0 - 1.0) * x, (Math.random() * 2.0 - 1.0) * x).addCoord3(randomDisturbingForce.scaleCoord3(diminution));
            totalDisturbingForce = constDisturbingForce.addCoord3(randomDisturbingForce);
        }
    }

    void NewRandomDisturbingTorque(double delta_t) {
        double x = disturbTorqueScale * disturbLeakage;
        randomDisturbingTorque = new Coord3((Math.random() * 2.0 - 1.0) * x, (Math.random() * 2.0 - 1.0) * x, (Math.random() * 2.0 - 1.0) * x).addCoord3(randomDisturbingTorque.scaleCoord3(1.0 - disturbLeakage));
        totalDisturbingTorque = constDisturbingTorque.addCoord3(randomDisturbingTorque);
    }

    void MoveBug(double delta_t) {
        globalTime += delta_t;
        this.UpdateControl();
        this.NewRandomDisturbingForce(delta_t);
        this.NewRandomDisturbingTorque(delta_t);
        double halfTsquared = delta_t * delta_t * 0.5;
        Coord3 acceleration = this.BugToParentRotateVector(this.totalForce).scaleCoord3(1.0 / this.mass);
        Coord3 new_v = this.velocity.addCoord3(acceleration.scaleCoord3(delta_t));
        Coord3 delta_xyz = this.velocity.scaleCoord3(delta_t).addCoord3(acceleration.scaleCoord3(halfTsquared));
        this.velocity = new_v;
        Coord3 new_translation = this.translation.addCoord3(delta_xyz);
        if (new_translation.xyz[1] > 200.0) {
            new_translation.xyz[1] = 200.0;
            this.velocity.xyz[1] = 0.0;
        }
        Coord3 ang_accel = this.BugToParentRotateVector(new Coord3(this.totalTorque.xyz[0] / (this.mass * this.moments.xyz[0]), this.totalTorque.xyz[1] / (this.mass * this.moments.xyz[1]), this.totalTorque.xyz[2] / (this.mass * this.moments.xyz[2])));
        Coord3 new_angvel = this.angularVelocity.addCoord3(ang_accel.scaleCoord3(delta_t));
        Coord3 delta_oC3 = this.angularVelocity.scaleCoord3(delta_t).addCoord3(ang_accel.scaleCoord3(halfTsquared));
        Rotation delta_o = new Rotation(new Coord3Rotation(delta_oC3));
        this.angularVelocity = new_angvel;
        Rotation new_orientation = delta_o.composeRotation(this.orientation);
        Coord3 semiX = new_orientation.applyRotation(new Coord3(this.size.xyz[0], 0.0, 0.0));
        Coord3 semiY = new_orientation.applyRotation(new Coord3(0.0, this.size.xyz[1], 0.0));
        Coord3 semiZ = new_orientation.applyRotation(new Coord3(0.0, 0.0, this.size.xyz[2]));
        Coord3 centreBase = new_translation.subtractCoord3(semiY);
        Coord3 edgeLoX = centreBase.subtractCoord3(semiX);
        Coord3 edgeHiX = centreBase.addCoord3(semiX);
        Coord3 cornerLoLo = edgeLoX.subtractCoord3(semiZ);
        Coord3 cornerLoHi = edgeLoX.addCoord3(semiZ);
        Coord3 cornerHiLo = edgeHiX.subtractCoord3(semiZ);
        Coord3 cornerHiHi = edgeHiX.addCoord3(semiZ);
        double heightLoLo = this.terrain.HeightAboveGround(cornerLoLo);
        double heightLoHi = this.terrain.HeightAboveGround(cornerLoHi);
        double heightHiLo = this.terrain.HeightAboveGround(cornerHiLo);
        double heightHiHi = this.terrain.HeightAboveGround(cornerHiHi);
        double heightFromGround = heightLoLo;
        if (heightFromGround > heightLoHi) {
            heightFromGround = heightLoHi;
        }
        if (heightFromGround > heightHiLo) {
            heightFromGround = heightHiLo;
        }
        if (heightFromGround > heightHiHi) {
            heightFromGround = heightHiHi;
        }
        boolean bl = this.groundCollision = heightFromGround < 0.0;
        if (this.groundCollision) {
            new_translation.xyz[1] = new_translation.xyz[1] - heightFromGround;
            this.velocity.xyz[1] = 0.0;
        }
        int i = 0;
        while (i < numArms) {
            Arm a = this.arms[i];
            if (a.alive) {
                if (a.standing) {
                    Coord3 oldGfp = a.ParentFootPos();
                    Coord3 oldGlobalFootPos = this.orientation.applyRotation(oldGfp).addCoord3(this.translation);
                    if (oldGlobalFootPos.xyz[1] < 0.0) {
                        oldGlobalFootPos.xyz[1] = 0.0;
                    }
                    Coord3 newBugFootPos = new_orientation.inverseRotation().applyRotation(oldGlobalFootPos.subtractCoord3(new_translation));
                    a.SetFootPos(newBugFootPos, delta_t);
                } else {
                    int j = 0;
                    while (j < 3) {
                        a.jointAngles[j] = JRKUtils.TrimDouble(Arm.minJointAngles[j], a.jointAngles[j] + a.jointTorques[j] * delta_t / 100.0, Arm.maxJointAngles[j]);
                        ++j;
                    }
                    Coord3 oldGfp = a.ParentFootPos();
                    Coord3 oldGlobalFootPos = new_orientation.applyRotation(oldGfp).addCoord3(new_translation);
                    if (oldGlobalFootPos.xyz[1] < 0.0) {
                        oldGlobalFootPos.xyz[1] = 0.0;
                        Coord3 newBugFootPos = new_orientation.inverseRotation().applyRotation(oldGlobalFootPos.subtractCoord3(new_translation));
                        a.groundContact = true;
                        a.SetFootPos(newBugFootPos, 0.0);
                    }
                }
            }
            ++i;
        }
        this.UpdateReaction();
        this.orientation = new_orientation;
        this.translation = new_translation;
    }

    static {
        double[][][] dArrayArray = new double[6][][];
        double[][] dArrayArray2 = new double[3][];
        double[] dArray = new double[4];
        dArray[0] = -1.0;
        dArrayArray2[0] = dArray;
        double[] dArray2 = new double[4];
        dArray2[0] = 1.0;
        dArrayArray2[1] = dArray2;
        dArrayArray2[2] = new double[4];
        dArrayArray[0] = dArrayArray2;
        double[][] dArrayArray3 = new double[3][];
        dArrayArray3[0] = new double[4];
        dArrayArray3[1] = new double[4];
        double[] dArray3 = new double[4];
        dArray3[2] = -1.0;
        dArrayArray3[2] = dArray3;
        dArrayArray[1] = dArrayArray3;
        double[][] dArrayArray4 = new double[3][];
        dArrayArray4[0] = new double[4];
        double[] dArray4 = new double[4];
        dArray4[2] = -1.0;
        dArrayArray4[1] = dArray4;
        dArrayArray4[2] = new double[4];
        dArrayArray[2] = dArrayArray4;
        double[][] dArrayArray5 = new double[3][];
        dArrayArray5[0] = new double[4];
        double[] dArray5 = new double[4];
        dArray5[3] = -1.0;
        dArrayArray5[1] = dArray5;
        dArrayArray5[2] = new double[4];
        dArrayArray[3] = dArrayArray5;
        double[][] dArrayArray6 = new double[3][];
        double[] dArray6 = new double[4];
        dArray6[1] = -1.0;
        dArrayArray6[0] = dArray6;
        double[] dArray7 = new double[4];
        dArray7[1] = 1.0;
        dArrayArray6[1] = dArray7;
        dArrayArray6[2] = new double[4];
        dArrayArray[4] = dArrayArray6;
        double[][] dArrayArray7 = new double[3][];
        double[] dArray8 = new double[4];
        dArray8[2] = 1.0;
        dArrayArray7[0] = dArray8;
        double[] dArray9 = new double[4];
        dArray9[2] = -1.0;
        dArrayArray7[1] = dArray9;
        dArrayArray7[2] = new double[4];
        dArrayArray[5] = dArrayArray7;
        outputTrends = dArrayArray;
        outputCoefficients = new double[numArms][3][6];
    }
}

