/*
 * Decompiled with CFR 0.152.
 */
class RotMatrix {
    Coord3[] cols;

    RotMatrix() {
        this.cols = new Coord3[3];
        this.cols[0] = new Coord3();
        this.cols[1] = new Coord3();
        this.cols[2] = new Coord3();
    }

    RotMatrix(Coord3 col0, Coord3 col1, Coord3 col2) {
        this.cols = new Coord3[3];
        this.cols[0] = col0;
        this.cols[1] = col1;
        this.cols[2] = col2;
    }

    RotMatrix(double x00, double x01, double x02, double x10, double x11, double x12, double x20, double x21, double x22) {
        this.cols = new Coord3[3];
        this.cols[0] = new Coord3(x00, x10, x20);
        this.cols[1] = new Coord3(x01, x11, x21);
        this.cols[2] = new Coord3(x02, x12, x22);
    }

    RotMatrix(HPRRotation hpr) {
        RotMatrix m = RotMatrix.HPRRotationToRotMatrix(hpr);
        this.cols = m.cols;
    }

    RotMatrix(Quaternion q) {
        this.cols = new Coord3[3];
        this.cols[0] = q.applyRotation(JRKUtils.xunit);
        this.cols[1] = q.applyRotation(JRKUtils.yunit);
        this.cols[2] = q.applyRotation(JRKUtils.zunit);
    }

    static RotMatrix HPRRotationToRotMatrix(HPRRotation hpr) {
        double ch = Math.cos(hpr.heading);
        double sh = Math.sin(hpr.heading);
        double cp = Math.cos(hpr.pitch);
        double sp = Math.sin(hpr.pitch);
        double cr = Math.cos(hpr.roll);
        double sr = Math.sin(hpr.roll);
        RotMatrix hRot = new RotMatrix(ch, 0.0, -sh, 0.0, 1.0, 0.0, sh, 0.0, ch);
        RotMatrix pRot = new RotMatrix(cp, -sp, 0.0, sp, cp, 0.0, 0.0, 0.0, 1.0);
        RotMatrix rRot = new RotMatrix(1.0, 0.0, 0.0, 0.0, cr, -sr, 0.0, sr, cr);
        return hRot.composeRotation(pRot.composeRotation(rRot));
    }

    double GetMatrixElement(int i, int j) {
        return this.cols[j].xyz[i];
    }

    void SetMatrixElement(int i, int j, double v) {
        this.cols[j].xyz[i] = v;
    }

    double Trace() {
        return this.cols[0].xyz[0] + this.cols[1].xyz[1] + this.cols[2].xyz[2];
    }

    Coord3 Row(int i) {
        return new Coord3(this.cols[0].xyz[i], this.cols[1].xyz[i], this.cols[2].xyz[i]);
    }

    Coord3 RotAxis() {
        int k;
        int j;
        double c = (this.Trace() - 1.0) * 0.5;
        if (c == 1.0) {
            return new Coord3(0.0, 0.0, 1.0);
        }
        if (this.cols[1].xyz[1] < this.cols[0].xyz[0]) {
            if (this.cols[2].xyz[2] < this.cols[0].xyz[0]) {
                j = 1;
                k = 2;
            } else {
                j = 0;
                k = 1;
            }
        } else if (this.cols[2].xyz[2] < this.cols[1].xyz[1]) {
            j = 2;
            k = 0;
        } else {
            j = 0;
            k = 1;
        }
        Coord3 sj = this.Row(j);
        int n = j;
        sj.xyz[n] = sj.xyz[n] - 1.0;
        Coord3 sk = this.Row(k);
        int n2 = k;
        sk.xyz[n2] = sk.xyz[n2] - 1.0;
        Coord3 axis = sj.crossProduct(sk).unitVector();
        return axis;
    }

    double RotAngle() {
        double c = (this.Trace() - 1.0) * 0.5;
        if (c == 1.0) {
            return 0.0;
        }
        Coord3 axis = this.RotAxis();
        double ax = Math.abs(axis.xyz[0]);
        double ay = Math.abs(axis.xyz[1]);
        double az = Math.abs(axis.xyz[2]);
        int maxcoord = ax > ay ? (ax > az ? 0 : 2) : (ay > az ? 1 : 2);
        int j = (maxcoord + 1) % 3;
        int k = (j + 1) % 3;
        double s = (this.cols[j].xyz[k] - this.cols[k].xyz[j]) / (2.0 * axis.xyz[maxcoord]);
        double angle = Math.atan2(s, c);
        return angle;
    }

    Coord3 applyRotation(Coord3 s) {
        Coord3 v = new Coord3();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int n = i;
                v.xyz[n] = v.xyz[n] + s.xyz[j] * this.cols[j].xyz[i];
                ++j;
            }
            ++i;
        }
        return v;
    }

    RotMatrix composeRotation(RotMatrix m) {
        RotMatrix newm = new RotMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int n = i;
                    newm.cols[j].xyz[n] = newm.cols[j].xyz[n] + this.cols[k].xyz[i] * m.cols[j].xyz[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newm;
    }

    RotMatrix inverseRotation() {
        RotMatrix newm = new RotMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                newm.cols[j].xyz[i] = this.cols[i].xyz[j];
                ++j;
            }
            ++i;
        }
        return newm;
    }

    String makeString() {
        return "(" + this.Row(0).makeString() + "\n" + this.Row(1).makeString() + "\n" + this.Row(2).makeString() + ")";
    }
}

