/*
 * Decompiled with CFR 0.152.
 */
class VRMLRotation {
    Coord3 axis;
    double angle;

    VRMLRotation(double x, double y, double z, double theta) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            z = 1.0;
        }
        this.axis = new Coord3(x, y, z);
        this.angle = theta;
    }

    VRMLRotation() {
        this.axis = new Coord3(0.0, 0.0, 1.0);
        this.angle = 0.0;
    }

    VRMLRotation(Coord3 v, double theta) {
        this.axis = v;
        this.angle = theta;
    }

    VRMLRotation(Coord3Rotation c) {
        this.axis = c.RotAxis();
        this.angle = c.RotAngle();
    }

    VRMLRotation(RotMatrix m) {
        int k;
        int j;
        double c = (m.Trace() - 1.0) * 0.5;
        if (c == 1.0) {
            this.axis = JRKUtils.zunit;
            this.angle = 0.0;
            return;
        }
        if (m.cols[1].xyz[1] < m.cols[0].xyz[0]) {
            if (m.cols[2].xyz[2] < m.cols[0].xyz[0]) {
                j = 1;
                k = 2;
            } else {
                j = 0;
                k = 1;
            }
        } else if (m.cols[2].xyz[2] < m.cols[1].xyz[1]) {
            j = 2;
            k = 0;
        } else {
            j = 0;
            k = 1;
        }
        Coord3 sj = m.Row(j);
        int n = j;
        sj.xyz[n] = sj.xyz[n] - 1.0;
        Coord3 sk = m.Row(k);
        int n2 = k;
        sk.xyz[n2] = sk.xyz[n2] - 1.0;
        this.axis = sj.crossProduct(sk).unitVector();
        double ax = Math.abs(this.axis.xyz[0]);
        double ay = Math.abs(this.axis.xyz[1]);
        double az = Math.abs(this.axis.xyz[2]);
        int maxcoord = ax > ay ? (ax > az ? 0 : 2) : (ay > az ? 1 : 2);
        j = (maxcoord + 1) % 3;
        k = (j + 1) % 3;
        double s = (m.cols[j].xyz[k] - m.cols[k].xyz[j]) / (2.0 * this.axis.xyz[maxcoord]);
        this.angle = Math.atan2(s, c);
    }

    VRMLRotation(Quaternion q) {
        this.axis = q.RotAxis();
        this.angle = q.RotAngle();
    }

    String makeString() {
        return String.valueOf(this.axis.makeString()) + "[" + JRKUtils.DoubleToString(this.angle, 3) + "]";
    }

    Coord3 RotAxis() {
        return this.axis;
    }

    double RotAngle() {
        return this.angle;
    }

    Coord3 applyRotation(Coord3 s) {
        if (this.angle == 0.0) {
            return s;
        }
        Coord3 unitAxis = this.axis.unitVector();
        Coord3 cp = unitAxis.crossProduct(s);
        if (cp.length() == 0.0) {
            return s;
        }
        double dp = unitAxis.dotProduct(s);
        Coord3 parallelComponent = unitAxis.scaleCoord3(dp);
        Coord3 perpComponent = s.subtractCoord3(parallelComponent).scaleCoord3(Math.cos(this.angle));
        Coord3 thirdComponent = cp.scaleCoord3(Math.sin(this.angle));
        return parallelComponent.addCoord3(perpComponent).addCoord3(thirdComponent);
    }

    VRMLRotation inverseRotation() {
        return new VRMLRotation(this.axis, -this.angle);
    }
}

