/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class Projection {
    Coord3 v;
    Coord3 i;
    Coord3 j;
    static final double VERYBIG = 1.0;
    double vv;
    double scale;

    Projection(Coord3 v0, double s) {
        this.initialise(v0, s);
    }

    Projection() {
        this.initialise(new Coord3(10.0, 10.0, 10.0), 40.0);
    }

    void initialise(Coord3 v0, double s) {
        this.v = v0;
        this.i = new Coord3(v0.xyz[2], 0.0, -v0.xyz[0]).unitVector();
        this.j = this.i.crossProduct(v0).unitVector();
        this.vv = v0.dotProduct(v0);
        this.scale = s;
    }

    public Coord2 Project(Coord3 x) {
        double xv = x.dotProduct(this.v);
        double xi = x.dotProduct(this.i);
        double xj = x.dotProduct(this.j);
        Coord2 result = new Coord2(xi, xj);
        result = result.scaleCoord2(this.vv > xv ? this.vv / (this.vv - xv) : 1.0);
        return result;
    }

    public void DrawLine(Graphics g, Coord3 fromPoint, Coord3 toPoint) {
        Coord2.DrawLine(g, this.Project(fromPoint).scaleCoord2(this.scale), this.Project(toPoint).scaleCoord2(this.scale));
    }

    public void DrawBlob(Graphics g, Coord3 atPoint, double diameter) {
        double xv = atPoint.dotProduct(this.v);
        if (this.vv <= xv) {
            return;
        }
        double a = this.vv / (this.vv - xv);
        Coord2 centre2d = new Coord2(atPoint.dotProduct(this.i), atPoint.dotProduct(this.j)).scaleCoord2(a);
        double diameter2d = diameter * a;
        g.fillOval((int)(this.scale * (centre2d.x - diameter2d / 2.0)), (int)(this.scale * (centre2d.y - diameter2d / 2.0)), (int)(this.scale * diameter2d), (int)(this.scale * diameter2d));
    }

    public void DrawEllipsoid(Graphics g, Coord3 size, Coord3 translation, Rotation orientation, Color front, Color sides, Color back) {
        double a = size.xyz[0];
        double b = size.xyz[1];
        double c = size.xyz[2];
        g.setColor(sides);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        g.setColor(front);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        g.setColor(back);
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
    }
}

