/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class OscilloscopeCanvas
extends Canvas {
    static final int MAXCHANNELLENGTH = 1000;
    static final int MAXCHANNELS = 8;
    static Color[] channelColors = new Color[]{Color.green, Color.blue, Color.red, Color.magenta, Color.white, Color.black, Color.orange, Color.pink};
    static final int CHANNEL_0 = 0;
    static final int CHANNEL_1 = 1;
    static final int CHANNEL_2 = 2;
    static final int CHANNEL_3 = 3;
    static final int CHANNEL_4 = 4;
    static final int CHANNEL_5 = 5;
    static final int CHANNEL_6 = 6;
    static final int CHANNEL_7 = 7;
    Bug theBug;
    double timeBase = 10.0;
    boolean completeScan = false;
    double[][] dataY;
    int channelLength = 0;
    int channelPos = 0;
    double[] channelScale = new double[]{80.0, 4.0, 30.0, 12.0, 10.0, 2.0, 2.0, 2.0};
    boolean[] channelDisplay;

    OscilloscopeCanvas(Bug b) {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        this.channelDisplay = blArray;
        this.theBug = b;
        this.initOscilloscope();
    }

    OscilloscopeCanvas(Bug b, double delta_t) {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        this.channelDisplay = blArray;
        this.theBug = b;
        this.channelLength = (int)(this.timeBase / delta_t);
        this.initOscilloscope();
    }

    public void initOscilloscope() {
        this.dataY = new double[8][];
        this.completeScan = false;
        this.channelPos = 0;
    }

    public void clear() {
        this.initOscilloscope();
        this.repaint();
    }

    public void paint(Graphics g) {
        this.plotData(g);
    }

    public void stepTime() {
        Graphics g = this.getGraphics();
        this.plotTime(g, this.getBackground());
        this.channelPos = (this.channelPos + 1) % this.channelLength;
        this.plotTime(g, Color.black);
    }

    public void plotTime(Graphics g, Color c) {
        int h = this.getSize().height;
        g.setColor(c);
        int it = (int)((double)(this.channelPos * this.getSize().width) / (double)this.channelLength);
        g.drawLine(it, h - 4, it, h);
    }

    public void acceptPoint(int channel, double v) {
        if (channel < 0 || channel >= 8) {
            return;
        }
        if (this.dataY[channel] == null) {
            this.dataY[channel] = new double[this.channelLength];
        }
        double newValue = v / this.channelScale[channel];
        if (this.channelDisplay[channel]) {
            this.plotPoint(this.getGraphics(), this.channelPos, this.dataY[channel][this.channelPos], this.getBackground());
            this.plotPoint(this.getGraphics(), this.channelPos, newValue, channelColors[channel]);
        }
        this.dataY[channel][this.channelPos] = newValue;
    }

    public void enableChannel(int ch, boolean on) {
        if (this.channelDisplay[ch] != on) {
            this.channelDisplay[ch] = on;
            double[] values = this.dataY[ch];
            if (values != null) {
                Graphics g = this.getGraphics();
                g.setColor(on ? channelColors[ch] : Color.gray);
                int t = 0;
                while (t < this.channelLength) {
                    this.plotPoint(g, t, values[t]);
                    ++t;
                }
            }
        }
    }

    private void plotPoint(Graphics g, int t, double v) {
        int it = (int)((double)(t * this.getSize().width) / (double)this.channelLength);
        int iv = (int)((0.5 - v) * (double)this.getSize().height);
        g.drawLine(it, iv, it, iv);
    }

    private void plotPoint(Graphics g, int t, double v, Color c) {
        g.setColor(c);
        this.plotPoint(g, t, v);
    }

    private void plotAxes(Graphics g) {
        g.setColor(Color.darkGray);
        g.drawLine(0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
        g.drawLine(0, 0, 0, this.getSize().height);
    }

    private void plotData(Graphics g) {
        int i = 0;
        while (i < 8) {
            double[] v;
            if (this.channelDisplay[i] && (v = this.dataY[i]) != null) {
                g.setColor(channelColors[i]);
                int t = 0;
                while (t < this.channelLength) {
                    this.plotPoint(g, t, v[t]);
                    ++t;
                }
            }
            ++i;
        }
        this.plotTime(g, Color.black);
    }
}

