/*
 * Decompiled with CFR 0.152.
 */
class Coord3Rotation {
    Coord3 rotation;

    Coord3Rotation(double x, double y, double z) {
        this.rotation = new Coord3(x, y, z);
    }

    Coord3Rotation(Coord3 v) {
        this.rotation = v;
    }

    Coord3Rotation() {
        this.rotation = new Coord3(0.0, 0.0, 0.0);
    }

    Coord3Rotation(Quaternion q) {
        this.rotation = q.RotAxis().scaleCoord3(q.RotAngle());
    }

    Coord3Rotation(VRMLRotation v) {
        this.rotation = v.axis.scaleCoord3(v.angle);
    }

    String makeString() {
        return this.rotation.makeString();
    }

    static double normaliseAngle(double angle) {
        boolean positive = angle >= 0.0;
        double a = positive ? angle : -angle;
        double result = a - (double)((int)((a + Math.PI) / (Math.PI * 2))) * (Math.PI * 2);
        return positive ? result : (result == Math.PI ? result : -result);
    }

    Coord3 RotAxis() {
        double length = this.rotation.length();
        return length == 0.0 ? new Coord3(0.0, 0.0, 0.0) : this.rotation.scaleCoord3(1.0 / length);
    }

    double RotAngle() {
        return Coord3Rotation.normaliseAngle(this.rotation.length());
    }

    Coord3Rotation inverseRotation() {
        return new Coord3Rotation(this.rotation.scaleCoord3(-1.0));
    }
}

