/*
 * Decompiled with CFR 0.152.
 */
class Coord3 {
    double[] xyz;
    static final int FORWARDS = 0;
    static final int HEIGHT = 1;
    static final int RIGHTWARDS = 2;

    Coord3(double x, double y, double z) {
        this.xyz = new double[3];
        this.xyz[0] = x;
        this.xyz[1] = y;
        this.xyz[2] = z;
    }

    Coord3() {
        this.xyz = new double[4];
        this.xyz[0] = 0.0;
        this.xyz[1] = 0.0;
        this.xyz[2] = 0.0;
    }

    String makeString() {
        return "(" + JRKUtils.DoubleToString(this.xyz[0], 3) + "," + JRKUtils.DoubleToString(this.xyz[1], 3) + "," + JRKUtils.DoubleToString(this.xyz[2], 3) + ")";
    }

    double lengthSquared() {
        return this.xyz[0] * this.xyz[0] + this.xyz[1] * this.xyz[1] + this.xyz[2] * this.xyz[2];
    }

    double length() {
        return Math.sqrt(this.lengthSquared());
    }

    Coord3 unitVector() {
        double l = this.length();
        if (l == 0.0) {
            return this;
        }
        return this.scaleCoord3(1.0 / l);
    }

    Coord3 addCoord3(Coord3 v) {
        return new Coord3(this.xyz[0] + v.xyz[0], this.xyz[1] + v.xyz[1], this.xyz[2] + v.xyz[2]);
    }

    Coord3 subtractCoord3(Coord3 v) {
        return new Coord3(this.xyz[0] - v.xyz[0], this.xyz[1] - v.xyz[1], this.xyz[2] - v.xyz[2]);
    }

    Coord3 scaleCoord3(double scale) {
        return new Coord3(this.xyz[0] * scale, this.xyz[1] * scale, this.xyz[2] * scale);
    }

    double dotProduct(Coord3 v) {
        return this.xyz[0] * v.xyz[0] + this.xyz[1] * v.xyz[1] + this.xyz[2] * v.xyz[2];
    }

    Coord3 crossProduct(Coord3 v) {
        return new Coord3(this.xyz[1] * v.xyz[2] - this.xyz[2] * v.xyz[1], this.xyz[2] * v.xyz[0] - this.xyz[0] * v.xyz[2], this.xyz[0] * v.xyz[1] - this.xyz[1] * v.xyz[0]);
    }
}

