/*
 * Decompiled with CFR 0.152.
 */
class VRMLRotation {
    Coord3 axis;
    double angle;

    VRMLRotation(double x, double y, double z, double theta) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            z = 1.0;
        }
        this.axis = new Coord3(x, y, z);
        this.angle = theta;
    }

    VRMLRotation() {
        this.axis = new Coord3(0.0, 0.0, 1.0);
        this.angle = 0.0;
    }

    VRMLRotation(Coord3 v, double theta) {
        this.axis = v;
        this.angle = theta;
    }

    VRMLRotation(Coord3Rotation v) {
        this.axis = v.RotAxis();
        this.angle = v.RotAngle();
    }

    VRMLRotation(Quaternion q) {
        this.axis = q.RotAxis();
        this.angle = q.RotAngle();
    }

    VRMLRotation(RotMatrix m) {
        this.axis = m.RotAxis();
        this.angle = m.RotAngle();
    }

    String makeString() {
        return String.valueOf(this.axis.makeString()) + "[" + this.angle + "]";
    }

    Coord3Rotation toCoord3Rotation() {
        return new Coord3Rotation(this);
    }

    Quaternion toQuaternion() {
        return new Quaternion(this);
    }

    RotMatrix toRotMatrix() {
        return new RotMatrix(this);
    }

    Coord3 RotAxis() {
        return this.axis;
    }

    double RotAngle() {
        return this.angle;
    }

    Coord3 applyRotation(Coord3 s) {
        if (this.angle == 0.0) {
            return s;
        }
        Coord3 unitAxis = this.axis.unitVector();
        Coord3 cp = unitAxis.crossProduct(s);
        if (cp.length() == 0.0) {
            return s;
        }
        double dp = unitAxis.dotProduct(s);
        Coord3 parallelComponent = unitAxis.scaleCoord3(dp);
        Coord3 perpComponent = s.subtractCoord3(parallelComponent).scaleCoord3(Math.cos(this.angle));
        Coord3 thirdComponent = cp.scaleCoord3(Math.sin(this.angle));
        return parallelComponent.addCoord3(perpComponent).addCoord3(thirdComponent);
    }

    VRMLRotation composeRotation(VRMLRotation q) {
        return this.toQuaternion().composeRotation(q.toQuaternion()).toVRMLRotation();
    }

    VRMLRotation inverseRotation() {
        return new VRMLRotation(this.axis, -this.angle);
    }
}

