/*
 * Decompiled with CFR 0.152.
 */
class RotMatrix {
    Coord3[] cols;

    RotMatrix() {
        this.cols = new Coord3[3];
        this.cols[0] = new Coord3();
        this.cols[1] = new Coord3();
        this.cols[2] = new Coord3();
    }

    RotMatrix(Coord3 col0, Coord3 col1, Coord3 col2) {
        this.cols = new Coord3[3];
        this.cols[0] = col0;
        this.cols[1] = col1;
        this.cols[2] = col2;
    }

    RotMatrix(Coord3 diag) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.cols[i].xyz[j] = i == j ? diag.xyz[i] : 0.0;
                ++j;
            }
            ++i;
        }
    }

    RotMatrix(Coord3Rotation v) {
        RotMatrix m = RotMatrix.QuaternionToRotMatrix(new Quaternion(v));
        this.cols = m.cols;
    }

    RotMatrix(HPRRotation hpr) {
        RotMatrix hRot = new RotMatrix(new Coord3(Math.cos(hpr.heading), 0.0, -Math.sin(hpr.heading)), new Coord3(0.0, 1.0, 0.0), new Coord3(Math.sin(hpr.heading), 0.0, Math.cos(hpr.heading)));
        RotMatrix pRot = new RotMatrix(new Coord3(Math.cos(hpr.heading), Math.sin(hpr.heading), 0.0), new Coord3(-Math.sin(hpr.heading), Math.cos(hpr.heading), 0.0), new Coord3(0.0, 0.0, 1.0));
        RotMatrix rRot = new RotMatrix(new Coord3(1.0, 0.0, 0.0), new Coord3(0.0, Math.cos(hpr.heading), Math.sin(hpr.heading)), new Coord3(0.0, -Math.sin(hpr.heading), Math.cos(hpr.heading)));
        RotMatrix m = hRot.composeRotation(pRot.composeRotation(rRot));
        this.cols = m.cols;
    }

    RotMatrix(Quaternion q) {
        RotMatrix m = RotMatrix.QuaternionToRotMatrix(q);
        this.cols = m.cols;
    }

    RotMatrix(VRMLRotation v) {
        RotMatrix m = RotMatrix.QuaternionToRotMatrix(new Quaternion(v));
        this.cols = m.cols;
    }

    double GetMatrixElement(int i, int j) {
        return this.cols[j].xyz[i];
    }

    void SetMatrixElement(int i, int j, double v) {
        this.cols[j].xyz[i] = v;
    }

    static RotMatrix QuaternionToRotMatrix(Quaternion q) {
        Coord3[] cols = new Coord3[3];
        int i = 0;
        while (i < 3) {
            cols[i] = new Coord3();
            ++i;
        }
        int i2 = 0;
        while (i2 < 3) {
            int j = (i2 + 1) % 3;
            int k = (i2 + 2) % 3;
            cols[i2].xyz[i2] = q.phase * q.phase + q.qaxis.xyz[i2] * q.qaxis.xyz[i2] - q.qaxis.xyz[j] * q.qaxis.xyz[j] - q.qaxis.xyz[k] * q.qaxis.xyz[k];
            cols[j].xyz[i2] = 2.0 * (q.qaxis.xyz[i2] * q.qaxis.xyz[j] + q.qaxis.xyz[k] * q.phase);
            cols[k].xyz[i2] = 2.0 * (q.qaxis.xyz[i2] * q.qaxis.xyz[k] - q.qaxis.xyz[j] * q.phase);
            ++i2;
        }
        return new RotMatrix(cols[0], cols[1], cols[2]);
    }

    Coord3Rotation toCoord3Rotation() {
        return new Coord3Rotation(this.RotAxis().scaleCoord3(this.RotAngle()));
    }

    Quaternion toQuaternion() {
        return this.toVRMLRotation().toQuaternion();
    }

    VRMLRotation toVRMLRotation() {
        return new VRMLRotation(this.RotAxis(), this.RotAngle());
    }

    double Trace() {
        return this.cols[0].xyz[0] + this.cols[1].xyz[1] + this.cols[2].xyz[2];
    }

    Coord3 Row(int i) {
        return new Coord3(this.cols[0].xyz[i], this.cols[1].xyz[i], this.cols[2].xyz[i]);
    }

    Coord3 RotAxis() {
        double c = (this.Trace() - 1.0) * 0.5;
        if (c == 1.0) {
            return new Coord3(0.0, 0.0, 1.0);
        }
        int i = 0;
        int j = 1;
        int k = 2;
        if (this.cols[1].xyz[1] > this.cols[0].xyz[0]) {
            i = 1;
            j = 2;
            k = 0;
        }
        if (this.cols[2].xyz[2] > this.cols[1].xyz[1]) {
            i = 2;
            j = 0;
            k = 1;
        }
        Coord3 sj = this.Row(j);
        int n = j;
        sj.xyz[n] = sj.xyz[n] - 1.0;
        Coord3 sk = this.Row(k);
        int n2 = k;
        sk.xyz[n2] = sk.xyz[n2] - 1.0;
        Coord3 m = sj.crossProduct(sk);
        return m.unitVector();
    }

    double RotAngle() {
        double c = (this.Trace() - 1.0) * 0.5;
        if (c == 1.0) {
            return 0.0;
        }
        Coord3 a = new Coord3(this.cols[2].xyz[1] - this.cols[1].xyz[2], this.cols[0].xyz[2] - this.cols[2].xyz[0], this.cols[1].xyz[0] - this.cols[0].xyz[1]);
        double s = a.length() * 0.5;
        return Math.atan2(s, c);
    }

    Coord3 applyRotation(Coord3 s) {
        Coord3 v = new Coord3();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int n = i;
                v.xyz[n] = v.xyz[n] + s.xyz[j] * this.cols[j].xyz[i];
                ++j;
            }
            ++i;
        }
        return v;
    }

    RotMatrix composeRotation(RotMatrix m) {
        RotMatrix newm = new RotMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    newm.cols[j].xyz[i] = m.cols[j].xyz[k] * this.cols[k].xyz[i];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newm;
    }

    RotMatrix inverseRotation(RotMatrix m) {
        RotMatrix newm = new RotMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                newm.cols[j].xyz[i] = m.cols[i].xyz[j];
                ++j;
            }
            ++i;
        }
        return newm;
    }
}

