/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

class Projection {
    Coord3 v;
    Coord3 i;
    Coord3 j;
    static final double VERYBIG = 1.0;
    double vv;
    double scale;

    Projection(Coord3 v0, double s) {
        this.initialise(v0, s);
    }

    Projection() {
        this.initialise(new Coord3(10.0, 10.0, 10.0), 40.0);
    }

    void initialise(Coord3 v0, double s) {
        this.v = v0;
        this.i = new Coord3(v0.xyz[2], 0.0, -v0.xyz[0]).unitVector();
        this.j = this.i.crossProduct(v0).unitVector();
        this.vv = v0.dotProduct(v0);
        this.scale = s;
    }

    public Coord2 Project(Coord3 x) {
        double xv = x.dotProduct(this.v);
        return new Coord2(x.dotProduct(this.i), x.dotProduct(this.j)).scaleCoord2(this.vv > xv ? this.vv / (this.vv - xv) : 1.0);
    }

    public void DrawLine(Graphics g, Coord3 fromPoint, Coord3 toPoint) {
        Coord2.DrawLine(g, this.Project(fromPoint).scaleCoord2(this.scale), this.Project(toPoint).scaleCoord2(this.scale));
    }

    public void DrawBlob(Graphics g, Coord3 atPoint, double diameter) {
        double xv = atPoint.dotProduct(this.v);
        if (this.vv <= xv) {
            return;
        }
        double a = this.vv / (this.vv - xv);
        Coord2 centre2d = new Coord2(atPoint.dotProduct(this.i), atPoint.dotProduct(this.j)).scaleCoord2(a);
        double diameter2d = diameter * a;
        g.fillOval((int)(this.scale * (centre2d.x - diameter2d / 2.0)), (int)(this.scale * (centre2d.y - diameter2d / 2.0)), (int)(this.scale * diameter2d), (int)(this.scale * diameter2d));
    }

    public void DrawEllipsoid(Graphics g, Coord3 size, Coord3 translation, Rotation orientation) {
        double a = size.xyz[0];
        double b = size.xyz[1];
        double c = size.xyz[2];
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(a, -b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, b, -c))));
        this.DrawLine(g, translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, c))), translation.addCoord3(orientation.applyRotation(new Coord3(-a, -b, -c))));
    }
}

