/*
 * Decompiled with CFR 0.152.
 */
class Coord3Rotation {
    Coord3 rotation;

    Coord3Rotation(double x, double y, double z) {
        this.rotation = new Coord3(x, y, z);
    }

    Coord3Rotation(Coord3 v) {
        this.rotation = v;
    }

    Coord3Rotation() {
        this.rotation = new Coord3(0.0, 0.0, 0.0);
    }

    Coord3Rotation(VRMLRotation v) {
        this.rotation = v.RotAxis();
        double angle = v.RotAngle();
        if (angle != 0.0) {
            this.rotation = this.rotation.scaleCoord3(angle);
        }
    }

    Coord3Rotation(Quaternion q) {
        this.rotation = q.RotAxis();
        double angle = q.RotAngle();
        if (angle != 0.0) {
            this.rotation = this.rotation.scaleCoord3(angle);
        }
    }

    Coord3Rotation(RotMatrix m) {
        this.rotation = m.RotAxis();
        double angle = m.RotAngle();
        if (angle != 0.0) {
            this.rotation = this.rotation.scaleCoord3(angle);
        }
    }

    String makeString() {
        return this.rotation.makeString();
    }

    VRMLRotation toVRMLRotation() {
        return new VRMLRotation(this);
    }

    Quaternion toQuaternion() {
        return new Quaternion(this);
    }

    RotMatrix toRotMatrix() {
        return new RotMatrix(this);
    }

    static double normaliseAngle(double angle) {
        boolean positive = angle >= 0.0;
        double a = positive ? angle : -angle;
        double result = a - (double)((int)((a + Math.PI) / (Math.PI * 2))) * (Math.PI * 2);
        return positive ? result : (result == Math.PI ? result : -result);
    }

    Coord3 RotAxis() {
        double length = this.rotation.length();
        return length == 0.0 ? new Coord3(0.0, 0.0, 0.0) : this.rotation.scaleCoord3(1.0 / length);
    }

    double RotAngle() {
        return Coord3Rotation.normaliseAngle(this.rotation.length());
    }

    Coord3 applyRotation(Coord3 s) {
        return this.toVRMLRotation().applyRotation(s);
    }

    VRMLRotation composeRotation(VRMLRotation q) {
        return this.toQuaternion().composeRotation(q.toQuaternion()).toVRMLRotation();
    }

    Coord3Rotation inverseRotation() {
        return new Coord3Rotation(this.rotation.scaleCoord3(-1.0));
    }
}

