/*
 * Decompiled with CFR 0.152.
 */
abstract class Controller {
    double perception = 0.0;
    double reference = 0.0;
    double output = 0.0;
    double time = 0.0;
    boolean enabled = true;
    protected double previousTime = 0.0;
    protected double previousError = 0.0;
    protected double accumulatedError = 0.0;
    protected double previousAccumulatedError = 0.0;

    void acceptReference(double newRefValue) {
        this.reference = newRefValue;
    }

    void acceptPerception(double newPerception) {
        this.perception = newPerception;
    }

    void acceptTime(double newTime) {
        if (newTime > this.previousTime) {
            this.time = newTime;
        }
    }

    void enable(boolean becomeEnabled) {
        if (this.enabled != becomeEnabled) {
            this.enabled = becomeEnabled;
            if (!this.enabled) {
                this.previousError = 0.0;
                this.accumulatedError = 0.0;
                this.previousAccumulatedError = 0.0;
            }
        }
    }

    void update() {
        if (this.time > this.previousTime) {
            this.outputFunction();
            this.previousAccumulatedError = this.accumulatedError;
            this.previousError = this.error();
            this.previousTime = this.time;
        }
    }

    public double error() {
        return this.enabled ? this.perception - this.reference : 0.0;
    }

    abstract void outputFunction();

    Controller() {
    }
}

