/*
 * Decompiled with CFR 0.152.
 */
class Rotation {
    private Quaternion quaternion;

    Rotation() {
        this.quaternion = new Quaternion();
    }

    Rotation(Coord3Rotation v) {
        this.quaternion = new Quaternion(v);
    }

    Rotation(HPRRotation hpr) {
        this.quaternion = new Quaternion(new RotMatrix(hpr));
    }

    Rotation(Quaternion q) {
        this.quaternion = q;
    }

    Rotation(VRMLRotation v) {
        this.quaternion = new Quaternion(v);
    }

    Rotation(RotMatrix m) {
        this.quaternion = new Quaternion(m);
    }

    String makeString() {
        return this.quaternion.makeString();
    }

    Coord3Rotation toCoord3Rotation() {
        return this.quaternion.toCoord3Rotation();
    }

    Quaternion toQuaternion() {
        return this.quaternion;
    }

    VRMLRotation toVRMLRotation() {
        return this.quaternion.toVRMLRotation();
    }

    RotMatrix toRotMatrix() {
        return this.quaternion.toRotMatrix();
    }

    HPRRotation toHPRRotation() {
        double roll;
        double pitch;
        double heading;
        Coord3 vx = this.applyRotation(new Coord3(1.0, 0.0, 0.0));
        Coord3 vz = this.applyRotation(new Coord3(0.0, 0.0, 1.0));
        double vert = -vx.xyz[2];
        double horiz = vx.xyz[0];
        if (vert == 0.0 && horiz == 0.0) {
            heading = Math.atan2(-vz.xyz[2], vz.xyz[0]);
            pitch = (vx.xyz[1] > 0.0 ? Math.PI : -Math.PI) / 2.0;
            roll = 0.0;
        } else {
            heading = Math.atan2(vert, horiz);
            pitch = Math.asin(vx.xyz[1]);
            roll = vz.xyz[1] / Math.cos(pitch);
        }
        return new HPRRotation(heading, pitch, roll);
    }

    Coord3 RotAxis() {
        return this.quaternion.RotAxis();
    }

    double RotAngle() {
        return this.quaternion.RotAngle();
    }

    Coord3 applyRotation(Coord3 s) {
        return this.quaternion.applyRotation(s);
    }

    Rotation composeRotation(Rotation s) {
        return new Rotation(this.quaternion.composeRotation(s.quaternion));
    }

    Rotation inverseRotation() {
        return new Rotation(this.quaternion.inverseRotation());
    }

    Coord3 toHeadingPitchRoll() {
        return new Coord3();
    }
}

