/*
 * Decompiled with CFR 0.152.
 */
class Quaternion {
    Coord3 qaxis;
    double phase;

    Quaternion(double x, double y, double z, double w) {
        this.qaxis = new Coord3(x, y, z);
        this.phase = w;
    }

    Quaternion() {
        this.qaxis = new Coord3();
        this.phase = 1.0;
    }

    Quaternion(Coord3 a, double p) {
        this.qaxis = a;
        this.phase = p;
    }

    Quaternion(Coord3Rotation v) {
        double angle = v.RotAngle() * 0.5;
        this.qaxis = v.RotAxis().scaleCoord3(Math.sin(angle));
        this.phase = Math.cos(angle);
    }

    Quaternion(RotMatrix m) {
        double angle = m.RotAngle() * 0.5;
        this.qaxis = m.RotAxis().scaleCoord3(Math.sin(angle));
        this.phase = Math.cos(angle);
    }

    Quaternion(VRMLRotation v) {
        double angle = v.RotAngle() * 0.5;
        this.qaxis = v.RotAxis().scaleCoord3(Math.sin(angle));
        this.phase = Math.cos(angle);
    }

    String makeString() {
        return String.valueOf(this.qaxis.makeString()) + "[" + this.phase + "]";
    }

    Coord3Rotation toCoord3Rotation() {
        return new Coord3Rotation(this);
    }

    VRMLRotation toVRMLRotation() {
        return new VRMLRotation(this);
    }

    RotMatrix toRotMatrix() {
        return new RotMatrix(this);
    }

    double SinPhase() {
        return this.qaxis.length();
    }

    Coord3 RotAxis() {
        if (this.phase == 1.0) {
            return new Coord3(0.0, 0.0, 1.0);
        }
        return this.qaxis.unitVector();
    }

    double RotAngle() {
        return Math.atan2(this.SinPhase(), this.phase) * 2.0;
    }

    Coord3 applyRotation(Coord3 s) {
        if (this.phase == 1.0) {
            return s;
        }
        Coord3 cp = this.qaxis.crossProduct(s);
        if (cp.length() == 0.0) {
            return s;
        }
        double dp = this.qaxis.dotProduct(s);
        double angle = this.RotAngle();
        double ql = this.qaxis.length();
        Coord3 parallelComponent = this.qaxis.scaleCoord3(dp / (ql * ql));
        Coord3 perpComponent = s.subtractCoord3(parallelComponent).scaleCoord3(Math.cos(angle));
        Coord3 thirdComponent = cp.scaleCoord3(Math.sin(angle) / ql);
        return parallelComponent.addCoord3(perpComponent).addCoord3(thirdComponent);
    }

    Quaternion composeRotation(Quaternion q) {
        return new Quaternion(q.phase * this.qaxis.xyz[0] + q.qaxis.xyz[0] * this.phase - q.qaxis.xyz[1] * this.qaxis.xyz[2] - q.qaxis.xyz[2] * this.qaxis.xyz[1], q.phase * this.qaxis.xyz[1] + q.qaxis.xyz[1] * this.phase - q.qaxis.xyz[2] * this.qaxis.xyz[0] - q.qaxis.xyz[0] * this.qaxis.xyz[2], q.phase * this.qaxis.xyz[2] + q.qaxis.xyz[2] * this.phase - q.qaxis.xyz[0] * this.qaxis.xyz[1] - q.qaxis.xyz[1] * this.qaxis.xyz[0], q.phase * this.phase - q.qaxis.xyz[0] * this.qaxis.xyz[0] - q.qaxis.xyz[1] * this.qaxis.xyz[1] - q.qaxis.xyz[2] * this.qaxis.xyz[2]);
    }

    Quaternion inverseRotation() {
        return new Quaternion(this.qaxis, -this.phase);
    }
}

