/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;

class Arm {
    static final double TWOPI = Math.PI * 2;
    static final int NUMJOINTS = 3;
    static final int S_V = 0;
    static final int ELB = 1;
    static final int S_H = 2;
    static final double DEFAULT_INIT_UPPER_LENGTH = 25.0;
    static final double DEFAULT_INIT_LOWER_LENGTH = 25.0;
    static final double DEFAULT_INIT_SH_PITCH = 0.5235987755982988;
    static final double DEFAULT_INIT_ELBOW_ANGLE = 1.2566370614359172;
    static final double DEFAULT_INIT_SH_YAW = 0.0;
    static final double stiffness = 100.0;
    static final double MAXFORCE = 10000.0;
    static final double MAXTORQUE = 100000.0;
    static final double[] minJointAngles;
    static final double[] maxJointAngles;
    double upperLength;
    double lowerLength;
    double[] jointAngles;
    double[] jointAngleVelocities;
    double[] jointTorques;
    boolean alive;
    boolean groundContact;
    boolean standing;
    Checkbox aliveBox = null;
    Checkbox groundBox = null;
    Coord3 translation;
    Rotation orientation;
    Coord3 reactionForce;
    Coord3 reactionTorque;
    double outwardForce = 0.0;
    double transverseForce = 0.0;
    double verticalForce = 0.0;

    Arm() {
        this.initArm(25.0, 25.0, 0.5235987755982988, 1.2566370614359172, 0.0, 0.0, 0.0, 0.0);
    }

    Arm(double ul, double ll, double sva, double ea, double sha, double svt, double et, double sht) {
        this.initArm(ul, ll, sva, ea, sha, svt, et, sht);
    }

    void initArm(double ul, double ll, double sva, double ea, double sha, double svt, double et, double sht) {
        this.upperLength = ul;
        this.lowerLength = ll;
        this.jointAngles = new double[3];
        this.jointAngles[0] = JRKUtils.TrimDouble(minJointAngles[0], sva, maxJointAngles[0]);
        this.jointAngles[1] = JRKUtils.TrimDouble(minJointAngles[1], ea, maxJointAngles[1]);
        this.jointAngles[2] = JRKUtils.TrimDouble(minJointAngles[2], sha, maxJointAngles[2]);
        this.jointAngleVelocities = new double[3];
        this.jointAngleVelocities[0] = 0.0;
        this.jointAngleVelocities[1] = 0.0;
        this.jointAngleVelocities[2] = 0.0;
        this.jointTorques = new double[3];
        this.jointTorques[0] = svt;
        this.jointTorques[1] = et;
        this.jointTorques[2] = sht;
        this.alive = true;
        this.groundContact = true;
        this.standing = true;
        this.translation = new Coord3();
        this.orientation = new Rotation();
        this.UpdateReaction();
    }

    void LoseContact() {
        if (this.groundContact) {
            this.groundContact = false;
            this.groundBox.setState(false);
        }
    }

    void SetFootPos(Coord3 footPos, double delta_t) {
        if (!this.groundContact) {
            return;
        }
        Coord3 localFootPos = this.ParentToArmTransform(footPos);
        double reach = localFootPos.length();
        if (reach >= this.upperLength + this.lowerLength || reach <= Math.abs(this.upperLength - this.lowerLength)) {
            this.LoseContact();
            return;
        }
        double newS_H = Math.atan2(-localFootPos.xyz[2], localFootPos.xyz[0]);
        double cosELB = (this.upperLength * this.upperLength + this.lowerLength * this.lowerLength - reach * reach) / (2.0 * this.upperLength * this.lowerLength);
        if (Math.abs(cosELB) > 1.0) {
            this.LoseContact();
            return;
        }
        double newELB = Math.acos(cosELB);
        double cosS = (this.upperLength * this.upperLength + reach * reach - this.lowerLength * this.lowerLength) / (2.0 * this.upperLength * reach);
        if (Math.abs(cosS) >= 1.0) {
            this.LoseContact();
            return;
        }
        double sinS1 = localFootPos.xyz[1] / reach;
        if (Math.abs(sinS1) >= 1.0) {
            this.LoseContact();
            return;
        }
        double newS_V = JRKUtils.TrimDouble(minJointAngles[0], Math.acos(cosS) + Math.asin(sinS1), maxJointAngles[0]);
        if (delta_t > 0.0) {
            this.jointAngleVelocities[0] = (newS_V - this.jointAngles[0]) / delta_t;
            this.jointAngleVelocities[1] = (newELB - this.jointAngles[1]) / delta_t;
            this.jointAngleVelocities[2] = (newS_H - this.jointAngles[2]) / delta_t;
        }
        this.jointAngles[0] = newS_V;
        this.jointAngles[1] = newELB;
        this.jointAngles[2] = newS_H;
    }

    double horizReach() {
        return this.upperLength * Math.cos(this.jointAngles[0]) + this.lowerLength * Math.cos(this.jointAngles[0] + this.jointAngles[1] - Math.PI);
    }

    double vertReach() {
        return this.upperLength * Math.sin(this.jointAngles[0]) + this.lowerLength * Math.sin(this.jointAngles[0] + this.jointAngles[1] - Math.PI);
    }

    double reach() {
        return Math.sqrt(this.upperLength * this.upperLength + this.lowerLength * this.lowerLength - 2.0 * this.upperLength * this.lowerLength * Math.cos(this.jointAngles[1]));
    }

    Coord3 ArmToParentTransform(Coord3 v) {
        return this.translation.addCoord3(this.orientation.applyRotation(v));
    }

    Coord3 ParentToArmTransform(Coord3 v) {
        return this.orientation.inverseRotation().applyRotation(v.subtractCoord3(this.translation));
    }

    Coord3 GetElbowPos() {
        double csva = Math.cos(this.jointAngles[0]);
        return this.ArmToParentTransform(new Coord3(csva * Math.cos(this.jointAngles[2]), Math.sin(this.jointAngles[0]), -csva * Math.sin(this.jointAngles[2])).scaleCoord3(this.upperLength));
    }

    Coord3 GetFootPos() {
        double hReach = this.horizReach();
        return this.ArmToParentTransform(new Coord3(hReach * Math.cos(this.jointAngles[2]), this.vertReach(), -hReach * Math.sin(this.jointAngles[2])));
    }

    Coord3 GetForce() {
        if (!(this.groundContact && this.standing && this.alive)) {
            return new Coord3();
        }
        double hReach = this.horizReach();
        if (hReach <= 0.0) {
            return new Coord3();
        }
        double vReach = this.vertReach();
        double reach = Math.sqrt(hReach * hReach + vReach * vReach);
        double cosShoulder = (reach * reach + this.upperLength * this.upperLength - this.lowerLength * this.lowerLength) / (2.0 * reach * this.upperLength);
        double sinShoulder = Math.sqrt(1.0 - cosShoulder * cosShoulder);
        double altitude = sinShoulder * this.upperLength;
        if (altitude <= 0.0) {
            this.LoseContact();
            return new Coord3();
        }
        double sinElbow = Math.sin(this.jointAngles[1]);
        if (sinElbow == 0.0) {
            this.LoseContact();
            return new Coord3();
        }
        double shoulderVforce = -this.jointTorques[0] / (this.upperLength * sinElbow);
        double shoulderHforce = this.jointTorques[2] / hReach;
        double elbowForce = -this.jointTorques[1] / altitude;
        double shoulderForceAngle = this.jointAngles[0] + this.jointAngles[1];
        Coord3 shoulderVforceVec = new Coord3(shoulderVforce * Math.cos(shoulderForceAngle), shoulderVforce * Math.sin(shoulderForceAngle), 0.0);
        Coord3 shoulderHforceVec = new Coord3(0.0, 0.0, shoulderHforce);
        double shoulderAngle = Math.atan2(sinShoulder, cosShoulder);
        double elbowForceAngle = this.jointAngles[0] - shoulderAngle;
        Coord3 elbowForceVec = new Coord3(elbowForce * Math.cos(elbowForceAngle), elbowForce * Math.sin(elbowForceAngle), 0.0);
        Coord3 totalForce = shoulderVforceVec.addCoord3(shoulderHforceVec).addCoord3(elbowForceVec);
        this.outwardForce = totalForce.xyz[0];
        this.transverseForce = totalForce.xyz[2];
        this.verticalForce = totalForce.xyz[1];
        return new VRMLRotation(0.0, 1.0, 0.0, this.jointAngles[2]).applyRotation(totalForce);
    }

    Coord3 GetTorque() {
        if (!(this.groundContact && this.standing && this.alive)) {
            return new Coord3();
        }
        return new VRMLRotation(0.0, 1.0, 0.0, this.jointAngles[2]).applyRotation(new Coord3(0.0, -this.jointTorques[2], -this.jointTorques[0]));
    }

    void UpdateReaction() {
        if (this.groundContact && this.standing && this.alive) {
            Coord3 localReaction = this.GetForce();
            this.reactionForce = this.orientation.applyRotation(localReaction);
            this.reactionTorque = this.orientation.applyRotation(this.GetTorque()).addCoord3(this.translation.crossProduct(this.reactionForce));
        } else {
            this.reactionForce = new Coord3();
            this.reactionTorque = new Coord3();
            this.outwardForce = 0.0;
            this.transverseForce = 0.0;
            this.verticalForce = 0.0;
        }
    }

    String makeString() {
        return "Arm( uL  " + this.upperLength + "    lL " + this.lowerLength + "\n     sVa " + this.jointAngles[0] + "    eA  " + this.jointAngles[1] + "\n     sHa " + this.jointAngles[2] + "\n     sVt " + this.jointTorques[0] + "    eT  " + this.jointTorques[1] + "\n     sHt " + this.jointTorques[2] + "\n     hR  " + this.horizReach() + "    vR  " + this.vertReach() + "\n     rF  " + this.reactionForce.makeString() + "    rT  " + this.reactionTorque.makeString() + " )\n";
    }

    static {
        double[] dArray = new double[3];
        dArray[0] = -1.5707963267948966;
        dArray[2] = -1.5707963267948966;
        minJointAngles = dArray;
        maxJointAngles = new double[]{1.5707963267948966, Math.PI, 1.5707963267948966};
    }
}

